/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service.model;

import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.model.Filter;
import io.swagger.v3.oas.models.OpenAPI;

public class OASServiceMetadata {
    private final OpenAPI openAPI;
    private final Filter filters;
    private final boolean nullable;
    private final boolean generateServiceType;
    private final boolean generateServiceContract;
    private final boolean generateWithoutDataBinding;
    private final String licenseHeader;
    private final String srcPackage;
    private final String srcFile;
    private final boolean isUsingSanitizedOas;
    private final String serviceObjectTypeName;

    private OASServiceMetadata(Builder serviceMetadataBuilder) {
        this.openAPI = serviceMetadataBuilder.openAPI;
        this.filters = serviceMetadataBuilder.filters;
        this.nullable = serviceMetadataBuilder.nullable;
        this.generateServiceType = serviceMetadataBuilder.generateServiceType;
        this.generateServiceContract = serviceMetadataBuilder.generateServiceContract;
        this.generateWithoutDataBinding = serviceMetadataBuilder.generateWithoutDataBinding;
        this.licenseHeader = serviceMetadataBuilder.licenseHeader;
        this.srcPackage = serviceMetadataBuilder.srcPackage;
        this.srcFile = serviceMetadataBuilder.srcFile;
        this.isUsingSanitizedOas = serviceMetadataBuilder.isUsingSanitizedOas;
        this.serviceObjectTypeName = serviceMetadataBuilder.serviceObjectTypeName;
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    public Filter getFilters() {
        return this.filters;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isServiceTypeRequired() {
        return this.generateServiceType;
    }

    public boolean isServiceContractRequired() {
        return this.generateServiceContract;
    }

    public boolean generateWithoutDataBinding() {
        return this.generateWithoutDataBinding;
    }

    public String getLicenseHeader() {
        return this.licenseHeader;
    }

    public String getSrcPackage() {
        return this.srcPackage;
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    public boolean isUsingSanitizedOas() {
        return this.isUsingSanitizedOas;
    }

    public String getServiceObjectTypeName() {
        return this.serviceObjectTypeName;
    }

    public static class Builder {
        private OpenAPI openAPI;
        private Filter filters;
        private boolean nullable = false;
        private boolean generateServiceType = false;
        private boolean generateServiceContract = false;
        private boolean generateWithoutDataBinding = false;
        private String licenseHeader = "";
        private String srcPackage = "";
        private String srcFile = "";
        private boolean isUsingSanitizedOas = false;
        private String serviceObjectTypeName = "OASServiceType";

        public Builder withOpenAPI(OpenAPI openAPI) {
            this.openAPI = openAPI;
            return this;
        }

        public Builder withFilters(Filter filters) {
            this.filters = filters;
            return this;
        }

        public Builder withNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder withGenerateServiceType(boolean generateServiceType) {
            this.generateServiceType = generateServiceType;
            return this;
        }

        public Builder withGenerateServiceContract(boolean generateServiceContract) {
            this.generateServiceContract = generateServiceContract;
            return this;
        }

        public Builder withGenerateWithoutDataBinding(boolean generateWithoutDataBinding) {
            this.generateWithoutDataBinding = generateWithoutDataBinding;
            return this;
        }

        public Builder withLicenseHeader(String licenseHeader) {
            this.licenseHeader = licenseHeader;
            return this;
        }

        public Builder withSrcPackage(String srcPackage) {
            this.srcPackage = srcPackage;
            return this;
        }

        public Builder withSrcFile(String srcFile) {
            this.srcFile = srcFile;
            return this;
        }

        public Builder withIsUsingSanitizedOas(boolean isUsingSanitizedOas) {
            this.isUsingSanitizedOas = isUsingSanitizedOas;
            return this;
        }

        public Builder withServiceObjectTypeName(String serviceObjectTypeName) {
            this.serviceObjectTypeName = serviceObjectTypeName == null || serviceObjectTypeName.trim().isEmpty() ? "OASServiceType" : GeneratorUtils.escapeIdentifier(serviceObjectTypeName);
            return this;
        }

        public OASServiceMetadata build() {
            return new OASServiceMetadata(this);
        }
    }
}

