/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service.resource;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.service.resource.DefaultResourceGenerator;
import io.ballerina.openapi.core.generators.service.resource.LowResourceGenerator;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ResourceGenerator {
    final OASServiceMetadata oasServiceMetadata;
    boolean isNullableRequired;
    final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    protected ResourceGenerator(OASServiceMetadata oasServiceMetadata) {
        this.oasServiceMetadata = oasServiceMetadata;
    }

    public boolean isNullableRequired() {
        return this.isNullableRequired;
    }

    public static ResourceGenerator createResourceGenerator(OASServiceMetadata oasServiceMetadata) {
        if (oasServiceMetadata.generateWithoutDataBinding()) {
            return new LowResourceGenerator(oasServiceMetadata);
        }
        return new DefaultResourceGenerator(oasServiceMetadata);
    }

    public abstract FunctionDefinitionNode generateResourceFunction(Map.Entry<PathItem.HttpMethod, Operation> var1, String var2) throws BallerinaOpenApiException;

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

