/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.openapi.core.generators.type.TypeGeneratorUtils;
import io.ballerina.openapi.core.generators.type.diagnostic.TypeGenerationDiagnosticMessages;
import io.ballerina.openapi.core.generators.type.diagnostic.TypeGeneratorDiagnostic;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.openapi.core.generators.type.generators.AllOfRecordTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.ArrayTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.PrimitiveTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.RecordTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.TypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.UnionTypeGenerator;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.ballerina.openapi.core.generators.type.model.TypeGeneratorResult;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class BallerinaTypesGenerator {
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public BallerinaTypesGenerator(OpenAPI openAPI, boolean isNullable) {
        GeneratorMetaData.createInstance(openAPI, isNullable);
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public TypeGeneratorResult generateTypeDescriptorNodeForOASSchema(Schema<?> schema, boolean ignoreNullableFlag) {
        Optional<TypeDescriptorNode> typeDescriptorNode;
        HashMap<String, TypeDefinitionNode> subtypesMap = new HashMap<String, TypeDefinitionNode>();
        try {
            typeDescriptorNode = this.generateTypeDescriptorNodeForOASSchema(schema, ignoreNullableFlag, subtypesMap, new HashMap<String, NameReferenceNode>());
        }
        catch (InvalidReferenceException | OASTypeGenException e) {
            TypeGeneratorDiagnostic diagnostic = new TypeGeneratorDiagnostic(TypeGenerationDiagnosticMessages.OAS_TYPE_103, e.getMessage());
            this.diagnostics.add(diagnostic);
            return new TypeGeneratorResult(Optional.empty(), subtypesMap);
        }
        return new TypeGeneratorResult(typeDescriptorNode, subtypesMap);
    }

    private Optional<TypeDescriptorNode> generateTypeDescriptorNodeForOASSchema(Schema<?> schema, boolean ignoreNullableFlag, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) throws InvalidReferenceException, OASTypeGenException {
        if (schema == null) {
            return Optional.empty();
        }
        if (schema.get$ref() != null) {
            String schemaName = GeneratorUtils.extractReferenceType(schema.get$ref());
            String typeName = GeneratorUtils.escapeIdentifier(schemaName);
            if (!pregeneratedTypeMap.containsKey(typeName)) {
                schema = (Schema)GeneratorMetaData.getInstance().getOpenAPI().getComponents().getSchemas().get(schemaName);
                if (schema == null) {
                    schema = (Schema)GeneratorMetaData.getInstance().getOpenAPI().getComponents().getSchemas().get(schemaName);
                }
                TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator(schema, GeneratorUtils.escapeIdentifier(typeName.trim()), null, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
                TypeDescriptorNode typeDescriptorNode = typeGenerator.generateTypeDescriptorNode();
                TypeDefinitionNode typeDefinitionNode = NodeFactory.createTypeDefinitionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)typeName), (Node)typeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
                this.diagnostics.addAll(typeGenerator.getDiagnostics());
                pregeneratedTypeMap.put(typeName, (NameReferenceNode)this.getSimpleNameReferenceNode(typeName));
                subTypesMap.put(typeName, typeDefinitionNode);
            }
            return Optional.ofNullable(this.getSimpleNameReferenceNode(typeName));
        }
        if (GeneratorUtils.isMapSchema(schema)) {
            RecordTypeGenerator recordTypeGenerator = new RecordTypeGenerator(schema, null, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
            TypeDescriptorNode record = recordTypeGenerator.generateTypeDescriptorNode();
            this.diagnostics.addAll(recordTypeGenerator.getDiagnostics());
            return Optional.ofNullable(record);
        }
        if (GeneratorUtils.getOpenAPIType(schema) != null) {
            boolean isPrimitiveType;
            String schemaType = GeneratorUtils.getOpenAPIType(schema);
            boolean bl = isPrimitiveType = schemaType.equals("integer") || schemaType.equals("number") || schemaType.equals("boolean") || schemaType.equals("string");
            if (GeneratorUtils.isArraySchema(schema)) {
                ArrayTypeGenerator arrayTypeGenerator = new ArrayTypeGenerator(schema, null, ignoreNullableFlag, schemaType, subTypesMap, pregeneratedTypeMap);
                return arrayTypeGenerator.getTypeDescNodeForArraySchema(schema, subTypesMap);
            }
            if (isPrimitiveType) {
                PrimitiveTypeGenerator primitiveTypeGenerator = new PrimitiveTypeGenerator(schema, null, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
                TypeDescriptorNode typeDescriptorNode = primitiveTypeGenerator.generateTypeDescriptorNode();
                this.diagnostics.addAll(primitiveTypeGenerator.getDiagnostics());
                return Optional.ofNullable(typeDescriptorNode);
            }
            if (schemaType.equals("object") || GeneratorUtils.isObjectSchema(schema)) {
                RecordTypeGenerator recordTypeGenerator = new RecordTypeGenerator(schema, null, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
                TypeDescriptorNode typeDescriptorNode = recordTypeGenerator.generateTypeDescriptorNode();
                this.diagnostics.addAll(recordTypeGenerator.getDiagnostics());
                return Optional.ofNullable(typeDescriptorNode);
            }
            return Optional.empty();
        }
        if (schema.getOneOf() != null) {
            return Optional.ofNullable(this.getUnionNodeForOneOf(schema, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap));
        }
        if (schema.getAllOf() != null) {
            AllOfRecordTypeGenerator allOfRecordTypeGenerator = new AllOfRecordTypeGenerator(schema, null, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
            TypeDescriptorNode typeDescriptorNode = allOfRecordTypeGenerator.generateTypeDescriptorNode();
            this.diagnostics.addAll(allOfRecordTypeGenerator.getDiagnostics());
            return Optional.ofNullable(typeDescriptorNode);
        }
        if (schema.getAnyOf() != null) {
            UnionTypeGenerator unionTypeGenerator = new UnionTypeGenerator((Schema<?>)schema, null, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
            return Optional.ofNullable(unionTypeGenerator.generateTypeDescriptorNode());
        }
        return Optional.empty();
    }

    private TypeDescriptorNode getUnionNodeForOneOf(Schema<?> schema, boolean ignoreNullableFlag, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) throws OASTypeGenException, InvalidReferenceException {
        Iterator iterator = schema.getOneOf().iterator();
        ArrayList<TypeDescriptorNode> qualifiedNodes = new ArrayList<TypeDescriptorNode>();
        IdentifierToken pipeToken = AbstractNodeFactory.createIdentifierToken((String)"|");
        while (iterator.hasNext()) {
            Schema contentType = (Schema)iterator.next();
            Optional<TypeDescriptorNode> qualifiedNodeType = this.generateTypeDescriptorNodeForOASSchema(contentType, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
            if (qualifiedNodeType.isEmpty()) continue;
            qualifiedNodes.add(qualifiedNodeType.get());
        }
        TypeDescriptorNode right = (TypeDescriptorNode)qualifiedNodes.get(qualifiedNodes.size() - 1);
        TypeDescriptorNode traversRight = (TypeDescriptorNode)qualifiedNodes.get(qualifiedNodes.size() - 2);
        UnionTypeDescriptorNode traversUnion = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)traversRight, (Token)pipeToken, (TypeDescriptorNode)right);
        if (qualifiedNodes.size() >= 3) {
            for (int i = qualifiedNodes.size() - 3; i >= 0; --i) {
                traversUnion = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)((TypeDescriptorNode)qualifiedNodes.get(i)), (Token)pipeToken, (TypeDescriptorNode)traversUnion);
            }
        }
        return traversUnion;
    }

    private SimpleNameReferenceNode getSimpleNameReferenceNode(String name) {
        return NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)name));
    }
}

