/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type.generators;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.exception.UnsupportedOASDataTypeException;
import io.ballerina.openapi.core.generators.type.GeneratorConstants;
import io.ballerina.openapi.core.generators.type.TypeGeneratorUtils;
import io.ballerina.openapi.core.generators.type.diagnostic.TypeGenerationDiagnosticMessages;
import io.ballerina.openapi.core.generators.type.diagnostic.TypeGeneratorDiagnostic;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.openapi.core.generators.type.generators.PrimitiveTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.TypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.UnionTypeGenerator;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ArrayTypeGenerator
extends TypeGenerator {
    private String parentType;

    public ArrayTypeGenerator(Schema schema, String typeName, boolean ignoreNullableFlag, String parentType, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) {
        super(schema, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
        this.parentType = parentType;
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws OASTypeGenException {
        TypeGenerator typeGenerator;
        boolean isConstraintsAvailable;
        Schema items = this.schema.getItems();
        boolean bl = isConstraintsAvailable = !GeneratorMetaData.getInstance().isNullable() && GeneratorUtils.hasConstraints(items) && this.typeName != null;
        if (isConstraintsAvailable) {
            String normalizedTypeName = this.typeName.replaceAll("([\\[\\]\\\\?!<>@#&~`*\\-=^+'();:\\/\\_{}\\s|.$])", "").trim();
            String itemType = StringUtils.capitalize((String)GeneratorUtils.getOpenAPIType(items));
            String fieldName = StringUtils.capitalize((String)normalizedTypeName);
            this.typeName = GeneratorUtils.escapeIdentifier(this.parentType != null ? this.parentType + fieldName + "Items" + itemType : fieldName + "Items" + itemType);
            typeGenerator = TypeGeneratorUtils.getTypeGenerator(items, this.typeName, null, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
            if (!this.pregeneratedTypeMap.containsKey(this.typeName)) {
                this.pregeneratedTypeMap.put(this.typeName, NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)this.typeName)));
                TypeDefinitionNode arrayItemWithConstraint = typeGenerator.generateTypeDefinitionNode(AbstractNodeFactory.createIdentifierToken((String)this.typeName));
                this.imports.addAll(typeGenerator.getImports());
                this.subTypesMap.put(this.typeName, arrayItemWithConstraint);
            }
        } else {
            typeGenerator = TypeGeneratorUtils.getTypeGenerator(items, this.typeName, null, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
        }
        TypeDescriptorNode typeDescriptorNode = (typeGenerator instanceof PrimitiveTypeGenerator || typeGenerator instanceof ArrayTypeGenerator) && isConstraintsAvailable ? NodeParser.parseTypeDescriptor((String)this.typeName) : typeGenerator.generateTypeDescriptorNode();
        if (typeGenerator instanceof UnionTypeGenerator || items.getEnum() != null && !items.getEnum().isEmpty()) {
            typeDescriptorNode = NodeFactory.createParenthesisedTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (TypeDescriptorNode)typeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        }
        if (typeDescriptorNode instanceof OptionalTypeDescriptorNode) {
            Node node = ((OptionalTypeDescriptorNode)typeDescriptorNode).typeDescriptor();
            typeDescriptorNode = (TypeDescriptorNode)node;
        }
        if (this.schema.getMaxItems() != null && this.schema.getMaxItems() > GeneratorConstants.MAX_ARRAY_LENGTH) {
            this.diagnostics.add(new TypeGeneratorDiagnostic(TypeGenerationDiagnosticMessages.OAS_TYPE_101, this.schema.getMaxItems().toString()));
            this.schema.setMaxItems(GeneratorConstants.MAX_ARRAY_LENGTH);
        }
        NodeList arrayDimensions = NodeFactory.createEmptyNodeList();
        if (typeDescriptorNode.kind() == SyntaxKind.ARRAY_TYPE_DESC) {
            ArrayTypeDescriptorNode innerArrayType = (ArrayTypeDescriptorNode)typeDescriptorNode;
            arrayDimensions = innerArrayType.dimensions();
            typeDescriptorNode = innerArrayType.memberTypeDesc();
        }
        ArrayDimensionNode arrayDimension = NodeFactory.createArrayDimensionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
        arrayDimensions = arrayDimensions.add((Node)arrayDimension);
        ArrayTypeDescriptorNode arrayTypeDescriptorNode = NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)typeDescriptorNode, (NodeList)arrayDimensions);
        this.imports.addAll(typeGenerator.getImports());
        return TypeGeneratorUtils.getNullableType(this.schema, (TypeDescriptorNode)arrayTypeDescriptorNode, this.ignoreNullableFlag);
    }

    public Optional<TypeDescriptorNode> getTypeDescNodeForArraySchema(Schema schema, HashMap<String, TypeDefinitionNode> subTypesMap) throws OASTypeGenException {
        BuiltinSimpleNameReferenceNode member;
        String schemaType = GeneratorUtils.getOpenAPIType(schema.getItems());
        if (schema.getItems().get$ref() != null) {
            String typeName = null;
            try {
                typeName = GeneratorUtils.extractReferenceType(schema.getItems().get$ref());
            }
            catch (BallerinaOpenApiException e) {
                throw new OASTypeGenException(e.getMessage());
            }
            String validTypeName = GeneratorUtils.escapeIdentifier(typeName);
            TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator((Schema)GeneratorMetaData.getInstance().getOpenAPI().getComponents().getSchemas().get(typeName), validTypeName, null, this.ignoreNullableFlag, subTypesMap, this.pregeneratedTypeMap);
            if (!this.pregeneratedTypeMap.containsKey(validTypeName)) {
                this.pregeneratedTypeMap.put(validTypeName, NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)validTypeName)));
                TypeDefinitionNode typeDefinitionNode = typeGenerator.generateTypeDefinitionNode(AbstractNodeFactory.createIdentifierToken((String)validTypeName));
                subTypesMap.put(validTypeName, typeDefinitionNode);
            }
            member = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)validTypeName));
        } else if (schemaType != null && (schemaType.equals("integer") || schemaType.equals("number") || schemaType.equals("boolean") || schemaType.equals("string"))) {
            try {
                member = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.convertOpenAPITypeToBallerina(schema.getItems(), this.ignoreNullableFlag)));
            }
            catch (UnsupportedOASDataTypeException e) {
                throw new OASTypeGenException(e.getDiagnostic().message());
            }
        } else if (schemaType != null && schemaType.equals("array")) {
            member = this.getTypeDescNodeForArraySchema(schema.getItems(), subTypesMap).orElse(null);
        } else if (schema.getItems() != null) {
            TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator(schema.getItems(), this.typeName, this.parentType, this.ignoreNullableFlag, subTypesMap, this.pregeneratedTypeMap);
            member = typeGenerator.generateTypeDescriptorNode();
        } else {
            return Optional.empty();
        }
        if (schema.getItems().getEnum() != null || ArrayTypeGenerator.isUnionType((TypeDescriptorNode)member)) {
            member = NodeFactory.createParenthesisedTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (TypeDescriptorNode)member, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        }
        return Optional.ofNullable(this.getArrayTypeDescriptorNodeFromTypeDescriptorNode((TypeDescriptorNode)member));
    }

    private static boolean isUnionType(TypeDescriptorNode member) {
        return Objects.nonNull(member) && Objects.nonNull(member.kind()) && member.kind().equals((Object)SyntaxKind.UNION_TYPE_DESC);
    }

    private ArrayTypeDescriptorNode getArrayTypeDescriptorNodeFromTypeDescriptorNode(TypeDescriptorNode typeDescriptorNode) {
        ArrayDimensionNode arrayDimensionNode = NodeFactory.createArrayDimensionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
        NodeList nodeList = AbstractNodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode});
        return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)typeDescriptorNode, (NodeList)nodeList);
    }
}

