/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers.env;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.configurable.ConfigProvider;
import io.ballerina.runtime.internal.configurable.ConfigValue;
import io.ballerina.runtime.internal.configurable.VariableKey;
import io.ballerina.runtime.internal.configurable.exceptions.ConfigException;
import io.ballerina.runtime.internal.configurable.providers.ConfigUtils;
import io.ballerina.runtime.internal.configurable.providers.env.EnvConfigValue;
import io.ballerina.runtime.internal.diagnostics.RuntimeDiagnosticLog;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BTypeReferenceType;
import io.ballerina.runtime.internal.types.BUnionType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class EnvVarProvider
implements ConfigProvider {
    private final Module rootModule;
    private final Map<String, String> envVariables;
    private final Map<String, VariableKey> visitedEnvVariableMap = new HashMap<String, VariableKey>();
    private static final String ENV_VAR_PREFIX = "BAL_CONFIG_VAR_";

    public EnvVarProvider(Module rootModule, Map<String, String> envVariables) {
        this.rootModule = rootModule;
        this.envVariables = this.filterConfigEnvVariables(envVariables);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void complete(RuntimeDiagnosticLog diagnosticLog) {
        Set<String> varKeySet = this.envVariables.keySet();
        varKeySet.removeAll(this.visitedEnvVariableMap.keySet());
        if (varKeySet.isEmpty()) {
            return;
        }
        for (String key : varKeySet) {
            diagnosticLog.error(ErrorCodes.CONFIG_UNUSED_ENV_VARS, null, key);
        }
    }

    @Override
    public boolean hasConfigs() {
        return !this.envVariables.isEmpty();
    }

    @Override
    public Optional<ConfigValue> getAsIntAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        try {
            return this.getEnvConfigValue(TypeConverter.stringToInt(envVar.value));
        }
        catch (NumberFormatException e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, envVar, key.variable, key.type, envVar.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsByteAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        try {
            return this.getEnvConfigValue(TypeConverter.stringToByte(envVar.value));
        }
        catch (NumberFormatException e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, envVar, key.variable, key.type, envVar.value);
        }
        catch (BError e) {
            throw new ConfigException(ErrorCodes.CONFIG_INVALID_BYTE_RANGE, envVar, key.variable, envVar.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsBooleanAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        try {
            return this.getEnvConfigValue(TypeConverter.stringToBoolean(envVar.value));
        }
        catch (NumberFormatException e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, envVar, key.variable, key.type, envVar.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsFloatAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        try {
            return this.getEnvConfigValue(TypeConverter.stringToFloat(envVar.value));
        }
        catch (NumberFormatException e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, envVar, key.variable, key.type, envVar.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsDecimalAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        try {
            return this.getEnvConfigValue(TypeConverter.stringToDecimal(envVar.value));
        }
        catch (BError | NumberFormatException e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, envVar, key.variable, key.type, envVar.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsStringAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        return this.getEnvConfigValue(StringUtils.fromString(envVar.value));
    }

    @Override
    public Optional<ConfigValue> getAsArrayAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        throw new ConfigException(ErrorCodes.CONFIG_ENV_TYPE_NOT_SUPPORTED, key.variable, effectiveType);
    }

    @Override
    public Optional<ConfigValue> getAsRecordAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        throw new ConfigException(ErrorCodes.CONFIG_ENV_TYPE_NOT_SUPPORTED, key.variable, effectiveType);
    }

    @Override
    public Optional<ConfigValue> getAsMapAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        throw new ConfigException(ErrorCodes.CONFIG_ENV_TYPE_NOT_SUPPORTED, key.variable, effectiveType);
    }

    @Override
    public Optional<ConfigValue> getAsTableAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        throw new ConfigException(ErrorCodes.CONFIG_ENV_TYPE_NOT_SUPPORTED, key.variable, effectiveType);
    }

    @Override
    public Optional<ConfigValue> getAsUnionAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        BUnionType unionType = (BUnionType)((BIntersectionType)key.type).getEffectiveType();
        boolean isEnum = SymbolFlags.isFlagOn(unionType.getFlags(), 0x200000000L);
        if (envVar.value == null) {
            return Optional.empty();
        }
        if (!isEnum && ConfigUtils.containsUnsupportedMembers(unionType)) {
            throw new ConfigException(ErrorCodes.CONFIG_ENV_TYPE_NOT_SUPPORTED, key.variable, unionType);
        }
        if (isEnum) {
            return this.getEnvConfigValue(ConfigUtils.getFiniteValue(key, unionType, envVar.value, envVar.toString()));
        }
        return this.getEnvConfigValue(ConfigUtils.getUnionValue(key, unionType, envVar.value, envVar.toString()));
    }

    @Override
    public Optional<ConfigValue> getAsFiniteAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        BFiniteType type = key.type.getTag() == 34 ? (BFiniteType)((IntersectionType)key.type).getEffectiveType() : (key.type.getTag() == 53 ? (BFiniteType)((BTypeReferenceType)key.type).getReferredType() : (BFiniteType)key.type);
        Object value = ConfigUtils.getFiniteBalValue(envVar.value, type, key, envVar.toString());
        return this.getEnvConfigValue(value);
    }

    @Override
    public Optional<ConfigValue> getAsXmlAndMark(Module module, VariableKey key) {
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        try {
            return this.getEnvConfigValue(TypeConverter.stringToXml(envVar.value));
        }
        catch (BError e) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, envVar, key.variable, effectiveType, envVar.value);
        }
    }

    @Override
    public Optional<ConfigValue> getAsTupleAndMark(Module module, VariableKey key) {
        EnvVar envVar = this.getEnvVar(module, key);
        if (envVar.value == null) {
            return Optional.empty();
        }
        Type effectiveType = ((IntersectionType)key.type).getEffectiveType();
        throw new ConfigException(ErrorCodes.CONFIG_ENV_TYPE_NOT_SUPPORTED, key.variable, effectiveType);
    }

    private EnvVar getEnvVar(Module module, VariableKey variableKey) {
        String key = EnvVarProvider.getRefinedEnvVarKey(module.getOrg() + "_" + module.getName() + "_" + variableKey.variable);
        String value = this.envVariables.get(key);
        if (value != null || !this.rootModule.getOrg().equals(module.getOrg())) {
            return this.markAndGetEnvVar(key, variableKey, value);
        }
        String rootOrgValue = null;
        if (this.rootModule.getName().equals(module.getName())) {
            rootOrgValue = this.envVariables.get(EnvVarProvider.getRefinedEnvVarKey(variableKey.variable));
        }
        String moduleKey = EnvVarProvider.getRefinedEnvVarKey(module.getName() + "_" + variableKey.variable);
        String rootModuleValue = this.envVariables.get(moduleKey);
        return this.checkAmbiguitiesAndGetEnvVar(variableKey, key, moduleKey, rootOrgValue, rootModuleValue);
    }

    private static String getRefinedEnvVarKey(String key) {
        return ENV_VAR_PREFIX + key.replace(".", "_").toUpperCase(Locale.ROOT);
    }

    private EnvVar checkAmbiguitiesAndGetEnvVar(VariableKey variableKey, String key, String moduleKey, String rootOrgValue, String rootModuleValue) {
        if (rootOrgValue == null && rootModuleValue == null) {
            return this.markAndGetEnvVar(key, variableKey, null);
        }
        String refinedEnvVarKey = EnvVarProvider.getRefinedEnvVarKey(variableKey.variable);
        if (rootOrgValue != null && rootModuleValue == null) {
            return this.markAndGetEnvVar(refinedEnvVarKey, variableKey, rootOrgValue);
        }
        if (rootOrgValue == null) {
            return this.markAndGetEnvVar(moduleKey, variableKey, rootModuleValue);
        }
        StringBuilder errorString = new StringBuilder();
        errorString.append("[").append(refinedEnvVarKey).append("=").append(rootOrgValue);
        this.visitedEnvVariableMap.put(refinedEnvVarKey, variableKey);
        this.visitedEnvVariableMap.put(moduleKey, variableKey);
        errorString.append(", ").append(moduleKey).append("=").append(rootModuleValue);
        errorString.append("]");
        throw new ConfigException(ErrorCodes.CONFIG_ENV_VARS_AMBIGUITY, variableKey.variable, errorString);
    }

    private EnvVar markAndGetEnvVar(String key, VariableKey variableKey, String value) {
        VariableKey existingKey = this.visitedEnvVariableMap.get(key);
        if (existingKey != null) {
            String fullQualifiedKey2;
            Module currentModule = variableKey.module;
            Module existingModule = existingKey.module;
            String fullQualifiedKey1 = EnvVarProvider.getRefinedEnvVarKey(currentModule.getOrg() + "." + currentModule.getName() + "." + variableKey.variable);
            if (fullQualifiedKey1.equalsIgnoreCase(fullQualifiedKey2 = EnvVarProvider.getRefinedEnvVarKey(existingModule.getOrg() + "." + existingModule.getName() + "." + variableKey.variable))) {
                throw new ConfigException(ErrorCodes.CONFIG_ENV_VAR_NAME_AMBIGUITY, key, variableKey.toString(), existingKey.toString());
            }
            throw new ConfigException(ErrorCodes.CONFIG_ENV_VARIABLE_AMBIGUITY, variableKey.toString(), existingKey.toString(), fullQualifiedKey1 + "=<value>");
        }
        this.visitedEnvVariableMap.put(key, variableKey);
        return new EnvVar(key, value);
    }

    private Optional<ConfigValue> getEnvConfigValue(Object value) {
        return Optional.of(new EnvConfigValue(value));
    }

    private Map<String, String> filterConfigEnvVariables(Map<String, String> originalMap) {
        HashMap<String, String> filteredMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : originalMap.entrySet()) {
            if (!entry.getKey().startsWith(ENV_VAR_PREFIX)) continue;
            filteredMap.put(entry.getKey(), entry.getValue());
        }
        return filteredMap;
    }

    public static class EnvVar {
        public String key;
        public String value;

        public EnvVar(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

