/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.scheduling;

import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.WorkerChannelMap;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;

public class Strand {
    private final int id = nextStrandId.incrementAndGet();
    private static final AtomicInteger nextStrandId = new AtomicInteger(0);
    private Map<String, Object> globalProps;
    public final String name;
    public final boolean isIsolated;
    public boolean cancelled;
    public Scheduler scheduler;
    public TransactionLocalContext currentTrxContext;
    public Stack<TransactionLocalContext> trxContexts;
    public WorkerChannelMap workerChannelMap;
    public int acquiredLockCount;

    public Strand(Scheduler scheduler, String strandName, Strand parent, boolean isIsolated, Map<String, Object> properties, WorkerChannelMap workerChannelMap) {
        this.name = Objects.requireNonNullElse(strandName, "$anon");
        this.scheduler = scheduler;
        this.trxContexts = new Stack();
        this.isIsolated = isIsolated;
        this.globalProps = properties != null ? properties : (parent != null && parent.globalProps != null ? new HashMap<String, Object>(parent.globalProps) : new HashMap<String, Object>());
        this.workerChannelMap = workerChannelMap;
    }

    public Strand(Scheduler scheduler, String strandName, Strand parent, boolean isIsolated, Map<String, Object> properties, WorkerChannelMap workerChannelMap, TransactionLocalContext currentTrxContext) {
        this(scheduler, strandName, parent, isIsolated, properties, workerChannelMap);
        if (currentTrxContext != null) {
            this.trxContexts = parent.trxContexts;
            this.trxContexts.push(currentTrxContext);
            this.currentTrxContext = currentTrxContext;
        } else {
            Object currentContext = this.getProperty("currentTrxContext");
            if (currentContext != null) {
                TransactionLocalContext branchedContext = this.createTrxContextBranch((TransactionLocalContext)currentContext, this.id);
                this.setCurrentTransactionContext(branchedContext);
            }
        }
    }

    public void resume() {
        this.checkStrandCancelled();
        if (!this.isIsolated && !this.scheduler.globalNonIsolatedLock.isHeldByCurrentThread()) {
            this.scheduler.globalNonIsolatedLock.lock();
        }
    }

    public void yield() {
        this.checkStrandCancelled();
        if (!this.isIsolated && this.scheduler.globalNonIsolatedLock.isHeldByCurrentThread()) {
            this.scheduler.globalNonIsolatedLock.unlock();
        }
    }

    public void done() {
        if (!this.isIsolated && this.scheduler.globalNonIsolatedLock.isHeldByCurrentThread()) {
            this.scheduler.globalNonIsolatedLock.unlock();
        }
    }

    public boolean isRunnable() {
        return this.isIsolated || this.scheduler.globalNonIsolatedLock.isHeldByCurrentThread();
    }

    private TransactionLocalContext createTrxContextBranch(TransactionLocalContext currentTrxContext, int strandName) {
        TransactionLocalContext trxCtx = TransactionLocalContext.createTransactionParticipantLocalCtx(currentTrxContext.getGlobalTransactionId(), currentTrxContext.getURL(), currentTrxContext.getProtocol(), currentTrxContext.getInfoRecord());
        String currentTrxBlockId = currentTrxContext.getCurrentTransactionBlockId();
        if (currentTrxBlockId.contains("_")) {
            currentTrxBlockId = currentTrxBlockId.split("_")[0];
        }
        trxCtx.addCurrentTransactionBlockId(currentTrxBlockId + "_" + strandName);
        trxCtx.setTransactionContextStore(currentTrxContext.getTransactionContextStore());
        return trxCtx;
    }

    public Object getProperty(String key) {
        return this.globalProps.get(key);
    }

    public void setProperty(String key, Object value) {
        this.globalProps.put(key, value);
    }

    public boolean isInTransaction() {
        return this.currentTrxContext != null && this.currentTrxContext.isTransactional();
    }

    public void removeCurrentTrxContext() {
        if (!this.trxContexts.isEmpty()) {
            this.currentTrxContext = this.trxContexts.pop();
            this.globalProps.put("currentTrxContext", this.currentTrxContext);
            return;
        }
        this.globalProps.remove("currentTrxContext");
        this.currentTrxContext = null;
    }

    public void setCurrentTransactionContext(TransactionLocalContext ctx) {
        if (this.currentTrxContext != null) {
            this.trxContexts.push(this.currentTrxContext);
        }
        this.currentTrxContext = ctx;
        this.globalProps.putIfAbsent("currentTrxContext", this.currentTrxContext);
    }

    public int getId() {
        return this.id;
    }

    public void checkStrandCancelled() {
        if (this.cancelled) {
            throw ErrorUtils.createCancelledFutureError();
        }
    }
}

