/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.FloatType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.ConcurrentLazySupplier;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.BSemTypeWrapper;
import io.ballerina.runtime.internal.types.BType;
import java.util.function.Supplier;

public final class BFloatType
extends BSemTypeWrapper<BFloatTypeImpl>
implements FloatType {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getFloatType();

    public BFloatType(String typeName, Module pkg) {
        this(() -> new BFloatTypeImpl(typeName, pkg), typeName, pkg, Builder.getFloatType());
    }

    private BFloatType(Supplier<BFloatTypeImpl> bType, String typeName, Module pkg, SemType semType) {
        super(new ConcurrentLazySupplier<BFloatTypeImpl>(bType), typeName, pkg, 3, semType);
    }

    public static BFloatType singletonType(Double value) {
        return new BFloatType(() -> new BFloatTypeImpl("float", PredefinedTypes.EMPTY_MODULE), "float", PredefinedTypes.EMPTY_MODULE, Builder.getFloatConst(value));
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    protected static final class BFloatTypeImpl
    extends BType
    implements FloatType {
        private BFloatTypeImpl(String typeName, Module pkg) {
            super(typeName, pkg, Double.class, false);
        }

        @Override
        public <V> V getZeroValue() {
            return (V)new Double(0.0);
        }

        @Override
        public <V> V getEmptyValue() {
            return (V)new Double(0.0);
        }

        @Override
        public int getTag() {
            return 3;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE;
        }
    }
}

