/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.ShapeSupplier;
import io.ballerina.runtime.internal.types.TypeCheckFlyweightStore;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.DefinitionContainer;
import io.ballerina.runtime.internal.types.semtype.MappingDefinition;
import io.ballerina.runtime.internal.types.semtype.TypeCheckCacheFlyweight;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BMapType
extends BType
implements MapType,
TypeWithShape,
Cloneable {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getMappingType();
    private static final TypeCheckFlyweightStore<MappingDefinition> FLYWEIGHT_STORE = new TypeCheckFlyweightStore();
    public static final MappingDefinition.Field[] EMPTY_FIELD_ARR = new MappingDefinition.Field[0];
    private final Type constraint;
    private final boolean readonly;
    private IntersectionType immutableType;
    private IntersectionType intersectionType = null;
    private final DefinitionContainer<MappingDefinition> defn = new DefinitionContainer();
    private final DefinitionContainer<MappingDefinition> acceptedTypeDefn = new DefinitionContainer();

    public BMapType(Type constraint) {
        this(constraint, false);
    }

    public BMapType(Type constraint, boolean readonly) {
        this("map", constraint, null, readonly);
    }

    public BMapType(String typeName, Type constraint, Module pkg) {
        this(typeName, constraint, pkg, false);
    }

    public BMapType(String typeName, Type constraint, Module pkg, boolean readonly) {
        super(typeName, pkg, MapValueImpl.class, false);
        this.constraint = readonly ? ReadOnlyUtils.getReadOnlyType(constraint) : constraint;
        this.readonly = readonly;
        TypeCheckCacheFlyweight<MappingDefinition> flyweight = readonly ? FLYWEIGHT_STORE.getRO(constraint) : FLYWEIGHT_STORE.getRW(constraint);
        this.typeId = flyweight.typeId();
        this.typeCheckCache = flyweight.typeCheckCache();
    }

    @Override
    public Type getConstrainedType() {
        return this.constraint;
    }

    @Deprecated
    public Type getElementType() {
        return this.constraint;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new MapValueImpl(new BMapType(this.constraint));
    }

    @Override
    public <V> V getEmptyValue() {
        return this.getZeroValue();
    }

    @Override
    public int getTag() {
        return 27;
    }

    @Override
    public String toString() {
        Object stringRep = this.constraint == PredefinedTypes.TYPE_ANY ? super.toString() : "map<" + this.constraint.toString() + ">";
        return !this.readonly ? stringRep : ((String)stringRep).concat(" & readonly");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BMapType)) {
            return false;
        }
        BMapType other = (BMapType)obj;
        if (this.readonly != other.readonly) {
            return false;
        }
        if (this.constraint == other.constraint) {
            return true;
        }
        return this.constraint.equals(other.constraint);
    }

    @Override
    public boolean isAnydata() {
        return this.constraint.isAnydata();
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public IntersectionType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    @Override
    public SemType createSemType(Context cx) {
        Env env = cx.env;
        if (this.defn.isDefinitionReady()) {
            return this.defn.getSemType(env);
        }
        DefinitionContainer.DefinitionUpdateResult<MappingDefinition> result = this.defn.trySetDefinition(MappingDefinition::new);
        if (!result.updated()) {
            return this.defn.getSemType(env);
        }
        MappingDefinition md = result.definition();
        CellAtomicType.CellMutability mut = this.isReadOnly() ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
        return this.createSemTypeInner(env, md, BMapType.tryInto(cx, this.getConstrainedType()), mut);
    }

    @Override
    public void resetSemType() {
        this.defn.clear();
        super.resetSemType();
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        if (!this.couldInherentTypeBeDifferent()) {
            return Optional.of(this.getSemType(cx));
        }
        MapValueImpl value = (MapValueImpl)object;
        SemType cachedShape = value.shapeOf();
        if (cachedShape != null) {
            return Optional.of(cachedShape);
        }
        return BMapType.shapeOfInner(cx, shapeSupplier, value);
    }

    @Override
    public boolean couldInherentTypeBeDifferent() {
        return this.isReadOnly();
    }

    @Override
    public Optional<SemType> shapeOf(Context cx, ShapeSupplier shapeSupplierFn, Object object) {
        return BMapType.shapeOfInner(cx, shapeSupplierFn, (MapValueImpl)object);
    }

    @Override
    public synchronized SemType acceptedTypeOf(Context cx) {
        Env env = cx.env;
        if (this.acceptedTypeDefn.isDefinitionReady()) {
            return this.acceptedTypeDefn.getSemType(env);
        }
        DefinitionContainer.DefinitionUpdateResult<MappingDefinition> result = this.acceptedTypeDefn.trySetDefinition(MappingDefinition::new);
        if (!result.updated()) {
            return this.acceptedTypeDefn.getSemType(env);
        }
        MappingDefinition md = result.definition();
        SemType elementType = ShapeAnalyzer.acceptedTypeOf(cx, this.getConstrainedType());
        return this.createSemTypeInner(env, md, elementType, CellAtomicType.CellMutability.CELL_MUT_UNLIMITED);
    }

    static Optional<SemType> shapeOfInner(Context cx, ShapeSupplier shapeSupplier, MapValueImpl<?, ?> value) {
        MappingDefinition readonlyShapeDefinition = value.getReadonlyShapeDefinition();
        if (readonlyShapeDefinition != null) {
            return Optional.of(readonlyShapeDefinition.getSemType(cx.env));
        }
        int nFields = value.size();
        MappingDefinition md = new MappingDefinition();
        value.setReadonlyShapeDefinition(md);
        MappingDefinition.Field[] fields = new MappingDefinition.Field[nFields];
        Map.Entry[] entries = (Map.Entry[])value.entrySet().toArray(Map.Entry[]::new);
        for (int i = 0; i < nFields; ++i) {
            Optional<SemType> valueType = shapeSupplier.get(cx, entries[i].getValue());
            SemType fieldType = valueType.orElseThrow();
            fields[i] = new MappingDefinition.Field(entries[i].getKey().toString(), fieldType, true, false);
        }
        CellAtomicType.CellMutability mut = value.getType().isReadOnly() ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
        SemType semType = md.defineMappingTypeWrapped(cx.env, fields, Builder.getNeverType(), mut);
        value.cacheShape(semType);
        value.resetReadonlyShapeDefinition();
        return Optional.of(semType);
    }

    private SemType createSemTypeInner(Env env, MappingDefinition defn, SemType restType, CellAtomicType.CellMutability mut) {
        return defn.defineMappingTypeWrapped(env, EMPTY_FIELD_ARR, restType, mut);
    }

    @Override
    public BMapType clone() {
        BMapType clone = (BMapType)super.clone();
        clone.defn.clear();
        return clone;
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        MayBeDependentType constraintType;
        Type type = this.constraint;
        return type instanceof MayBeDependentType && (constraintType = (MayBeDependentType)((Object)type)).isDependentlyTyped(visited);
    }
}

