/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import com.github.benmanes.caffeine.cache.Cache;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.types.StringType;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.ConcurrentLazySupplier;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.BSemTypeWrapper;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.semtype.CacheFactory;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public final class BStringType
extends BSemTypeWrapper<BStringTypeImpl>
implements StringType {
    private static final BasicTypeBitSet BASIC_TYPE_BIT_SET = Builder.getStringType();
    private static final Module DEFAULT_MODULE = new Module(null, null, null);
    private static final BStringTypeImpl DEFAULT_B_TYPE = new BStringTypeImpl("string", DEFAULT_MODULE, 5);
    private final SemType shape;

    public BStringType(String typeName, Module pkg) {
        this(() -> new BStringTypeImpl(typeName, pkg, 5), typeName, pkg, 5, Builder.getStringType());
    }

    public BStringType(String typeName, Module pkg, int tag) {
        this(() -> new BStringTypeImpl(typeName, pkg, tag), typeName, pkg, tag, BStringType.pickSemtype(tag));
    }

    private BStringType(Supplier<BStringTypeImpl> bTypeSupplier, String typeName, Module pkg, int tag, SemType semType) {
        super(new ConcurrentLazySupplier<BStringTypeImpl>(bTypeSupplier), typeName, pkg, tag, semType);
        this.shape = semType;
    }

    public static BStringType singletonType(String value) {
        return BStringTypeCache.get(value);
    }

    public SemType shape() {
        return this.shape;
    }

    private static BStringType createSingletonType(String value) {
        return new BStringType(() -> (BStringTypeImpl)DEFAULT_B_TYPE.clone(), "string", DEFAULT_MODULE, 5, Builder.getStringConst(value));
    }

    private static SemType pickSemtype(int tag) {
        return switch (tag) {
            case 5 -> Builder.getStringType();
            case 13 -> Builder.getCharType();
            default -> throw new IllegalStateException("Unexpected string type tag: " + tag);
        };
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE_BIT_SET;
    }

    private static final class BStringTypeCache {
        private static final Cache<String, BStringType> mediumCache = CacheFactory.createCache();
        private static final Map<String, BStringType> smallCache = new WeakHashMap<String, BStringType>();

        private BStringTypeCache() {
        }

        public static BStringType get(String value) {
            return switch (Kind.getKind(value).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> smallCache.computeIfAbsent(value, BStringType::createSingletonType);
                case 1 -> mediumCache.get(value, BStringType::createSingletonType);
                case 2 -> BStringType.createSingletonType(value);
            };
        }

        static enum Kind {
            SMALL,
            MEDIUM,
            LARGE;


            public static Kind getKind(String value) {
                if (value.length() < 16) {
                    return SMALL;
                }
                if (value.length() < 64) {
                    return MEDIUM;
                }
                return LARGE;
            }
        }
    }

    protected static final class BStringTypeImpl
    extends BType
    implements StringType,
    Cloneable {
        private final int tag;

        private BStringTypeImpl(String typeName, Module pkg, int tag) {
            super(typeName, pkg, String.class, false);
            this.tag = tag;
        }

        @Override
        public <V> V getZeroValue() {
            return (V)RuntimeConstants.STRING_EMPTY_VALUE;
        }

        @Override
        public <V> V getEmptyValue() {
            return (V)RuntimeConstants.STRING_EMPTY_VALUE;
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE_BIT_SET;
        }

        @Override
        public BType clone() {
            return super.clone();
        }
    }
}

