/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Conjunction;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.BCellSubType;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.DelegatedSubType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.Objects;
import java.util.function.Predicate;

final class BCellSubTypeImpl
extends BCellSubType
implements DelegatedSubType {
    private final Bdd inner;

    BCellSubTypeImpl(Bdd inner) {
        super(inner.isAll(), inner.isNothing());
        this.inner = inner;
    }

    @Override
    public SubType union(SubType other) {
        if (other instanceof BCellSubType) {
            BCellSubType otherCell = (BCellSubType)other;
            return BCellSubTypeImpl.createDelegate(this.inner.union(otherCell.inner()));
        }
        throw new IllegalArgumentException("union of different subtypes");
    }

    @Override
    public SubType intersect(SubType other) {
        if (other instanceof BCellSubType) {
            BCellSubType otherCell = (BCellSubType)other;
            return BCellSubTypeImpl.createDelegate(this.inner.intersect(otherCell.inner()));
        }
        throw new IllegalArgumentException("intersect of different subtypes");
    }

    @Override
    public SubType complement() {
        return BCellSubTypeImpl.createDelegate(this.inner.complement());
    }

    @Override
    public boolean isEmpty(Context cx) {
        return Bdd.bddEvery(cx, this.inner, BCellSubTypeImpl::cellFormulaIsEmpty);
    }

    @Override
    public SubType diff(SubType other) {
        if (other instanceof BCellSubType) {
            BCellSubType otherCell = (BCellSubType)other;
            return BCellSubTypeImpl.createDelegate(this.inner.diff(otherCell.inner()));
        }
        throw new IllegalArgumentException("diff of different subtypes");
    }

    @Override
    public SubTypeData data() {
        throw new IllegalStateException("unimplemented");
    }

    private static boolean cellFormulaIsEmpty(Context cx, Conjunction posList, Conjunction negList) {
        CellAtomicType combined;
        if (posList == null) {
            combined = CellAtomicType.from(Builder.getValType(), CellAtomicType.CellMutability.CELL_MUT_UNLIMITED);
        } else {
            combined = CellAtomicType.cellAtomType(posList.atom());
            for (Conjunction p = posList.next(); p != null; p = p.next()) {
                combined = CellAtomicType.intersectCellAtomicType(combined, CellAtomicType.cellAtomType(p.atom()));
            }
        }
        return !BCellSubTypeImpl.cellInhabited(cx, combined, negList);
    }

    private static boolean cellInhabited(Context cx, CellAtomicType posCell, Conjunction negList) {
        SemType pos = posCell.ty();
        if (Core.isEmpty(cx, pos)) {
            return false;
        }
        return switch (posCell.mut()) {
            case CellAtomicType.CellMutability.CELL_MUT_NONE -> BCellSubTypeImpl.cellMutNoneInhabited(cx, pos, negList);
            case CellAtomicType.CellMutability.CELL_MUT_LIMITED -> BCellSubTypeImpl.cellMutLimitedInhabited(cx, pos, negList);
            default -> BCellSubTypeImpl.cellMutUnlimitedInhabited(cx, pos, negList);
        };
    }

    private static boolean cellMutUnlimitedInhabited(Context cx, SemType pos, Conjunction negList) {
        for (Conjunction neg = negList; neg != null; neg = neg.next()) {
            if (CellAtomicType.cellAtomType(neg.atom()).mut() != CellAtomicType.CellMutability.CELL_MUT_LIMITED || !Core.isSameType(cx, Builder.getValType(), CellAtomicType.cellAtomType(neg.atom()).ty())) continue;
            return false;
        }
        SemType negListUnionResult = BCellSubTypeImpl.filteredCellListUnion(negList, conjunction -> CellAtomicType.cellAtomType(conjunction.atom()).mut() == CellAtomicType.CellMutability.CELL_MUT_UNLIMITED);
        return Core.isNever(negListUnionResult) || !Core.isEmpty(cx, Core.diff(pos, negListUnionResult));
    }

    private static boolean cellMutLimitedInhabited(Context cx, SemType pos, Conjunction negList) {
        if (negList == null) {
            return true;
        }
        CellAtomicType negAtomicCell = CellAtomicType.cellAtomType(negList.atom());
        if (negAtomicCell.mut().compareTo(CellAtomicType.CellMutability.CELL_MUT_LIMITED) >= 0 && Core.isEmpty(cx, Core.diff(pos, negAtomicCell.ty()))) {
            return false;
        }
        return BCellSubTypeImpl.cellMutLimitedInhabited(cx, pos, negList.next());
    }

    private static boolean cellMutNoneInhabited(Context cx, SemType pos, Conjunction negList) {
        SemType negListUnionResult = BCellSubTypeImpl.cellListUnion(negList);
        return Core.isNever(negListUnionResult) || !Core.isEmpty(cx, Core.diff(pos, negListUnionResult));
    }

    private static SemType cellListUnion(Conjunction negList) {
        return BCellSubTypeImpl.filteredCellListUnion(negList, neg -> true);
    }

    private static SemType filteredCellListUnion(Conjunction negList, Predicate<Conjunction> predicate) {
        SemType negUnion = Builder.getNeverType();
        for (Conjunction neg = negList; neg != null; neg = neg.next()) {
            if (!predicate.test(neg)) continue;
            negUnion = Core.union(negUnion, CellAtomicType.cellAtomType(neg.atom()).ty());
        }
        return negUnion;
    }

    @Override
    public Bdd inner() {
        return this.inner;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BCellSubTypeImpl)) {
            return false;
        }
        BCellSubTypeImpl other = (BCellSubTypeImpl)o;
        return Objects.equals(this.inner, other.inner);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.inner);
    }
}

