/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.Conjunction;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.RecAtom;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.DelegatedSubType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import io.ballerina.runtime.internal.types.semtype.XmlUtils;
import java.util.Objects;

public class BXmlSubType
extends SubType
implements DelegatedSubType {
    public final Bdd inner;
    private final int primitives;

    private BXmlSubType(Bdd inner, int primitives) {
        super(false, false);
        this.inner = inner;
        this.primitives = primitives;
    }

    public static BXmlSubType createDelegate(int primitives, SubType inner) {
        if (inner instanceof Bdd) {
            Bdd bdd = (Bdd)inner;
            return new BXmlSubType(bdd, primitives);
        }
        if (inner instanceof BXmlSubType) {
            BXmlSubType bXml = (BXmlSubType)inner;
            return new BXmlSubType(bXml.inner, primitives);
        }
        throw new IllegalArgumentException("Unexpected inner type");
    }

    @Override
    public SubType union(SubType other) {
        BXmlSubType otherXml = (BXmlSubType)other;
        int primitives = this.primitives() | otherXml.primitives();
        return BXmlSubType.createDelegate(primitives, this.inner.union(otherXml.inner));
    }

    @Override
    public SubType intersect(SubType other) {
        BXmlSubType otherXml = (BXmlSubType)other;
        int primitives = this.primitives() & otherXml.primitives();
        return BXmlSubType.createDelegate(primitives, this.inner.intersect(otherXml.inner));
    }

    @Override
    public SubType diff(SubType other) {
        BXmlSubType otherXml = (BXmlSubType)other;
        return BXmlSubType.diff(this, otherXml);
    }

    private static SubType diff(BXmlSubType st1, BXmlSubType st2) {
        int primitives = st1.primitives() & ~st2.primitives();
        return BXmlSubType.createDelegate(primitives, st1.inner.diff(st2.inner));
    }

    @Override
    public SubType complement() {
        return BXmlSubType.diff((BXmlSubType)XmlUtils.XML_SUBTYPE_TOP, this);
    }

    @Override
    public boolean isEmpty(Context cx) {
        if (this.primitives() != 0) {
            return false;
        }
        return this.xmlBddEmpty(cx);
    }

    private boolean xmlBddEmpty(Context cx) {
        return Bdd.bddEvery(cx, this.inner, BXmlSubType::xmlFormulaIsEmpty);
    }

    private static boolean xmlFormulaIsEmpty(Context cx, Conjunction pos, Conjunction neg) {
        int allPosBits = BXmlSubType.collectAllPrimitives(pos) & 0xFF;
        return BXmlSubType.xmlHasTotalNegative(allPosBits, neg);
    }

    private static boolean xmlHasTotalNegative(int allPosBits, Conjunction conjunction) {
        if (allPosBits == 0) {
            return true;
        }
        for (Conjunction n = conjunction; n != null; n = n.next()) {
            if ((allPosBits & ~BXmlSubType.getIndex(n)) != 0) continue;
            return true;
        }
        return false;
    }

    private static int collectAllPrimitives(Conjunction conjunction) {
        int bits = 0;
        for (Conjunction current = conjunction; current != null; current = current.next()) {
            bits &= BXmlSubType.getIndex(current);
        }
        return bits;
    }

    private static int getIndex(Conjunction conjunction) {
        Atom atom = conjunction.atom();
        assert (atom instanceof RecAtom);
        return atom.index();
    }

    @Override
    public SubTypeData data() {
        return this;
    }

    @Override
    public SubType inner() {
        return this;
    }

    int primitives() {
        return this.primitives;
    }

    Bdd bdd() {
        return this.inner;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.inner, this.primitives);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BXmlSubType)) {
            return false;
        }
        BXmlSubType other = (BXmlSubType)o;
        return Objects.equals(this.bdd(), other.bdd()) && this.primitives() == other.primitives();
    }
}

