/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Definition;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.RecAtom;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.BListSubType;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.FixedLengthArray;
import io.ballerina.runtime.internal.types.semtype.ListAtomicType;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ListDefinition
extends Definition {
    private volatile RecAtom rec = null;
    private volatile SemType semType = null;
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SemType getSemType(Env env) {
        try {
            this.lock.lock();
            SemType s = this.semType;
            if (s == null) {
                RecAtom rec;
                assert (this.rec == null);
                this.rec = rec = env.recListAtom();
                SemType semType = this.createSemType(env, rec);
                return semType;
            }
            SemType semType = s;
            return semType;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SemType defineListTypeWrapped(Env env, SemType[] initial, int fixedLength, SemType rest, CellAtomicType.CellMutability mut) {
        SemType[] initialCells = new SemType[initial.length];
        for (int i = 0; i < initial.length; ++i) {
            initialCells[i] = Builder.getCellContaining(env, initial[i], mut);
        }
        SemType restCell = Builder.getCellContaining(env, Core.union(rest, Builder.getUndefType()), Core.isNever(rest) ? CellAtomicType.CellMutability.CELL_MUT_NONE : mut);
        return this.define(env, initialCells, fixedLength, restCell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SemType define(Env env, SemType[] initial, int fixedLength, SemType rest) {
        FixedLengthArray members = FixedLengthArray.normalized(initial, fixedLength);
        ListAtomicType atomicType = new ListAtomicType(members, rest);
        try {
            Atom atom;
            this.lock.lock();
            RecAtom rec = this.rec;
            if (rec != null) {
                atom = rec;
                env.setRecListAtomType(rec, atomicType);
            } else {
                atom = env.listAtom(atomicType);
            }
            SemType semType = this.createSemType(env, atom);
            return semType;
        }
        finally {
            this.lock.unlock();
        }
    }

    private SemType createSemType(Env env, Atom atom) {
        BddNode bdd = BddNode.bddAtom(atom);
        this.semType = Builder.basicSubType(BasicTypeCode.BT_LIST, BListSubType.createDelegate(bdd));
        return this.semType;
    }
}

