/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlQName;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.utils.IteratorUtils;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.CollectionValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.XmlItem;
import io.ballerina.runtime.internal.xml.BallerinaXmlSerializer;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;

public abstract class XmlValue
implements RefValue,
BXml,
CollectionValue {
    Type type = PredefinedTypes.TYPE_XML;
    protected BTypedesc typedesc;
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getXmlType();
    protected Type iteratorNextReturnType;

    @Override
    public abstract int size();

    @Override
    public BString getAttribute(BXmlQName attributeName) {
        return this.getAttribute(attributeName.getLocalName(), attributeName.getUri(), attributeName.getPrefix());
    }

    @Override
    @Deprecated
    public void setAttribute(BXmlQName attributeName, String value) {
        this.setAttributeOnInitialization(attributeName.getLocalName(), attributeName.getUri(), attributeName.getPrefix(), value);
    }

    @Deprecated
    public void setAttribute(BXmlQName attributeName, BString value) {
        this.setAttributeOnInitialization(attributeName.getLocalName(), attributeName.getUri(), attributeName.getPrefix(), value.getValue());
    }

    public abstract MapValue<BString, BString> getAttributesMap();

    @Override
    public abstract void setAttributes(BMap<BString, BString> var1);

    @Override
    public abstract XmlNodeType getNodeType();

    @Override
    public abstract void build();

    @Override
    public String informalStringValue(BLink parent) {
        return "`" + this.stringValue(parent) + "`";
    }

    @Override
    public Type getType() {
        return this.type;
    }

    protected abstract void setAttributesOnInitialization(BMap<BString, BString> var1);

    protected abstract void setAttributeOnInitialization(String var1, String var2, String var3, String var4);

    protected static void handleXmlException(String message, Throwable t) {
        if (t.getCause() != null) {
            throw ErrorCreator.createError(StringUtils.fromString(message + t.getCause().getMessage()));
        }
        throw ErrorCreator.createError(StringUtils.fromString(message + t.getMessage()));
    }

    protected QName getQname(String qname) {
        String nsUri;
        String localname;
        int rParenIndex = qname.indexOf(125);
        if (qname.startsWith("{") && rParenIndex > 0) {
            localname = qname.substring(rParenIndex + 1);
            nsUri = qname.substring(1, rParenIndex);
        } else {
            localname = qname;
            nsUri = "";
        }
        return new QName(nsUri, localname);
    }

    protected void addDescendants(List<BXml> descendants, XmlItem currentElement, List<String> qnames) {
        for (BXml child : currentElement.getChildrenSeq().getChildrenList()) {
            if (child.getNodeType() != XmlNodeType.ELEMENT) continue;
            String elemName = ((XmlItem)child).getQName().toString();
            if (qnames.contains(elemName)) {
                descendants.add(child);
            }
            this.addDescendants(descendants, (XmlItem)child, qnames);
        }
    }

    protected void addDescendants(List<BXml> descendants, XmlItem currentElement) {
        for (BXml child : currentElement.getChildrenSeq().getChildrenList()) {
            descendants.add(child);
            if (child.getNodeType() != XmlNodeType.ELEMENT) continue;
            this.addDescendants(descendants, (XmlItem)child);
        }
    }

    public void addChildren(XmlValue seq) {
        this.addChildren((BXml)seq);
    }

    public void setChildren(XmlValue seq) {
        this.setChildren((BXml)seq);
    }

    @Override
    public abstract XmlValue children();

    @Override
    public abstract XmlValue children(String var1);

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        XmlValue copy = (XmlValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public abstract XmlValue getItem(int var1);

    @Override
    public void serialize(OutputStream outputStream) {
        try {
            if (outputStream instanceof BallerinaXmlSerializer) {
                BallerinaXmlSerializer xmlSerializer = (BallerinaXmlSerializer)outputStream;
                xmlSerializer.write(this);
            } else {
                BallerinaXmlSerializer xmlSerializer = new BallerinaXmlSerializer(outputStream);
                xmlSerializer.write(this);
                xmlSerializer.flush();
                xmlSerializer.close();
            }
        }
        catch (Throwable t) {
            XmlValue.handleXmlException("error occurred during writing the message to the output stream: ", t);
        }
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = ValueUtils.getTypedescValue(this.type, this);
        }
        return this.typedesc;
    }

    @Override
    public Type getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(this.type);
        }
        return this.iteratorNextReturnType;
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx) {
        TypeWithShape typeWithShape = (TypeWithShape)((Object)this.type);
        return typeWithShape.inherentTypeOf(cx, ShapeAnalyzer::inherentTypeOf, this);
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }
}

