/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.profiler;

import io.ballerina.runtime.profiler.codegen.ProfilerClassLoader;
import io.ballerina.runtime.profiler.codegen.ProfilerMethodWrapper;
import io.ballerina.runtime.profiler.ui.HttpServer;
import io.ballerina.runtime.profiler.ui.JsonParser;
import io.ballerina.runtime.profiler.util.Constants;
import io.ballerina.runtime.profiler.util.ProfilerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Profiler {
    private final long profilerStartTime;
    private String balJarArgs = null;
    private String balJarName = null;
    private String profilerDebugArg = null;
    private final List<String> instrumentedPaths = new ArrayList<String>();
    private final List<String> instrumentedFiles = new ArrayList<String>();
    private final List<String> utilInitPaths = new ArrayList<String>();
    private final List<String> utilPaths = new ArrayList<String>();
    private int balFunctionCount = 0;
    private int moduleCount = 0;
    private final ProfilerMethodWrapper profilerMethodWrapper;
    private final String currentDir;

    public Profiler(long profilerStartTime) {
        this.profilerStartTime = profilerStartTime;
        this.profilerMethodWrapper = new ProfilerMethodWrapper();
        this.currentDir = System.getenv("current.dir");
    }

    private void addShutdownHookAndCleanup() {
        Runtime.getRuntime().addShutdownHook(Thread.ofVirtual().unstarted(() -> {
            try {
                long profilerTotalTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS) - this.profilerStartTime;
                Files.deleteIfExists(Path.of("temp.jar", new String[0]));
                Constants.OUT_STREAM.printf("%s[6/6] Generating output...%s%n", "\u001b[1;38;2;32;182;176m", "\u001b[0m");
                JsonParser jsonParser = new JsonParser();
                HttpServer httpServer = new HttpServer();
                String cpuFilePath = Path.of(this.currentDir, "cpu_pre.json").toString();
                jsonParser.initializeCPUParser(cpuFilePath);
                this.deleteFileIfExists(cpuFilePath);
                Constants.OUT_STREAM.printf("      Execution time: %d seconds %n", profilerTotalTime / 1000L);
                httpServer.initializeHTMLExport();
                this.deleteFileIfExists("performance_report.json");
                Constants.OUT_STREAM.println("--------------------------------------------------------------------------------");
            }
            catch (IOException e) {
                throw new ProfilerException("Error occurred while generating the output", e);
            }
        }));
    }

    private void deleteFileIfExists(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        try {
            Files.delete(Path.of(filePath, new String[0]));
        }
        catch (IOException e) {
            throw new ProfilerException("Failed to delete file: " + filePath + "%n", e);
        }
    }

    private void printHeader() {
        Constants.OUT_STREAM.printf("%n%s================================================================================%s", "\u001b[37m", "\u001b[0m");
        Constants.OUT_STREAM.printf("%n%sBallerina Profiler%s", "\u001b[1;38;2;32;182;176m", "\u001b[0m");
        Constants.OUT_STREAM.printf("%s: Profiling...%s", "\u001b[37m", "\u001b[0m");
        Constants.OUT_STREAM.printf("%n%s================================================================================%s", "\u001b[37m", "\u001b[0m");
        Constants.OUT_STREAM.printf("%n%sNote: This is an experimental feature, which supports only a limited set of functionality.%s%n", "\u001b[37m", "\u001b[0m");
    }

    private void handleProfilerArguments(String[] args) {
        if (args.length == 0) {
            return;
        }
        ArrayList<String> usedArgs = new ArrayList<String>();
        block10: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--file": {
                    this.balJarName = this.extractFileArg(args[i + 1]);
                    this.addToUsedArgs(args, usedArgs, i);
                    continue block10;
                }
                case "--args": {
                    this.balJarArgs = this.extractBalJarArgs(args[i + 1]);
                    this.addToUsedArgs(args, usedArgs, i);
                    continue block10;
                }
                case "--profiler-debug": {
                    this.profilerDebugArg = args[i + 1];
                    this.addToUsedArgs(args, usedArgs, i);
                    continue block10;
                }
                default: {
                    this.handleUnrecognizedArgument(args[i], usedArgs);
                }
            }
        }
    }

    private String extractFileArg(String value) {
        if (!value.endsWith(".jar")) {
            throw new ProfilerException("Invalid file argument found: " + value);
        }
        return value;
    }

    private String extractBalJarArgs(String value) {
        if (value == null || !value.startsWith("[") || !value.endsWith("]")) {
            throw new ProfilerException("Invalid JAR arguments found: " + value);
        }
        return value.substring(1, value.length() - 1);
    }

    private void handleUnrecognizedArgument(String argument, List<String> usedArgs) {
        if (!usedArgs.contains(argument)) {
            throw new ProfilerException("Unrecognized argument found: " + argument);
        }
    }

    private void addToUsedArgs(String[] args, List<String> usedArgs, int i) {
        usedArgs.add(args[i]);
        usedArgs.add(args[i + 1]);
    }

    private void extractProfiler() throws ProfilerException {
        Constants.OUT_STREAM.printf("%s[1/6] Initializing...%s%n", "\u001b[1;38;2;32;182;176m", "\u001b[0m");
        try {
            Path profilerRuntimePath = Path.of("io/ballerina/runtime/profiler/runtime", new String[0]);
            new ProcessBuilder("jar", "xvf", "Profiler.jar", profilerRuntimePath.toString()).start().waitFor();
        }
        catch (IOException | InterruptedException exception) {
            throw new ProfilerException(exception);
        }
    }

    private void createTempJar() {
        try {
            Constants.OUT_STREAM.printf("%s[2/6] Copying executable...%s%n", "\u001b[1;38;2;32;182;176m", "\u001b[0m");
            Path sourcePath = Path.of(this.balJarName, new String[0]);
            Path destinationPath = Path.of("temp.jar", new String[0]);
            Files.copy(sourcePath, destinationPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new ProfilerException("Error occurred while copying the file: " + this.balJarName, e);
        }
    }

    private void initializeProfiling() throws ProfilerException {
        Constants.OUT_STREAM.printf("%s[3/6] Performing analysis...%s%n", "\u001b[1;38;2;32;182;176m", "\u001b[0m");
        ArrayList<String> classNames = new ArrayList<String>();
        try {
            this.findAllClassNames(this.balJarName, classNames);
            this.findUtilityClasses(classNames);
        }
        catch (Exception e) {
            throw new ProfilerException("error occurred while performing analysis", e);
        }
        Constants.OUT_STREAM.printf("%s[4/6] Instrumenting functions...%s%n", "\u001b[1;38;2;32;182;176m", "\u001b[0m");
        try (JarFile jarFile = new JarFile(this.balJarName);){
            String mainClassPackage = this.profilerMethodWrapper.mainClassFinder(new URLClassLoader(new URL[]{new File(this.balJarName).toURI().toURL()}));
            ProfilerClassLoader profilerClassLoader = new ProfilerClassLoader(new URLClassLoader(new URL[]{new File(this.balJarName).toURI().toURL()}));
            for (String className : classNames) {
                if (mainClassPackage == null || className.contains("$gen$")) continue;
                if (className.startsWith(mainClassPackage.split("/")[0]) || this.utilPaths.contains(className)) {
                    try (InputStream inputStream = jarFile.getInputStream(jarFile.getJarEntry(className));){
                        String sourceClassName = className.replace(".class", "");
                        byte[] code = this.profilerMethodWrapper.modifyMethods(inputStream, sourceClassName);
                        profilerClassLoader.loadClass(code);
                        this.profilerMethodWrapper.printCode(className, code, this.getFileNameWithoutExtension(this.balJarName));
                    }
                }
                if (!className.endsWith("/$_init.class")) continue;
                ++this.moduleCount;
            }
            Constants.OUT_STREAM.printf("      Instrumented module count: %d%n", this.moduleCount);
            Constants.OUT_STREAM.printf("      Instrumented function count: %d%n", this.balFunctionCount);
            this.modifyJar();
        }
        catch (Throwable throwable) {
            throw new ProfilerException(throwable);
        }
    }

    private void modifyJar() throws InterruptedException, IOException {
        try {
            File userDirectory = new File(System.getProperty("user.dir"));
            this.listAllFiles(userDirectory);
            List<String> changedDirectories = this.instrumentedFiles.stream().distinct().toList();
            this.loadDirectories(changedDirectories);
        }
        catch (Throwable throwable) {
            for (String instrumentedFilePath : this.instrumentedPaths) {
                FileUtils.deleteDirectory(new File(instrumentedFilePath));
            }
            Path filePath = Path.of("io/ballerina/runtime/profiler/runtime", new String[0]);
            FileUtils.deleteDirectory(new File(filePath.toString()));
            this.profilerMethodWrapper.invokeMethods(this.profilerDebugArg);
            throw throwable;
        }
        for (String instrumentedFilePath : this.instrumentedPaths) {
            FileUtils.deleteDirectory(new File(instrumentedFilePath));
        }
        Path filePath = Path.of("io/ballerina/runtime/profiler/runtime", new String[0]);
        FileUtils.deleteDirectory(new File(filePath.toString()));
        this.profilerMethodWrapper.invokeMethods(this.profilerDebugArg);
    }

    private void loadDirectories(List<String> changedDirs) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("jar", "uf", "temp.jar");
            processBuilder.command().addAll(changedDirs);
            processBuilder.start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new ProfilerException("Error occurred while loading the jar file", e);
        }
    }

    private void listAllFiles(File userDirectory) {
        String absolutePath = Path.of("temp.jar", new String[0]).toFile().getAbsolutePath();
        this.analyseInstrumentedDirectories(userDirectory, absolutePath.replaceAll("temp.jar", ""));
    }

    private void analyseInstrumentedDirectories(File directory, String absolutePath) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File fileEntry : files) {
                if (fileEntry.isDirectory()) {
                    this.analyseInstrumentedDirectories(fileEntry, absolutePath);
                    continue;
                }
                this.updateInstrumentedFile(fileEntry, absolutePath);
            }
        }
    }

    private void updateInstrumentedFile(File fileEntry, String absolutePath) {
        String fileEntryString = fileEntry.getPath();
        if (fileEntryString.endsWith(".class")) {
            int index = (fileEntryString = fileEntryString.replaceAll(Pattern.quote(absolutePath), "")).lastIndexOf(File.separatorChar);
            fileEntryString = index == -1 ? "" : fileEntryString.substring(0, index);
            String[] fileEntryParts = fileEntryString.split(Pattern.quote(File.separator));
            this.instrumentedPaths.add(fileEntryParts[0]);
            this.instrumentedFiles.add(fileEntryString);
        }
    }

    private void findAllClassNames(String jarPath, ArrayList<String> classNames) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(jarPath));){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                    classNames.add(String.valueOf(entry));
                }
                entry = zipInputStream.getNextEntry();
            }
        }
    }

    private void findUtilityClasses(ArrayList<String> classNames) {
        this.populateInitPaths(classNames);
        for (String name : classNames) {
            for (String path : this.utilInitPaths) {
                String subPath;
                if (!name.startsWith(path) || (subPath = name.substring(path.length())).indexOf(47) != -1) continue;
                this.utilPaths.add(name);
            }
        }
    }

    private void populateInitPaths(ArrayList<String> classNames) {
        for (String className : classNames) {
            String path;
            if (!className.endsWith("$_init.class") || this.utilInitPaths.contains(path = className.substring(0, className.lastIndexOf(47) + 1))) continue;
            this.utilInitPaths.add(path);
        }
    }

    void incrementBalFunctionCount() {
        ++this.balFunctionCount;
    }

    String getBalJarArgs() {
        return this.balJarArgs;
    }

    private String getFileNameWithoutExtension(String balJarName) {
        if (null != balJarName) {
            int index = FilenameUtils.indexOfExtension(balJarName);
            return index == -1 ? balJarName : balJarName.substring(0, index);
        }
        return null;
    }

    void start(String[] args) {
        this.addShutdownHookAndCleanup();
        this.printHeader();
        this.handleProfilerArguments(args);
        this.extractProfiler();
        this.createTempJar();
        this.initializeProfiling();
    }
}

