/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.profiler.codegen;

import io.ballerina.runtime.profiler.util.ProfilerException;
import org.objectweb.asm.ClassReader;

public class ProfilerClassLoader
extends ClassLoader {
    public ProfilerClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void loadClass(byte[] code) {
        String name = this.readClassName(code);
        try {
            if (!name.equals("module-info")) {
                this.defineClass(name, code, 0, code.length);
            }
        }
        catch (Throwable e) {
            throw new ProfilerException("error while loading class: " + name, e);
        }
    }

    public String readClassName(byte[] byteCode) {
        return new ClassReader(byteCode).getClassName().replace("/", ".");
    }
}

