/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.profiler.codegen;

import io.ballerina.runtime.profiler.Main;
import io.ballerina.runtime.profiler.codegen.ProfilerClassVisitor;
import io.ballerina.runtime.profiler.codegen.ProfilerClassWriter;
import io.ballerina.runtime.profiler.util.Constants;
import io.ballerina.runtime.profiler.util.ProfilerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ProfilerMethodWrapper
extends ClassLoader {
    public static final String JAVA_OPTS = "JAVA_OPTS";

    public void invokeMethods(String debugArg) throws IOException, InterruptedException {
        String balJarArgs = Main.getBalJarArgs();
        ArrayList<String> commands = new ArrayList<String>();
        String javaOpts = System.getenv().get(JAVA_OPTS);
        commands.add(System.getenv("java.command"));
        if (javaOpts != null) {
            commands.add(javaOpts.trim());
        }
        commands.add("-jar");
        if (debugArg != null) {
            commands.add(debugArg);
        }
        commands.add(Path.of(System.getProperty("user.dir"), "temp.jar").toString());
        if (balJarArgs != null) {
            commands.add(balJarArgs);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.inheritIO();
        processBuilder.directory(new File(System.getenv("current.dir")));
        if (javaOpts != null) {
            processBuilder.environment().put(JAVA_OPTS, javaOpts.trim());
        }
        Process process = processBuilder.start();
        Constants.OUT_STREAM.printf("\u001b[1;38;2;32;182;176m[5/6] Running executable...\u001b[0m%n", new Object[0]);
        try (InputStreamReader streamReader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader);){
            reader.lines().forEach(Constants.OUT_STREAM::println);
        }
        process.waitFor();
    }

    public String mainClassFinder(URLClassLoader manifestClassLoader) {
        try {
            URL manifestURL = manifestClassLoader.findResource("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(manifestURL.openStream());
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue("Main-Class").replace(".$_init", "").replace(".", "/");
        }
        catch (Throwable throwable) {
            Constants.ERROR_STREAM.println(String.valueOf(throwable) + "%n");
            return null;
        }
    }

    public byte[] modifyMethods(InputStream inputStream, String className) {
        try {
            ClassReader reader = new ClassReader(inputStream);
            ProfilerClassWriter classWriter = new ProfilerClassWriter(reader, 3);
            ProfilerClassVisitor change = new ProfilerClassVisitor(className, (ClassVisitor)classWriter);
            reader.accept(change, 8);
            byte[] code = classWriter.toByteArray();
            return code;
        }
        catch (Throwable e) {
            Constants.ERROR_STREAM.println(String.valueOf(e) + "%n");
            return new byte[0];
        }
    }

    public void printCode(String className, byte[] code, String balJarName) {
        boolean directoryCreated;
        String output;
        int lastSlashIndex = ((String)className).lastIndexOf(47);
        if (lastSlashIndex == -1) {
            output = balJarName;
            className = balJarName + "/" + (String)className;
        } else {
            output = ((String)className).substring(0, lastSlashIndex);
        }
        File directory = new File(output);
        if (!directory.exists() && !(directoryCreated = directory.mkdirs())) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream((String)className);){
            fos.write(code);
        }
        catch (IOException e) {
            throw new ProfilerException(e);
        }
    }
}

