/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.utils;

import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BFiniteType;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static boolean isValueType(Type type) {
        Type referredType = TypeUtils.getImpliedType(type);
        return switch (referredType.getTag()) {
            case 1, 2, 3, 4, 5, 6 -> true;
            case 46 -> {
                for (Object value : ((BFiniteType)referredType).valueSpace) {
                    if (TypeUtils.isValueType(TypeChecker.getType(value))) continue;
                    yield false;
                }
                yield true;
            }
            default -> false;
        };
    }

    public static Type getTypeFromName(String typeName) {
        return switch (typeName) {
            case "int" -> PredefinedTypes.TYPE_INT;
            case "byte" -> PredefinedTypes.TYPE_BYTE;
            case "float" -> PredefinedTypes.TYPE_FLOAT;
            case "decimal" -> PredefinedTypes.TYPE_DECIMAL;
            case "string" -> PredefinedTypes.TYPE_STRING;
            case "boolean" -> PredefinedTypes.TYPE_BOOLEAN;
            case "json" -> PredefinedTypes.TYPE_JSON;
            case "xml" -> PredefinedTypes.TYPE_XML;
            case "map" -> PredefinedTypes.TYPE_MAP;
            case "future" -> PredefinedTypes.TYPE_FUTURE;
            case "stream" -> PredefinedTypes.TYPE_STREAM;
            case "any" -> PredefinedTypes.TYPE_ANY;
            case "typedesc" -> PredefinedTypes.TYPE_TYPEDESC;
            case "()" -> PredefinedTypes.TYPE_NULL;
            case "xml-attributes" -> PredefinedTypes.TYPE_XML_ATTRIBUTES;
            case "error" -> PredefinedTypes.TYPE_ERROR;
            case "anydata" -> PredefinedTypes.TYPE_ANYDATA;
            case "never" -> PredefinedTypes.TYPE_NEVER;
            default -> throw new IllegalStateException("Unknown type name");
        };
    }

    public static Type fromString(String typeName) {
        if (typeName.endsWith("[]")) {
            String elementTypeName = typeName.substring(0, typeName.length() - 2);
            Type elemType = TypeUtils.fromString(elementTypeName);
            return new BArrayType(elemType);
        }
        return TypeUtils.getTypeFromName(typeName);
    }

    public static Type getType(Object value) {
        return TypeChecker.getType(value);
    }

    public static boolean isSameType(Type sourceType, Type targetType) {
        return TypeChecker.isSameType(sourceType, targetType);
    }

    public static Type getReferredType(Type type) {
        Type referredType = type.getCachedReferredType();
        if (referredType != null) {
            return referredType;
        }
        referredType = type.getTag() == 53 ? TypeUtils.getReferredType(((ReferenceType)type).getReferredType()) : type;
        type.setCachedReferredType(referredType);
        return referredType;
    }

    public static Type getImpliedType(Type type) {
        Type impliedType = type.getCachedImpliedType();
        if (impliedType != null) {
            return impliedType;
        }
        impliedType = (type = TypeUtils.getReferredType(type)).getTag() == 34 ? TypeUtils.getImpliedType(((IntersectionType)type).getEffectiveType()) : type;
        type.setCachedImpliedType(impliedType);
        return impliedType;
    }
}

