/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.AnyType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.ConcurrentLazySupplier;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BSemTypeWrapper;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.RefValue;
import java.util.Optional;

public final class BAnyType
extends BSemTypeWrapper<BAnyTypeImpl>
implements AnyType {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getAnyType();

    public BAnyType(String typeName, Module pkg, boolean readonly) {
        super(new ConcurrentLazySupplier<BAnyTypeImpl>(() -> new BAnyTypeImpl(typeName, pkg, readonly)), typeName, pkg, 29, BAnyType.pickSemType(readonly));
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return ((BAnyTypeImpl)this.getbType()).getIntersectionType();
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        ((BAnyTypeImpl)this.getbType()).setIntersectionType(intersectionType);
    }

    @Override
    public Type getReferredType() {
        return ((BAnyTypeImpl)this.getbType()).getReferredType();
    }

    @Override
    public IntersectionType getImmutableType() {
        return ((BAnyTypeImpl)this.getbType()).getImmutableType();
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public boolean isAnydata() {
        return false;
    }

    private static SemType pickSemType(boolean readonly) {
        SemType semType = Builder.getAnyType();
        if (readonly) {
            semType = Core.intersect(semType, Builder.getReadonlyType());
        }
        return semType;
    }

    protected static final class BAnyTypeImpl
    extends BType
    implements AnyType {
        private final boolean readonly;
        private IntersectionType immutableType;
        private IntersectionType intersectionType = null;

        private BAnyTypeImpl(String typeName, Module pkg, boolean readonly) {
            super(typeName, pkg, RefValue.class, false);
            this.readonly = readonly;
            if (!readonly) {
                BAnyType immutableAnyType = new BAnyType("any & readonly", pkg, true);
                this.immutableType = new BIntersectionType(pkg, new Type[]{this, PredefinedTypes.TYPE_READONLY}, immutableAnyType, TypeFlags.asMask(1), true);
            }
        }

        @Override
        public <V> V getZeroValue() {
            return null;
        }

        @Override
        public <V> V getEmptyValue() {
            return null;
        }

        @Override
        public int getTag() {
            return 29;
        }

        @Override
        public boolean isNilable() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return this.readonly;
        }

        @Override
        public IntersectionType getImmutableType() {
            return this.immutableType;
        }

        @Override
        public void setImmutableType(IntersectionType immutableType) {
            this.immutableType = immutableType;
        }

        @Override
        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE;
        }

        @Override
        public Optional<IntersectionType> getIntersectionType() {
            return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
        }

        @Override
        public void setIntersectionType(IntersectionType intersectionType) {
            this.intersectionType = intersectionType;
        }
    }
}

