/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.diagnostics.RuntimeDiagnosticLog;
import io.ballerina.runtime.internal.scheduling.AsyncUtils;
import io.ballerina.runtime.internal.utils.DefaultLogFormatter;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.FutureValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import java.io.PrintStream;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RuntimeUtils {
    private static final String CRASH_LOGGER = "b7a.log.crash";
    private static final PrintStream errStream = System.err;
    public static final String USER_DIR = System.getProperty("user.dir");
    private static final Logger crashLogger = Logger.getLogger("b7a.log.crash");
    private static ConsoleHandler handler;

    public static boolean isByteLiteral(int intValue) {
        return intValue >= RuntimeConstants.BBYTE_MIN_VALUE && intValue <= RuntimeConstants.BBYTE_MAX_VALUE;
    }

    public static void handleFutureAndExit(FutureValue future) {
        try {
            Object result = AsyncUtils.getFutureResult(future.completableFuture);
            if (result instanceof ErrorValue) {
                ErrorValue error = (ErrorValue)result;
                errStream.println("error: " + error.getPrintableError());
                Runtime.getRuntime().exit(1);
            }
        }
        catch (ErrorValue error) {
            RuntimeUtils.printToConsole(error);
            Runtime.getRuntime().exit(1);
        }
    }

    public static boolean handleFutureAndReturnIsPanic(FutureValue future) {
        try {
            RuntimeUtils.handleErrorResult(AsyncUtils.getFutureResult(future.completableFuture));
        }
        catch (ErrorValue error) {
            RuntimeUtils.printToConsole(error);
            return true;
        }
        return false;
    }

    public static void handleFuture(FutureValue future) {
        try {
            RuntimeUtils.handleErrorResult(AsyncUtils.getFutureResult(future.completableFuture));
        }
        catch (ErrorValue error) {
            RuntimeUtils.printToConsole(error);
        }
    }

    public static void handleThrowable(Throwable throwable) {
        RuntimeUtils.logBadSad(throwable);
        Runtime.getRuntime().exit(1);
    }

    public static void handleErrorResult(Object result) {
        if (result instanceof ErrorValue) {
            ErrorValue errorValue = (ErrorValue)result;
            errStream.println("error: " + errorValue.getPrintableError());
        }
    }

    private static void printToConsole(ErrorValue throwable) {
        errStream.println("error: " + throwable.getPrintableStackTrace());
    }

    public static void handleDiagnosticErrors(RuntimeDiagnosticLog diagnosticLog) {
        diagnosticLog.getDiagnosticList().forEach(diagnostic -> errStream.println(diagnostic.toString()));
        if (diagnosticLog.getErrorCount() > 0) {
            Runtime.getRuntime().exit(1);
        }
    }

    public static void logBadSad(Throwable throwable) {
        errStream.println("ballerina: Oh no, something really went wrong. Bad. Sad.\n\nWe appreciate it if you can report the code that broke Ballerina in\nhttps://github.com/ballerina-platform/ballerina-lang/issues with the\nlog you get below and your sample code.\n\nWe thank you for helping make us better.\n");
        RuntimeUtils.printCrashLog(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printCrashLog(Throwable throwable) {
        Level logLevel = Level.ALL;
        Logger logger = crashLogger;
        synchronized (logger) {
            if (handler == null) {
                handler = new ConsoleHandler();
                handler.setFormatter(new DefaultLogFormatter());
                crashLogger.addHandler(handler);
                crashLogger.setUseParentHandlers(false);
                crashLogger.setLevel(logLevel);
            }
        }
        crashLogger.log(Level.SEVERE, throwable.getMessage(), throwable);
    }

    public static String getMajorVersion(String version) {
        return version.split("\\.")[0];
    }

    public static BMap<BString, Object> validateBMapValues(BMap<BString, Object> bMap) {
        if (bMap == null) {
            return new MapValueImpl<BString, Object>();
        }
        for (Object value : bMap.values()) {
            if (!RuntimeUtils.isInvalidBallerinaValue(value)) continue;
            throw ErrorUtils.createJToBTypeCastError(value.getClass());
        }
        return bMap;
    }

    public static Map<String, Object> validateBMapValues(Map<String, Object> bMap) {
        if (bMap == null) {
            return new MapValueImpl<String, Object>();
        }
        for (Object value : bMap.values()) {
            if (!RuntimeUtils.isInvalidBallerinaValue(value) || value instanceof String) continue;
            throw ErrorUtils.createJToBTypeCastError(value.getClass());
        }
        return bMap;
    }

    public static BMap<BString, Object> validateErrorDetails(BMap<BString, Object> details) {
        if (details == null) {
            return new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL);
        }
        for (Object value : details.values()) {
            if (!RuntimeUtils.isInvalidBallerinaValue(value)) continue;
            throw ErrorUtils.createJToBTypeCastError(value.getClass());
        }
        return details;
    }

    private static boolean isInvalidBallerinaValue(Object value) {
        return value != null && !(value instanceof Number) && !(value instanceof Boolean) && !(value instanceof BValue);
    }

    public static String formatErrorMessage(Throwable e) {
        if (e instanceof BError) {
            BError error = (BError)e;
            return error.getPrintableStackTrace();
        }
        return RuntimeUtils.getPrintableStackTrace(e);
    }

    private static String getPrintableStackTrace(Throwable throwable) {
        String errorMsg = throwable.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(errorMsg);
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace.length == 0) {
            return sb.toString();
        }
        sb.append("\n\tat ");
        RuntimeUtils.printStackElement(sb, stackTrace[0], "");
        for (int i = 1; i < stackTrace.length; ++i) {
            RuntimeUtils.printStackElement(sb, stackTrace[i], "\n\t   ");
        }
        return sb.toString();
    }

    private static void printStackElement(StringBuilder sb, StackTraceElement stackTraceElement, String tab) {
        String pkgName = Utils.decodeIdentifier((String)stackTraceElement.getClassName());
        String fileName = stackTraceElement.getFileName();
        if (fileName == null) {
            fileName = "unknown-source";
        }
        fileName = fileName.replace(".bal", "");
        int index = pkgName.lastIndexOf("." + (fileName = fileName.replace("/", "-")));
        if (index != -1) {
            pkgName = pkgName.substring(0, index);
        }
        sb.append(tab);
        if (!pkgName.equals("$_init")) {
            sb.append(pkgName).append(":");
        }
        sb.append(Utils.decodeIdentifier((String)stackTraceElement.getMethodName()));
        sb.append("(").append(fileName);
        sb.append(":").append(stackTraceElement.getLineNumber()).append(")");
    }

    private RuntimeUtils() {
    }
}

