/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.imp.PropagationException;
import com.atomikos.icatch.imp.PropagationMessage;
import com.atomikos.icatch.imp.Result;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;

class CommitMessage
extends PropagationMessage {
    private static final Logger LOGGER = LoggerFactory.createLogger(CommitMessage.class);
    private boolean onephase_ = false;

    public CommitMessage(Participant participant, Result result, boolean onephase) {
        super(participant, result);
        this.onephase_ = onephase;
    }

    @Override
    protected Boolean send() throws PropagationException {
        Participant part = this.getParticipant();
        try {
            part.commit(this.onephase_);
            return null;
        }
        catch (RollbackException rb) {
            throw new PropagationException(rb, false);
        }
        catch (HeurMixedException heurm) {
            throw new PropagationException(heurm, false);
        }
        catch (HeurRollbackException heurr) {
            throw new PropagationException(heurr, false);
        }
        catch (Exception e) {
            String msg = "Unexpected error in commit";
            LOGGER.logError(msg, e);
            HeurHazardException heurh = new HeurHazardException();
            boolean retry = !this.onephase_;
            throw new PropagationException(heurh, retry);
        }
    }

    public String toString() {
        return "CommitMessage to " + this.getParticipant();
    }
}

