/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.json.JsonGenerator;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.BmpStringValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.NonBmpStringValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;

public final class StringUtils {
    public static BString getStringFromInputStream(InputStream in) {
        String result;
        try (BufferedInputStream bis = new BufferedInputStream(in);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int data;
            while ((data = bis.read()) != -1) {
                bos.write(data);
            }
            result = bos.toString();
        }
        catch (IOException ioe) {
            throw ErrorCreator.createError(StringUtils.fromString("Error occurred when reading input stream"), ioe);
        }
        return StringUtils.fromString(result);
    }

    public static BString getStringFromInputStream(InputStream inputStream, String charset) {
        StringBuilder textBuilder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName(charset));){
            int character;
            while ((character = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)character);
            }
        }
        catch (IOException e) {
            throw ErrorCreator.createError(StringUtils.fromString("Error occurred when reading input stream with the charset" + charset), e);
        }
        return StringUtils.fromString(textBuilder.toString());
    }

    public static BString getStringAt(BString s, long index) {
        if (index < 0L || index >= (long)s.length()) {
            throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.string", "IndexOutOfRange"), ErrorHelper.getErrorDetails(ErrorCodes.STRING_INDEX_OUT_OF_RANGE, index, s.length()));
        }
        return StringUtils.fromString(String.valueOf(Character.toChars(s.getCodePoint((int)index))));
    }

    public static BString fromString(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<Integer> highSurrogates = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isHighSurrogate(c)) continue;
            if (highSurrogates == null) {
                highSurrogates = new ArrayList<Integer>();
            }
            highSurrogates.add(i - highSurrogates.size());
        }
        if (highSurrogates == null) {
            return new BmpStringValue(s);
        }
        int[] highSurrogatesArr = new int[highSurrogates.size()];
        for (int i = 0; i < highSurrogates.size(); ++i) {
            Integer highSurrogate = (Integer)highSurrogates.get(i);
            highSurrogatesArr[i] = highSurrogate;
        }
        return new NonBmpStringValue(s, highSurrogatesArr);
    }

    public static BArray fromStringArray(String[] s) {
        BString[] bStringArray = new BString[s.length];
        for (int i = 0; i < s.length; ++i) {
            bStringArray[i] = StringUtils.fromString(s[i]);
        }
        return new ArrayValueImpl(bStringArray, false);
    }

    public static BArray fromStringSet(Set<String> set) {
        BString[] bStringArray = new BString[set.size()];
        int i = 0;
        for (String s : set) {
            bStringArray[i] = StringUtils.fromString(s);
            ++i;
        }
        return new ArrayValueImpl(bStringArray, false);
    }

    public static String getStringValue(Object value2) {
        return io.ballerina.runtime.internal.utils.StringUtils.getStringVal(value2, null);
    }

    @Deprecated(since="2201.6.0", forRemoval=true)
    public static String getStringValue(Object value2, BLink parent) {
        return io.ballerina.runtime.internal.utils.StringUtils.getStringVal(value2, parent);
    }

    public static String getExpressionStringValue(Object value2) {
        return io.ballerina.runtime.internal.utils.StringUtils.getExpressionStringVal(value2, null);
    }

    @Deprecated(since="2201.6.0", forRemoval=true)
    public static String getExpressionStringValue(Object value2, BLink parent) {
        return io.ballerina.runtime.internal.utils.StringUtils.getExpressionStringVal(value2, parent);
    }

    public static Object parseExpressionStringValue(String value2) throws BError {
        try {
            return io.ballerina.runtime.internal.utils.StringUtils.parseExpressionStringVal(value2, null);
        }
        catch (BError bError) {
            throw ErrorCreator.createError(ErrorReasons.STRING_OPERATION_ERROR, StringUtils.fromString(bError.getErrorMessage().getValue()));
        }
    }

    @Deprecated(since="2201.6.0", forRemoval=true)
    public static Object parseExpressionStringValue(String value2, BLink parent) throws BError {
        return io.ballerina.runtime.internal.utils.StringUtils.parseExpressionStringVal(value2, parent);
    }

    public static String getJsonString(Object value2) {
        Object jsonValue = JsonUtils.convertToJson(value2);
        Type type = TypeUtils.getImpliedType(TypeChecker.getType(jsonValue));
        return switch (type.getTag()) {
            case 14 -> "null";
            case 5 -> StringUtils.stringToJson((BString)jsonValue);
            case 27 -> {
                MapValueImpl mapValue = (MapValueImpl)jsonValue;
                yield mapValue.getJSONString();
            }
            case 32 -> {
                ArrayValue arrayValue = (ArrayValue)jsonValue;
                yield arrayValue.getJSONString();
            }
            default -> String.valueOf(jsonValue);
        };
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String stringToJson(BString value2) {
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            String string2;
            try (JsonGenerator gen = new JsonGenerator(byteOut);){
                gen.writeString(value2.getValue());
                gen.flush();
                string2 = byteOut.toString();
            }
            return string2;
        }
        catch (IOException e) {
            throw ErrorCreator.createError(StringUtils.fromString("Error in converting string value to a json string: " + e.getMessage()), e);
        }
    }

    private StringUtils() {
    }
}

