/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.cli;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.TypeConverter;
import java.util.List;

public final class CliUtil {
    private static final String INVALID_ARGUMENT_ERROR = "invalid argument '%s' for parameter '%s', expected %s value";

    static boolean isLongOption(String arg) {
        return arg.startsWith("--");
    }

    private CliUtil() {
    }

    static Object getBValueWithUnionValue(Type type, String value2, String parameterName) {
        if (TypeUtils.getImpliedType(type).getTag() == 33) {
            return CliUtil.getUnionValue(type, value2, parameterName);
        }
        return CliUtil.getBValue(type, value2, parameterName);
    }

    static Object getUnionValue(Type type, String value2, String parameterName) {
        List<Type> unionMemberTypes = ((UnionType)type).getMemberTypes();
        if (CliUtil.isUnionWithNil(unionMemberTypes)) {
            type = unionMemberTypes.get(0) == PredefinedTypes.TYPE_NULL ? unionMemberTypes.get(1) : unionMemberTypes.get(0);
            return CliUtil.getBValue(type, value2, parameterName);
        }
        throw CliUtil.getUnsupportedTypeException(type);
    }

    static Object getBValue(Type type, String value2, String parameterName) {
        return switch (TypeUtils.getImpliedType(type).getTag()) {
            case 5 -> StringUtils.fromString(value2);
            case 13 -> CliUtil.getCharValue(value2, parameterName);
            case 1, 7, 8, 9, 10, 11, 12 -> CliUtil.getIntegerValue(value2, parameterName);
            case 2 -> CliUtil.getByteValue(value2, parameterName);
            case 3 -> CliUtil.getFloatValue(value2, parameterName);
            case 4 -> CliUtil.getDecimalValue(value2, parameterName);
            case 53 -> CliUtil.getBValue(TypeUtils.getImpliedType(type), value2, parameterName);
            case 6 -> throw ErrorCreator.createError(StringUtils.fromString("the option '" + parameterName + "' of type 'boolean' is expected without a value"));
            default -> throw CliUtil.getUnsupportedTypeException(type);
        };
    }

    private static Object getCharValue(String argument, String parameterName) {
        try {
            return TypeConverter.stringToChar(StringUtils.fromString(argument));
        }
        catch (BError e) {
            throw CliUtil.getInvalidArgumentError(argument, parameterName, "string:Char");
        }
    }

    private static Object getByteValue(String argument, String parameterName) {
        try {
            return TypeConverter.stringToByte(argument);
        }
        catch (BError | NumberFormatException e) {
            throw CliUtil.getInvalidArgumentError(argument, parameterName, "byte");
        }
    }

    static BError getUnsupportedTypeException(Type type) {
        return ErrorCreator.createError(StringUtils.fromString("unsupported type expected with main function '" + String.valueOf(type) + "'"));
    }

    static boolean isUnionWithNil(Type fieldType) {
        if (TypeUtils.getImpliedType(fieldType).getTag() == 33) {
            List<Type> unionMemberTypes = ((UnionType)fieldType).getMemberTypes();
            if (CliUtil.isUnionWithNil(unionMemberTypes)) {
                return true;
            }
            throw CliUtil.getUnsupportedTypeException(fieldType);
        }
        return false;
    }

    static boolean isUnionWithNil(List<Type> unionMemberTypes) {
        return unionMemberTypes.size() == 2 && unionMemberTypes.contains(PredefinedTypes.TYPE_NULL);
    }

    private static long getIntegerValue(String argument, String parameterName) {
        try {
            return TypeConverter.stringToInt(argument);
        }
        catch (NumberFormatException e) {
            throw CliUtil.getInvalidArgumentError(argument, parameterName, "integer");
        }
    }

    private static double getFloatValue(String argument, String parameterName) {
        try {
            return TypeConverter.stringToFloat(argument);
        }
        catch (NumberFormatException e) {
            throw CliUtil.getInvalidArgumentError(argument, parameterName, "float");
        }
    }

    private static BDecimal getDecimalValue(String argument, String parameterName) {
        try {
            return TypeConverter.stringToDecimal(argument);
        }
        catch (BError | NumberFormatException e) {
            throw CliUtil.getInvalidArgumentError(argument, parameterName, "decimal");
        }
    }

    private static BError getInvalidArgumentError(String argument, String parameterName, String type) {
        return ErrorCreator.createError(StringUtils.fromString(String.format(INVALID_ARGUMENT_ERROR, argument, parameterName, type)));
    }

    static boolean isSupportedType(int tag) {
        return tag == 5 || tag == 1 || tag == 3 || tag == 4 || tag == 6;
    }
}

