/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.cli;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.cli.CliUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class Option {
    private static final String NAMED_ARG_DELIMITER = "=";
    private final RecordType recordType;
    private BMap<BString, Object> recordVal;
    private final List<String> operandArgs;
    private final Set<BString> recordKeysFound;
    private final int location;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?[0-9]+(\\.[0-9]+)?([eE][-+]?[0-9]+)?");
    private static final Pattern HEX_LITERAL = Pattern.compile("[-+]?0[xX][\\dA-Fa-f.pP\\-+]+");

    public Option(Type recordType, int location) {
        this((RecordType)TypeUtils.getImpliedType(recordType), location);
    }

    public Option(RecordType recordType, int location) {
        this.recordType = recordType;
        this.operandArgs = new ArrayList<String>();
        this.recordKeysFound = new HashSet<BString>();
        this.location = location;
    }

    public BMap<BString, Object> parseRecord(String[] args) {
        Module packageId = this.recordType.getPackage();
        this.recordVal = packageId == null ? ValueCreator.createRecordValue(this.recordType) : ValueCreator.createRecordValue(packageId, this.recordType.getName());
        int index = 0;
        while (index < args.length) {
            String arg;
            if (CliUtil.isLongOption(arg = args[index++])) {
                index = this.handleOption(args, index, arg);
                continue;
            }
            if (this.isShortOption(arg)) {
                this.validateConfigOption(arg);
                continue;
            }
            this.operandArgs.add(arg);
        }
        this.validateRecordKeys();
        return this.recordVal;
    }

    private boolean isShortOption(String arg) {
        return arg.startsWith("-") && !this.isNumeric(arg);
    }

    private boolean isNumeric(String stringVal) {
        if (TypeConverter.hasFloatOrDecimalLiteralSuffix(stringVal)) {
            stringVal = stringVal.substring(0, stringVal.length() - 1);
        }
        return NUMBER_PATTERN.matcher(stringVal).matches() || HEX_LITERAL.matcher(stringVal).matches();
    }

    private void validateConfigOption(String arg) {
        if (arg.length() == 1 || arg.charAt(1) != 'C') {
            throw ErrorCreator.createError(StringUtils.fromString("undefined CLI argument: '" + arg + "'"));
        }
    }

    private int handleOption(String[] args, int index, String optionStr) {
        if (optionStr.equals("--")) {
            return this.addOperands(args, index);
        }
        BString optionName = StringUtils.fromString(this.getOptionName(optionStr));
        this.validateFieldExists(optionName);
        if (this.isNamedArg(optionStr)) {
            this.processNamedArg(optionStr, optionName);
        } else if (!this.handleBooleanTrue(optionName)) {
            if (index < args.length) {
                this.handleOptionArgument(args[index++], optionStr, optionName);
            } else {
                this.validateOptionArgument(optionStr, optionStr);
            }
        }
        this.recordKeysFound.add(optionName);
        return index;
    }

    private void handleOptionArgument(String val2, String optionStr, BString optionName) {
        Type fieldType = TypeUtils.getImpliedType(this.recordType.getFields().get(optionName.getValue()).getFieldType());
        this.validateOptionArgument(optionStr, val2);
        if (fieldType.getTag() == 32) {
            this.handleArrayParameter(optionName, val2, (ArrayType)fieldType);
        } else {
            this.validateRepeatingOptions(optionName);
            this.recordVal.put(optionName, CliUtil.getBValueWithUnionValue(fieldType, val2, optionName.getValue()));
        }
    }

    private void validateRepeatingOptions(BString optionName) {
        if (this.recordKeysFound.contains(optionName)) {
            throw ErrorCreator.createError(StringUtils.fromString("The option '" + String.valueOf(optionName) + "' cannot be repeated"));
        }
    }

    private int addOperands(String[] args, int index) {
        while (index < args.length) {
            this.operandArgs.add(args[index++]);
        }
        return index;
    }

    private boolean handleBooleanTrue(BString paramName) {
        BArray bArray;
        Type elementType;
        Type fieldType = TypeUtils.getImpliedType(this.recordType.getFields().get(paramName.getValue()).getFieldType());
        if (this.isABoolean(fieldType)) {
            this.validateRepeatingOptions(paramName);
            this.recordVal.put(paramName, true);
            return true;
        }
        if (fieldType.getTag() == 32 && this.isABoolean(elementType = TypeUtils.getImpliedType((bArray = this.getBArray(paramName, (ArrayType)fieldType)).getElementType()))) {
            bArray.append(true);
            return true;
        }
        return false;
    }

    private void validateRecordKeys() {
        for (BString key : this.recordVal.getKeys()) {
            Type fieldType;
            if (this.recordKeysFound.contains(key) || !this.isRequired(this.recordType, key.getValue()) || CliUtil.isUnionWithNil(fieldType = TypeUtils.getImpliedType(this.recordType.getFields().get(key.getValue()).getFieldType())) || this.isSupportedArrayType(key, fieldType) || this.handleBooleanFalse(key, fieldType)) continue;
            throw ErrorCreator.createError(StringUtils.fromString("Missing required option argument: '" + String.valueOf(key) + "'"));
        }
    }

    private boolean handleBooleanFalse(BString key, Type fieldType) {
        if (this.isABoolean(fieldType)) {
            this.recordVal.put(key, false);
            return true;
        }
        return false;
    }

    private boolean isSupportedArrayType(BString key, Type fieldType) {
        if (TypeUtils.getImpliedType(fieldType).getTag() == 32) {
            BArray bArray = this.getBArray(key, (ArrayType)fieldType);
            Type elementType = TypeUtils.getImpliedType(bArray.getElementType());
            if (CliUtil.isSupportedType(elementType.getTag())) {
                if (this.recordVal.get(key) == null) {
                    this.recordVal.put(key, bArray);
                }
                return true;
            }
            throw CliUtil.getUnsupportedTypeException(fieldType);
        }
        return false;
    }

    private boolean isRequired(RecordType recordType, String fieldName) {
        return SymbolFlags.isFlagOn(recordType.getFields().get(fieldName).getFlags(), 256L);
    }

    private void validateOptionArgument(String arg, String val2) {
        if (CliUtil.isLongOption(val2)) {
            throw ErrorCreator.createError(StringUtils.fromString("Missing option argument for '" + arg + "'"));
        }
    }

    private BArray getBArray(BString paramName, ArrayType fieldType) {
        BArray bArray = (BArray)this.recordVal.get(paramName);
        if (bArray == null) {
            bArray = ValueCreator.createArrayValue(fieldType);
            this.recordVal.put(paramName, bArray);
        }
        return bArray;
    }

    private boolean isABoolean(Type fieldType) {
        return TypeUtils.getImpliedType(fieldType).getTag() == 6;
    }

    private void processNamedArg(String arg, BString paramName) {
        String val2 = this.getValueString(arg);
        Type fieldType = TypeUtils.getImpliedType(this.recordType.getFields().get(paramName.getValue()).getFieldType());
        if (fieldType.getTag() == 32) {
            this.handleArrayParameter(paramName, val2, (ArrayType)fieldType);
            return;
        }
        this.validateRepeatingOptions(paramName);
        this.recordVal.put(paramName, CliUtil.getBValueWithUnionValue(fieldType, val2, paramName.getValue()));
    }

    private void handleArrayParameter(BString paramName, String val2, ArrayType fieldType) {
        BArray bArray = this.getBArray(paramName, fieldType);
        Type arrayType = TypeUtils.getImpliedType(bArray.getElementType());
        bArray.append(CliUtil.getBValue(arrayType, val2, paramName.getValue()));
    }

    private void validateFieldExists(BString recordKey) {
        if (!this.recordVal.containsKey(recordKey) && !this.recordType.getFields().containsKey(recordKey.getValue())) {
            throw ErrorCreator.createError(StringUtils.fromString("undefined option: '" + String.valueOf(recordKey) + "'"));
        }
    }

    private String getValueString(String arg) {
        return arg.split(NAMED_ARG_DELIMITER, 2)[1];
    }

    private boolean isNamedArg(String arg) {
        return arg.contains(NAMED_ARG_DELIMITER);
    }

    private String getOptionName(String arg) {
        return arg.split(NAMED_ARG_DELIMITER, 2)[0].substring(2).trim();
    }

    public List<String> getOperandArgs() {
        return this.operandArgs;
    }

    public int getLocation() {
        return this.location;
    }
}

