/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers.toml;

import io.ballerina.runtime.internal.configurable.exceptions.ConfigException;
import io.ballerina.runtime.internal.configurable.providers.toml.Utils;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ConfigToml {
    private Path filePath;
    private String content;
    private TomlTableNode tomlAstNode;

    protected ConfigToml(Path filePath) {
        this.filePath = filePath;
    }

    protected ConfigToml(String content) {
        this.content = content;
    }

    public TomlTableNode tomlAstNode() {
        if (this.tomlAstNode != null) {
            return this.tomlAstNode;
        }
        this.tomlAstNode = this.content != null ? Toml.read(this.content, "BAL_CONFIG_DATA").rootNode() : this.getTomlRootFromFile();
        List<Diagnostic> diagnosticList = this.getDiagnostics();
        if (!diagnosticList.isEmpty()) {
            throw new ConfigException(ErrorCodes.CONFIG_TOML_INVALID_FILE, this.getErrorMessage(diagnosticList));
        }
        return this.tomlAstNode;
    }

    private TomlTableNode getTomlRootFromFile() {
        try {
            return Toml.read(this.filePath).rootNode();
        }
        catch (IOException e) {
            throw new ConfigException(ErrorCodes.CONFIG_TOML_READ_FAILED, this.filePath, e);
        }
    }

    private String getErrorMessage(List<Diagnostic> diagnosticList) {
        StringBuilder errorMessage = new StringBuilder("\n");
        for (Diagnostic diagnostic : diagnosticList) {
            LineRange lineRange = Utils.getOneBasedLineRange(diagnostic.location().lineRange());
            errorMessage.append("[").append(lineRange.fileName()).append(":").append(lineRange).append("] ").append(diagnostic.message()).append("\n");
        }
        return errorMessage.toString();
    }

    private List<Diagnostic> getDiagnostics() {
        return new ArrayList<Diagnostic>(this.tomlAstNode.diagnostics());
    }
}

