/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.regexp;

import io.ballerina.runtime.internal.regexp.Token;
import io.ballerina.runtime.internal.regexp.TokenKind;
import io.ballerina.runtime.internal.regexp.TreeTraverser;

public class TokenReader {
    private static final int BUFFER_SIZE = 20;
    private final TreeTraverser treeTraverser;
    private final TokenBuffer tokensAhead = new TokenBuffer(20);

    public TokenReader(TreeTraverser treeTraverser) {
        this.treeTraverser = treeTraverser;
    }

    public Token read() {
        if (this.tokensAhead.size > 0) {
            Token currentToken = this.tokensAhead.consume();
            return currentToken;
        }
        Token currentToken = this.treeTraverser.nextToken();
        return currentToken;
    }

    public Token peek() {
        if (this.tokensAhead.size > 0) {
            return this.tokensAhead.peek();
        }
        Token token = this.treeTraverser.nextToken();
        this.tokensAhead.add(token);
        return token;
    }

    public Token peek(int k) {
        TokenBuffer nextTokens = this.tokensAhead;
        while (nextTokens.size < k) {
            Token nextToken = this.treeTraverser.nextToken();
            if (nextTokens.size == nextTokens.capacity) {
                return TokenReader.createToken(TokenKind.EOF_TOKEN);
            }
            nextTokens.add(nextToken);
        }
        return nextTokens.peek(k);
    }

    public static Token createToken(TokenKind kind) {
        return new Token(kind);
    }

    private static class TokenBuffer {
        private final int capacity;
        private final Token[] tokens;
        private int endIndex = -1;
        private int startIndex = -1;
        private int size = 0;

        TokenBuffer(int size) {
            this.capacity = size;
            this.tokens = new Token[size];
        }

        public void add(Token token) {
            if (this.size == this.capacity) {
                throw new IndexOutOfBoundsException("buffer overflow");
            }
            this.endIndex = this.endIndex == this.capacity - 1 ? 0 : ++this.endIndex;
            if (this.size == 0) {
                this.startIndex = this.endIndex;
            }
            this.tokens[this.endIndex] = token;
            ++this.size;
        }

        public Token consume() {
            Token token = this.tokens[this.startIndex];
            --this.size;
            this.startIndex = this.startIndex == this.capacity - 1 ? 0 : ++this.startIndex;
            return token;
        }

        public Token peek() {
            return this.tokens[this.startIndex];
        }

        public Token peek(int k) {
            if (k > this.size) {
                throw new IndexOutOfBoundsException("size: " + this.size + ", index: " + k);
            }
            int index = this.startIndex + k - 1;
            if (index >= this.capacity) {
                index -= this.capacity;
            }
            return this.tokens[index];
        }
    }
}

