/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.scheduling;

import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.scheduling.WorkerChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WorkerChannelMap {
    private final Map<String, WorkerChannel> channelMap = new HashMap<String, WorkerChannel>();
    private final ReentrantReadWriteLock channelMapLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannelKeys(String[] channelKeys) {
        try {
            this.channelMapLock.writeLock().lock();
            for (String channelKey : channelKeys) {
                WorkerChannel workerChannel = this.channelMap.get(channelKey);
                if (workerChannel != null) continue;
                workerChannel = new WorkerChannel(channelKey);
                this.channelMap.put(channelKey, workerChannel);
            }
        }
        finally {
            this.channelMapLock.writeLock().unlock();
        }
    }

    public WorkerChannel get(String channelKey) {
        try {
            this.channelMapLock.readLock().lock();
            WorkerChannel workerChannel = this.channelMap.get(channelKey);
            return workerChannel;
        }
        finally {
            this.channelMapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panicSendWorkerChannels(String channelKey, BError error2) {
        try {
            this.channelMapLock.writeLock().lock();
            WorkerChannel workerChannel = this.channelMap.get(channelKey);
            workerChannel.panicOnSend(error2);
            if (workerChannel.done()) {
                this.channelMap.remove(channelKey);
            }
        }
        finally {
            this.channelMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panicReceiveWorkerChannels(String channelKey, BError error2) {
        try {
            this.channelMapLock.writeLock().lock();
            WorkerChannel workerChannel = this.channelMap.get(channelKey);
            workerChannel.panicOnReceive(error2);
            if (workerChannel.done()) {
                this.channelMap.remove(channelKey);
            }
        }
        finally {
            this.channelMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeSendWorkerChannels(String channelKey, Object returnValue) {
        try {
            this.channelMapLock.writeLock().lock();
            WorkerChannel workerChannel = this.channelMap.get(channelKey);
            workerChannel.errorOnSend(channelKey, returnValue);
            if (workerChannel.done()) {
                this.channelMap.remove(channelKey);
            }
        }
        finally {
            this.channelMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeReceiveWorkerChannels(String channelKey, Object returnValue) {
        try {
            this.channelMapLock.writeLock().lock();
            WorkerChannel workerChannel = this.channelMap.get(channelKey);
            workerChannel.errorOnReceive(channelKey, returnValue);
            if (workerChannel.done()) {
                this.channelMap.remove(channelKey);
            }
        }
        finally {
            this.channelMapLock.writeLock().unlock();
        }
    }

    public void cancel() {
        try {
            this.channelMapLock.writeLock().lock();
            this.channelMap.values().forEach(WorkerChannel::cancel);
        }
        finally {
            this.channelMapLock.writeLock().unlock();
        }
    }
}

