/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.troubleshoot;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.management.MBeanServer;

public final class StrandDump {
    private static final String HOT_SPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String WORKING_DIR = System.getProperty("user.dir") + "/";
    private static final String FILENAME = "threadDump" + String.valueOf(LocalDateTime.now());
    private static final String VIRTUAL_THREAD_IDENTIFIER = "virtual";
    private static final String ISOLATED_IDENTIFIER = "io.ballerina.runtime.internal.scheduling.Scheduler.lambda$startIsolated";
    private static final String NON_ISOLATED_IDENTIFIER = "io.ballerina.runtime.internal.scheduling.Scheduler.lambda$startNonIsolated";
    private static final String JAVA_TRACE_PATTERN = "java\\.|\\.java(?::\\d+)?";
    private static final String BAL_TRACE_PATTERN = "\\.bal:\\d+";
    private static volatile HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean;

    public static String getStrandDump() {
        String dump;
        try {
            StrandDump.getStrandDump(WORKING_DIR + FILENAME);
            dump = new String(Files.readAllBytes(Paths.get(FILENAME, new String[0])));
            File fileObj = new File(FILENAME);
            fileObj.delete();
        }
        catch (Exception e) {
            return "Error occurred during strand dump generation";
        }
        return StrandDump.generateOutput(dump);
    }

    private static String generateOutput(String dump) {
        String[] dumpItems = dump.split("\\n\\n");
        int id = 0;
        HashSet<Integer> isolatedStrandList = new HashSet<Integer>();
        HashSet<Integer> nonIsolatedStrandList = new HashSet<Integer>();
        HashMap balTraces = new HashMap();
        Pattern javaPattern = Pattern.compile(JAVA_TRACE_PATTERN);
        Pattern balPattern = Pattern.compile(BAL_TRACE_PATTERN);
        for (String item : dumpItems) {
            String[] lines = item.split("\\n");
            String[] subitems = lines[0].split("\" ");
            ArrayList<CallSite> balTraceItems = new ArrayList<CallSite>();
            boolean isBalStrand = false;
            if (subitems.length <= 1 || !subitems[1].equals(VIRTUAL_THREAD_IDENTIFIER)) continue;
            balTraceItems.add((CallSite)((Object)("\tStrand " + lines[0].replace(VIRTUAL_THREAD_IDENTIFIER, ":") + "\n\t\tat")));
            String prefix = " ";
            for (String line : lines) {
                if (!javaPattern.matcher(line).find() && !line.contains("\" virtual")) {
                    balTraceItems.add((CallSite)((Object)(prefix + line + "\n")));
                    prefix = "\t\t   ";
                    if (!balPattern.matcher(line).find()) continue;
                    isBalStrand = true;
                    continue;
                }
                if (line.contains(ISOLATED_IDENTIFIER)) {
                    isolatedStrandList.add(id);
                    continue;
                }
                if (!line.contains(NON_ISOLATED_IDENTIFIER)) continue;
                nonIsolatedStrandList.add(id);
            }
            if (isBalStrand) {
                balTraces.put(id, balTraceItems);
            } else {
                isolatedStrandList.remove(id);
                nonIsolatedStrandList.remove(id);
            }
            ++id;
        }
        StringBuilder outputStr = new StringBuilder("Ballerina Strand Dump [");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.now();
        outputStr.append(dateTimeFormatter.format(localDateTime));
        outputStr.append("]\n===============================================================\n\n");
        outputStr.append("Total Strand count       \t\t\t:\t").append(balTraces.size()).append("\n\n");
        outputStr.append("Total Isolated Strand count       \t\t:\t").append(isolatedStrandList.size()).append("\n\n");
        outputStr.append("Total Non Isolated Strand count       \t\t:\t").append(nonIsolatedStrandList.size()).append("\n\n");
        outputStr.append("================================================================\n");
        outputStr.append("\nIsolated Strands:\n\n");
        Iterator iterator2 = isolatedStrandList.iterator();
        while (iterator2.hasNext()) {
            int strandId = (Integer)iterator2.next();
            if (!balTraces.containsKey(strandId)) continue;
            ((ArrayList)balTraces.get(strandId)).forEach(outputStr::append);
            outputStr.append("\n");
        }
        outputStr.append("Non Isolated Strands:\n\n");
        iterator2 = nonIsolatedStrandList.iterator();
        while (iterator2.hasNext()) {
            int strandId = (Integer)iterator2.next();
            if (!balTraces.containsKey(strandId)) continue;
            ((ArrayList)balTraces.get(strandId)).forEach(outputStr::append);
            outputStr.append("\n");
        }
        return outputStr.toString();
    }

    private static void getStrandDump(String fileName) throws IOException {
        if (hotSpotDiagnosticMXBean == null) {
            hotSpotDiagnosticMXBean = StrandDump.getHotSpotDiagnosticMXBean();
        }
        hotSpotDiagnosticMXBean.dumpThreads(fileName, HotSpotDiagnosticMXBean.ThreadDumpFormat.TEXT_PLAIN);
    }

    private static HotSpotDiagnosticMXBean getHotSpotDiagnosticMXBean() throws IOException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        return ManagementFactory.newPlatformMXBeanProxy(mBeanServer, HOT_SPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
    }
}

