/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.ShapeSupplier;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.DefinitionContainer;
import io.ballerina.runtime.internal.types.semtype.ListDefinition;
import io.ballerina.runtime.internal.values.AbstractArrayValue;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class BTupleType
extends BAnnotatableType
implements TupleType,
TypeWithShape {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getListType();
    private List<Type> tupleTypes;
    private Type restType;
    private int typeFlags;
    private final boolean readonly;
    private volatile boolean flagsPoisoned = false;
    private IntersectionType immutableType;
    private IntersectionType intersectionType = null;
    public boolean isCyclic = false;
    private boolean resolving;
    private boolean resolvingReadonly;
    private String cachedToString;
    private final DefinitionContainer<ListDefinition> defn = new DefinitionContainer();
    private final DefinitionContainer<ListDefinition> acceptedTypeDefn = new DefinitionContainer();

    public BTupleType(List<Type> typeList) {
        super(null, null, Object.class);
        this.tupleTypes = typeList;
        this.restType = null;
        this.flagsPoisoned = true;
        this.readonly = false;
    }

    public BTupleType(List<Type> typeList, int typeFlags) {
        this(typeList, null, typeFlags, false, false);
    }

    public BTupleType(List<Type> typeList, Type restType, int typeFlags, boolean readonly) {
        this(typeList, restType, typeFlags, false, readonly);
    }

    public BTupleType(List<Type> typeList, Type restType, int typeFlags, boolean isCyclic, boolean readonly) {
        super(null, null, Object.class);
        if (readonly) {
            this.resolvingReadonly = true;
            this.tupleTypes = this.getReadOnlyTypes(typeList);
            this.restType = restType != null ? ReadOnlyUtils.getReadOnlyType(restType) : null;
            this.resolvingReadonly = false;
        } else {
            this.tupleTypes = typeList;
            this.restType = restType;
        }
        this.typeFlags = typeFlags;
        this.isCyclic = isCyclic;
        this.readonly = readonly;
    }

    public BTupleType(String name, Module pkg, int typeFlags, boolean isCyclic, boolean readonly) {
        super(name, pkg, Object.class);
        this.typeFlags = typeFlags;
        this.tupleTypes = new ArrayList<Type>(0);
        this.restType = null;
        this.isCyclic = isCyclic;
        this.readonly = readonly;
    }

    private void checkAllMembers() {
        if (this.resolving) {
            return;
        }
        this.resolving = true;
        this.resolvingReadonly = true;
        boolean isAllMembersPure = true;
        boolean isAllMembersAnydata = true;
        for (Type memberType : this.tupleTypes) {
            isAllMembersPure &= memberType.isPureType();
            isAllMembersAnydata &= memberType.isAnydata();
        }
        if (this.restType != null) {
            isAllMembersPure &= this.restType.isPureType();
            isAllMembersAnydata &= this.restType.isAnydata();
        }
        this.resolvingReadonly = false;
        this.resolving = false;
        if (isAllMembersPure) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 4);
        }
        if (isAllMembersAnydata) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 2, 4);
        }
    }

    private List<Type> getReadOnlyTypes(List<Type> typeList) {
        ArrayList<Type> readOnlyTypes = new ArrayList<Type>();
        for (Type type : typeList) {
            readOnlyTypes.add(ReadOnlyUtils.getReadOnlyType(type));
        }
        return readOnlyTypes;
    }

    @Override
    public List<Type> getTupleTypes() {
        return this.tupleTypes;
    }

    @Override
    public Type getRestType() {
        return this.restType;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
    }

    public void setMemberTypes(List<Type> members, Type restType) {
        this.resetSemType();
        if (members == null) {
            return;
        }
        if (this.readonly) {
            this.resolvingReadonly = true;
            this.tupleTypes = this.getReadOnlyTypes(members);
            this.restType = restType != null ? ReadOnlyUtils.getReadOnlyType(restType) : null;
            this.resolvingReadonly = false;
        } else {
            this.tupleTypes = members;
            this.restType = restType;
        }
        this.flagsPoisoned = true;
        this.defn.clear();
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new TupleValueImpl(this);
    }

    @Override
    public <V> V getEmptyValue() {
        return this.getZeroValue();
    }

    @Override
    public int getTag() {
        return 44;
    }

    private String getQualifiedName(String name) {
        return this.pkg == null || this.pkg.getName() == null || this.pkg.getName().equals(".") ? name : this.pkg.toString() + ":" + name;
    }

    @Override
    public String toString() {
        if (this.resolving) {
            if (this.typeName != null) {
                return this.getQualifiedName(this.typeName);
            }
            return "...";
        }
        this.resolving = true;
        this.computeStringRepresentation();
        this.resolving = false;
        return this.cachedToString;
    }

    private void computeStringRepresentation() {
        if (this.cachedToString != null) {
            return;
        }
        StringBuilder stringRep = new StringBuilder("[").append(this.tupleTypes.stream().map(Type::toString).collect(Collectors.joining(",")));
        if (this.restType != null) {
            stringRep.append(this.tupleTypes.isEmpty() ? "" : ",").append(this.restType).append("...]");
        } else {
            stringRep.append("]");
        }
        this.cachedToString = this.readonly ? String.valueOf(stringRep) + " & readonly" : stringRep.toString();
    }

    @Override
    public boolean isCyclic() {
        return this.isCyclic;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BTupleType)) {
            return false;
        }
        BTupleType that = (BTupleType)o;
        if (this.isCyclic || that.isCyclic) {
            if (this.isCyclic != that.isCyclic) {
                return false;
            }
            return super.equals(that);
        }
        if (this.readonly != that.readonly) {
            return false;
        }
        if ((this.restType == null || that.restType == null) && this.restType != that.restType) {
            return false;
        }
        if (this.restType == null) {
            return Objects.equals(this.tupleTypes, that.tupleTypes);
        }
        return Objects.equals(this.tupleTypes, that.tupleTypes) && this.restType.equals(that.restType);
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.getTypeFlags(), 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.getTypeFlags(), 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTypeFlags() {
        if (this.flagsPoisoned) {
            BTupleType bTupleType = this;
            synchronized (bTupleType) {
                if (this.flagsPoisoned) {
                    this.checkAllMembers();
                    this.flagsPoisoned = false;
                }
            }
        }
        return this.typeFlags;
    }

    @Override
    public boolean isReadOnly() {
        if (this.resolvingReadonly) {
            return true;
        }
        return this.readonly;
    }

    @Override
    public IntersectionType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    @Override
    public String getAnnotationKey() {
        return Utils.decodeIdentifier(this.typeName);
    }

    @Override
    public SemType createSemType(Context cx) {
        Env env = cx.env;
        if (this.defn.isDefinitionReady()) {
            return this.defn.getSemType(env);
        }
        DefinitionContainer.DefinitionUpdateResult<ListDefinition> result = this.defn.trySetDefinition(ListDefinition::new);
        if (!result.updated()) {
            return this.defn.getSemType(env);
        }
        ListDefinition ld = result.definition();
        return this.createSemTypeInner(cx, ld, SemType::tryInto, this.mut());
    }

    private CellAtomicType.CellMutability mut() {
        return this.isReadOnly() ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
    }

    private SemType createSemTypeInner(Context cx, ListDefinition ld, BiFunction<Context, Type, SemType> semTypeFunction, CellAtomicType.CellMutability mut) {
        Env env = cx.env;
        SemType[] memberTypes = new SemType[this.tupleTypes.size()];
        for (int i = 0; i < this.tupleTypes.size(); ++i) {
            SemType memberType = semTypeFunction.apply(cx, this.tupleTypes.get(i));
            if (Core.isNever(memberType)) {
                return Builder.getNeverType();
            }
            memberTypes[i] = memberType;
        }
        SemType rest = this.restType != null ? semTypeFunction.apply(cx, this.restType) : Builder.getNeverType();
        return ld.defineListTypeWrapped(env, memberTypes, memberTypes.length, rest, mut);
    }

    @Override
    public void resetSemType() {
        this.defn.clear();
        super.resetSemType();
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        return this.tupleTypes.stream().filter(each -> each instanceof MayBeDependentType).anyMatch(each -> ((MayBeDependentType)((Object)each)).isDependentlyTyped(visited));
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        if (!this.couldInherentTypeBeDifferent()) {
            return Optional.of(this.getSemType(cx));
        }
        AbstractArrayValue value2 = (AbstractArrayValue)object;
        SemType cachedShape = value2.shapeOf();
        if (cachedShape != null) {
            return Optional.of(cachedShape);
        }
        SemType semType = this.shapeOfInner(cx, shapeSupplier, value2);
        value2.cacheShape(semType);
        return Optional.of(semType);
    }

    @Override
    public boolean couldInherentTypeBeDifferent() {
        return this.isReadOnly();
    }

    @Override
    public Optional<SemType> shapeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        return Optional.of(this.shapeOfInner(cx, shapeSupplier, (AbstractArrayValue)object));
    }

    @Override
    public SemType acceptedTypeOf(Context cx) {
        Env env = cx.env;
        if (this.acceptedTypeDefn.isDefinitionReady()) {
            return this.acceptedTypeDefn.getSemType(env);
        }
        DefinitionContainer.DefinitionUpdateResult<ListDefinition> result = this.acceptedTypeDefn.trySetDefinition(ListDefinition::new);
        if (!result.updated()) {
            return this.acceptedTypeDefn.getSemType(env);
        }
        return this.createSemTypeInner(cx, result.definition(), ShapeAnalyzer::acceptedTypeOf, CellAtomicType.CellMutability.CELL_MUT_UNLIMITED);
    }

    private SemType shapeOfInner(Context cx, ShapeSupplier shapeSupplier, AbstractArrayValue value2) {
        Env env = cx.env;
        ListDefinition defn = value2.getReadonlyShapeDefinition();
        if (defn != null) {
            return defn.getSemType(env);
        }
        int size = value2.size();
        SemType[] memberTypes = new SemType[size];
        ListDefinition ld = new ListDefinition();
        value2.setReadonlyShapeDefinition(ld);
        for (int i = 0; i < size; ++i) {
            Optional<SemType> memberType = shapeSupplier.get(cx, value2.get(i));
            assert (memberType.isPresent());
            memberTypes[i] = memberType.get();
        }
        SemType semType = ld.defineListTypeWrapped(env, memberTypes, memberTypes.length, Builder.getNeverType(), this.mut());
        value2.resetReadonlyShapeDefinition();
        return semType;
    }
}

