/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.utils.ErrorUtils;

public final class MathUtils {
    private static final BString DIVIDE_BY_ZERO_ERROR = StringUtils.fromString(" / by zero");

    private MathUtils() {
    }

    public static long divide(long numerator, long denominator) {
        try {
            if (numerator == Long.MIN_VALUE && denominator == -1L) {
                throw ErrorUtils.createIntOverflowError();
            }
            return numerator / denominator;
        }
        catch (ArithmeticException e) {
            if (denominator == 0L) {
                throw ErrorCreator.createError(ErrorReasons.DIVISION_BY_ZERO_ERROR, DIVIDE_BY_ZERO_ERROR);
            }
            throw ErrorCreator.createError(ErrorReasons.ARITHMETIC_OPERATION_ERROR, StringUtils.fromString(e.getMessage()));
        }
    }

    public static long remainder(long numerator, long denominator) {
        try {
            return numerator % denominator;
        }
        catch (ArithmeticException e) {
            throw ErrorCreator.createError(ErrorReasons.DIVISION_BY_ZERO_ERROR, DIVIDE_BY_ZERO_ERROR);
        }
    }

    public static long addExact(long num1, long num2) {
        try {
            return Math.addExact(num1, num2);
        }
        catch (ArithmeticException e) {
            throw ErrorUtils.createIntOverflowError();
        }
    }

    public static long addExact(long num1, long num2, BString errorMsg) {
        try {
            return Math.addExact(num1, num2);
        }
        catch (ArithmeticException e) {
            throw ErrorUtils.createIntOverflowError(errorMsg);
        }
    }

    public static long subtractExact(long num1, long num2) {
        try {
            return Math.subtractExact(num1, num2);
        }
        catch (ArithmeticException e) {
            throw ErrorUtils.createIntOverflowError();
        }
    }

    public static long multiplyExact(long num1, long num2) {
        try {
            return Math.multiplyExact(num1, num2);
        }
        catch (ArithmeticException e) {
            throw ErrorUtils.createIntOverflowError();
        }
    }
}

