/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.types.TypedescType;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BListInitialValueEntry;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.commons.TypeValuePair;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.regexp.RegExpFactory;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.utils.BalStringUtils;
import io.ballerina.runtime.internal.utils.CloneUtils;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import io.ballerina.runtime.internal.values.XmlSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class ValueConverter {
    private ValueConverter() {
    }

    public static Object convert(Object value2, BTypedesc t) {
        return ValueConverter.convert(value2, t.getDescribingType());
    }

    public static Object convert(Object value2, Type targetType) {
        return ValueConverter.convert(value2, targetType, new HashSet<TypeValuePair>());
    }

    private static Object convert(Object value2, Type targetType, Set<TypeValuePair> unresolvedValues) {
        Object newValue;
        if (value2 == null) {
            if (ValueConverter.getTargetFromTypeDesc(targetType).isNilable()) {
                return null;
            }
            throw ErrorCreator.createError(ErrorReasons.BALLERINA_PREFIXED_CONVERSION_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.CANNOT_CONVERT_NIL, targetType));
        }
        Type sourceType = TypeUtils.getImpliedType(TypeChecker.getType(value2));
        TypeValuePair typeValuePair = new TypeValuePair(value2, targetType);
        if (unresolvedValues.contains(typeValuePair)) {
            throw ErrorCreator.createError(ErrorReasons.BALLERINA_PREFIXED_CYCLIC_VALUE_REFERENCE_ERROR, ErrorHelper.getErrorMessage(ErrorCodes.CYCLIC_VALUE_REFERENCE, sourceType));
        }
        unresolvedValues.add(typeValuePair);
        ArrayList<String> errors = new ArrayList<String>();
        Type convertibleType = TypeConverter.getConvertibleType(value2, targetType, null, new HashSet<TypeValuePair>(), errors, true);
        if (convertibleType == null) {
            throw CloneUtils.createConversionError(value2, targetType, errors);
        }
        Type matchingType = TypeUtils.getImpliedType(convertibleType);
        switch (sourceType.getTag()) {
            case 24: 
            case 27: {
                newValue = ValueConverter.convertMap((BMap)value2, matchingType, convertibleType, unresolvedValues);
                break;
            }
            case 32: 
            case 44: {
                newValue = ValueConverter.convertArray((BArray)value2, matchingType, convertibleType, unresolvedValues);
                break;
            }
            case 17: {
                newValue = ValueConverter.convertTable((BTable)value2, matchingType, convertibleType, unresolvedValues);
                break;
            }
            default: {
                if (TypeChecker.isRegExpType(targetType) && matchingType.getTag() == 5) {
                    try {
                        newValue = RegExpFactory.parse(((BString)value2).getValue());
                        break;
                    }
                    catch (BError e) {
                        throw ErrorUtils.createConversionError(value2, targetType, e.getMessage());
                    }
                }
                if (TypeTags.isXMLTypeTag(matchingType.getTag())) {
                    String xmlString = value2.toString();
                    try {
                        newValue = BalStringUtils.parseXmlExpressionStringValue(xmlString);
                    }
                    catch (BError e) {
                        throw ErrorUtils.createConversionError(value2, targetType);
                    }
                    if (matchingType.isReadOnly()) {
                        newValue = CloneUtils.cloneReadOnly(newValue);
                    }
                    newValue = ValueConverter.xmlSequenceHack(newValue, matchingType);
                    break;
                }
                if (TypeChecker.checkIsType(value2, matchingType)) {
                    newValue = CloneUtils.cloneValue(value2);
                    break;
                }
                if (sourceType.getTag() <= 6) {
                    newValue = TypeConverter.convertValues(matchingType, value2);
                    break;
                }
                throw ErrorUtils.createConversionError(value2, targetType);
            }
        }
        unresolvedValues.remove(typeValuePair);
        return newValue;
    }

    private static Object xmlSequenceHack(Object value2, Type targetType) {
        if (!(value2 instanceof XmlSequence)) {
            return value2;
        }
        XmlSequence xmlSequence = (XmlSequence)value2;
        Context cx = TypeChecker.context();
        ArrayList<BXml> list = new ArrayList<BXml>();
        SemType targetSemType = SemType.tryInto(cx, targetType);
        for (BXml child : xmlSequence.getChildrenList()) {
            SemType childType = SemType.tryInto(cx, child.getType());
            boolean isReadonly = Core.isSubType(cx, Core.intersect(childType, targetSemType), Builder.getReadonlyType());
            if (isReadonly) {
                list.add((BXml)CloneUtils.cloneReadOnly(child));
                continue;
            }
            list.add(child);
        }
        return new XmlSequence(list);
    }

    private static Type getTargetFromTypeDesc(Type targetType) {
        Type referredType = TypeUtils.getImpliedType(targetType);
        if (referredType.getTag() == 25) {
            return ((TypedescType)referredType).getConstraint();
        }
        return targetType;
    }

    private static Object convertMap(BMap<?, ?> map2, Type targetType, Type targetRefType, Set<TypeValuePair> unresolvedValues) {
        switch (targetType.getTag()) {
            case 27: {
                BMapInitialValueEntry[] initialValues = new BMapInitialValueEntry[map2.entrySet().size()];
                Type constraintType = ((MapType)targetType).getConstrainedType();
                int count = 0;
                for (Map.Entry<?, ?> entry : map2.entrySet()) {
                    Object newValue = ValueConverter.convert(entry.getValue(), constraintType, unresolvedValues);
                    initialValues[count] = ValueCreator.createKeyFieldEntry(StringUtils.fromString(entry.getKey().toString()), newValue);
                    ++count;
                }
                return new MapValueImpl(targetRefType, initialValues);
            }
            case 24: {
                RecordType recordType = (RecordType)targetType;
                Type restFieldType = recordType.getRestFieldType();
                HashMap<String, Type> targetTypeField = new HashMap<String, Type>();
                for (Field field : recordType.getFields().values()) {
                    targetTypeField.put(field.getFieldName(), field.getFieldType());
                }
                return ValueConverter.convertToRecord(map2, unresolvedValues, targetRefType, restFieldType, targetTypeField);
            }
        }
        throw ErrorUtils.createConversionError(map2, targetType);
    }

    private static BMap<BString, Object> convertToRecord(BMap<?, ?> map2, Set<TypeValuePair> unresolvedValues, Type recordRefType, Type restFieldType, Map<String, Type> targetTypeField) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            Object newValue = ValueConverter.convertRecordEntry(unresolvedValues, restFieldType, targetTypeField, entry);
            valueMap.put(entry.getKey().toString(), newValue);
        }
        Optional<IntersectionType> intersectionType = ((BRecordType)TypeUtils.getImpliedType(recordRefType)).getIntersectionType();
        if (recordRefType.isReadOnly() && intersectionType.isPresent() && !map2.getType().isReadOnly()) {
            Type mutableType = ReadOnlyUtils.getMutableType((BIntersectionType)intersectionType.get());
            return ValueCreator.createReadonlyRecordValue(mutableType.getPackage(), mutableType.getName(), valueMap);
        }
        return ValueCreator.createRecordValue(recordRefType.getPackage(), recordRefType.getName(), valueMap);
    }

    private static Object convertRecordEntry(Set<TypeValuePair> unresolvedValues, Type restFieldType, Map<String, Type> targetTypeField, Map.Entry<?, ?> entry) {
        Type fieldType = targetTypeField.getOrDefault(entry.getKey().toString(), restFieldType);
        return ValueConverter.convert(entry.getValue(), fieldType, unresolvedValues);
    }

    private static Object convertArray(BArray array2, Type targetType, Type targetRefType, Set<TypeValuePair> unresolvedValues) {
        switch (targetType.getTag()) {
            case 32: {
                ArrayType arrayType = (ArrayType)targetType;
                BListInitialValueEntry[] arrayValues = new BListInitialValueEntry[array2.size()];
                for (int i = 0; i < array2.size(); ++i) {
                    Object newValue = ValueConverter.convert(array2.get(i), arrayType.getElementType(), unresolvedValues);
                    arrayValues[i] = ValueCreator.createListInitialValueEntry(newValue);
                }
                return new ArrayValueImpl(targetRefType, (long)arrayType.getSize(), arrayValues);
            }
            case 44: {
                TupleType tupleType = (TupleType)targetType;
                int minLen = tupleType.getTupleTypes().size();
                BListInitialValueEntry[] tupleValues = new BListInitialValueEntry[array2.size()];
                for (int i = 0; i < array2.size(); ++i) {
                    Type elementType = i < minLen ? tupleType.getTupleTypes().get(i) : tupleType.getRestType();
                    Object newValue = ValueConverter.convert(array2.get(i), elementType, unresolvedValues);
                    tupleValues[i] = ValueCreator.createListInitialValueEntry(newValue);
                }
                return new TupleValueImpl(targetRefType, tupleValues);
            }
            case 17: {
                TableType tableType = (TableType)targetType;
                Object[] tableValues = new Object[array2.size()];
                for (int i = 0; i < array2.size(); ++i) {
                    BMap bMap = (BMap)ValueConverter.convert(array2.get(i), tableType.getConstrainedType(), unresolvedValues);
                    tableValues[i] = bMap;
                }
                BArray data = ValueCreator.createArrayValue(tableValues, TypeCreator.createArrayType(tableType.getConstrainedType()));
                BArray fieldNames = StringUtils.fromStringArray(tableType.getFieldNames());
                return new TableValueImpl(targetRefType, (ArrayValue)data, (ArrayValue)fieldNames);
            }
        }
        throw ErrorUtils.createConversionError(array2, targetType);
    }

    private static Object convertTable(BTable<?, ?> bTable, Type targetType, Type targetRefType, Set<TypeValuePair> unresolvedValues) {
        TableType tableType = (TableType)targetType;
        Optional<IntersectionType> intersectionType = tableType.getIntersectionType();
        if (targetRefType.isReadOnly() && intersectionType.isPresent() && !bTable.getType().isReadOnly()) {
            tableType = (TableType)ReadOnlyUtils.getMutableType((BIntersectionType)intersectionType.get());
            TableValueImpl<?, ?> tableValue = ValueConverter.getTableValue(bTable, unresolvedValues, tableType, tableType);
            tableValue.freezeDirect();
            return tableValue;
        }
        return ValueConverter.getTableValue(bTable, unresolvedValues, tableType, targetRefType);
    }

    private static TableValueImpl<?, ?> getTableValue(BTable<?, ?> bTable, Set<TypeValuePair> unresolvedValues, TableType tableType, Type targetRefType) {
        Object[] tableValues = new Object[bTable.size()];
        int count = 0;
        for (Object tableValue : bTable.values()) {
            BMap bMap = (BMap)ValueConverter.convert(tableValue, tableType.getConstrainedType(), unresolvedValues);
            tableValues[count++] = bMap;
        }
        BArray data = ValueCreator.createArrayValue(tableValues, TypeCreator.createArrayType(tableType.getConstrainedType()));
        BArray fieldNames = StringUtils.fromStringArray(tableType.getFieldNames());
        return new TableValueImpl(targetRefType, (ArrayValue)data, (ArrayValue)fieldNames);
    }

    public static Object getConvertedStringValue(BString bString, Type targetType) throws BError {
        BXml xmlValue;
        if (TypeChecker.checkIsType(bString, targetType)) {
            return bString;
        }
        List<Type> xmlTargetTypes = TypeConverter.getXmlTargetTypes(targetType);
        if (xmlTargetTypes.isEmpty()) {
            throw ErrorUtils.createConversionError(bString, targetType);
        }
        try {
            xmlValue = TypeConverter.stringToXml(bString.getValue());
        }
        catch (BError e) {
            throw ErrorUtils.createConversionError(bString, targetType);
        }
        for (Type xmlTargetType : xmlTargetTypes) {
            if (!TypeChecker.checkIsLikeType(xmlValue, xmlTargetType)) continue;
            if (xmlTargetType.isReadOnly()) {
                xmlValue.freezeDirect();
            }
            return xmlValue;
        }
        throw ErrorUtils.createConversionError(bString, targetType);
    }
}

