/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BListInitialValueEntry;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.utils.CycleUtils;
import io.ballerina.runtime.internal.utils.StringUtils;
import io.ballerina.runtime.internal.utils.ValueConverter;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.AbstractArrayValue;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.ListInitialValueEntry;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.TypedescValue;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.IntStream;

public class ArrayValueImpl
extends AbstractArrayValue {
    private Type elementReferredType;
    protected Type type;
    protected ArrayType arrayType;
    protected Type elementType;
    private TypedescValue elementTypedescValue = null;
    protected Object[] refValues;
    private long[] intValues;
    private boolean[] booleanValues;
    private byte[] byteValues;
    private double[] floatValues;
    private BString[] bStringValues;
    private BTypedesc typedesc;
    private SemType shape;

    public ArrayValueImpl(Object[] values, ArrayType type) {
        this.refValues = values;
        this.arrayType = type;
        this.type = this.arrayType;
        this.size = values.length;
        this.elementType = type.getElementType();
        this.elementReferredType = TypeUtils.getImpliedType(this.elementType);
    }

    public ArrayValueImpl(long[] values, boolean readonly) {
        this.intValues = values;
        this.size = values.length;
        this.setArrayType(PredefinedTypes.TYPE_INT, readonly);
    }

    public ArrayValueImpl(boolean[] values, boolean readonly) {
        this.booleanValues = values;
        this.size = values.length;
        this.setArrayType(PredefinedTypes.TYPE_BOOLEAN, readonly);
    }

    public ArrayValueImpl(byte[] values, boolean readonly) {
        this.byteValues = values;
        this.size = values.length;
        this.setArrayType(PredefinedTypes.TYPE_BYTE, readonly);
    }

    public ArrayValueImpl(double[] values, boolean readonly) {
        this.floatValues = values;
        this.size = values.length;
        this.setArrayType(PredefinedTypes.TYPE_FLOAT, readonly);
    }

    public ArrayValueImpl(String[] values, boolean readonly) {
        this.size = values.length;
        this.bStringValues = new BString[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.bStringValues[i] = io.ballerina.runtime.api.utils.StringUtils.fromString(values[i]);
        }
        this.setArrayType(PredefinedTypes.TYPE_STRING, readonly);
    }

    public ArrayValueImpl(BString[] values, boolean readonly) {
        this.bStringValues = values;
        this.size = values.length;
        this.setArrayType(PredefinedTypes.TYPE_STRING, readonly);
    }

    public ArrayValueImpl(ArrayType type) {
        this(type, (long)type.getSize());
    }

    private void initArrayValues() {
        int initialArraySize = this.arrayType.getSize() != -1 ? this.arrayType.getSize() : 100;
        switch (this.elementReferredType.getTag()) {
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.intValues = new long[initialArraySize];
                break;
            }
            case 3: {
                this.floatValues = new double[initialArraySize];
                break;
            }
            case 5: 
            case 13: {
                this.bStringValues = new BString[initialArraySize];
                if (this.arrayType.getState() != ArrayType.ArrayState.CLOSED) break;
                this.fillValues(initialArraySize);
                break;
            }
            case 6: {
                this.booleanValues = new boolean[initialArraySize];
                break;
            }
            case 2: {
                this.byteValues = new byte[initialArraySize];
                break;
            }
            default: {
                this.refValues = new Object[initialArraySize];
                if (this.arrayType.getState() != ArrayType.ArrayState.CLOSED) break;
                this.fillValues(initialArraySize);
            }
        }
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = ValueUtils.getTypedescValue(this.type, this);
        }
        return this.typedesc;
    }

    @Override
    public Object reverse() {
        return switch (this.elementType.getTag()) {
            case 1, 7, 8, 9, 10, 11, 12 -> {
                int i = this.size - 1;
                for (int j = 0; j < this.size / 2; ++j) {
                    long temp = this.intValues[j];
                    this.intValues[j] = this.intValues[i];
                    this.intValues[i] = temp;
                    --i;
                }
                yield this.intValues;
            }
            case 5, 13 -> {
                int i = this.size - 1;
                for (int j = 0; j < this.size / 2; ++j) {
                    BString temp = this.bStringValues[j];
                    this.bStringValues[j] = this.bStringValues[i];
                    this.bStringValues[i] = temp;
                    --i;
                }
                yield (Object[])this.bStringValues;
            }
            case 3 -> {
                int i = this.size - 1;
                for (int j = 0; j < this.size / 2; ++j) {
                    double temp = this.floatValues[j];
                    this.floatValues[j] = this.floatValues[i];
                    this.floatValues[i] = temp;
                    --i;
                }
                yield (Object[])this.floatValues;
            }
            case 6 -> {
                int i = this.size - 1;
                for (int j = 0; j < this.size / 2; ++j) {
                    boolean temp = this.booleanValues[j];
                    this.booleanValues[j] = this.booleanValues[i];
                    this.booleanValues[i] = temp;
                    --i;
                }
                yield (Object[])this.booleanValues;
            }
            case 2 -> {
                int i = this.size - 1;
                for (int j = 0; j < this.size / 2; ++j) {
                    byte temp = this.byteValues[j];
                    this.byteValues[j] = this.byteValues[i];
                    this.byteValues[i] = temp;
                    --i;
                }
                yield this.byteValues;
            }
            default -> {
                int i = this.size - 1;
                for (int j = 0; j < this.size / 2; ++j) {
                    Object temp = this.refValues[j];
                    this.refValues[j] = this.refValues[i];
                    this.refValues[i] = temp;
                    --i;
                }
                yield (Object[])this.refValues;
            }
        };
    }

    public ArrayValueImpl(ArrayType type, long size) {
        this.arrayType = type;
        this.type = this.arrayType;
        this.elementType = type.getElementType();
        this.elementReferredType = TypeUtils.getImpliedType(this.elementType);
        this.initArrayValues();
        if (size != -1L) {
            this.size = this.maxSize = (int)size;
        }
    }

    public ArrayValueImpl(Type type, long size) {
        this((ArrayType)TypeUtils.getImpliedType(type), size);
        this.type = type;
    }

    public ArrayValueImpl(Type type, long size, BListInitialValueEntry[] initialValues) {
        this(type, size, initialValues, null);
    }

    public ArrayValueImpl(Type type, BListInitialValueEntry[] initialValues) {
        this(type, ((ArrayType)TypeUtils.getImpliedType(type)).getSize(), initialValues, null);
    }

    public ArrayValueImpl(ArrayType type, long size, BListInitialValueEntry[] initialValues) {
        this(type, size, initialValues, null);
    }

    public ArrayValueImpl(Type type, BListInitialValueEntry[] initialValues, TypedescValue typedescValue) {
        this(type, ((ArrayType)TypeUtils.getImpliedType(type)).getSize(), initialValues, typedescValue);
    }

    public ArrayValueImpl(Type type, long size, BListInitialValueEntry[] initialValues, TypedescValue typedescValue) {
        this.type = type;
        this.arrayType = (ArrayType)TypeUtils.getImpliedType(type);
        this.elementType = this.arrayType.getElementType();
        this.elementReferredType = TypeUtils.getImpliedType(this.elementType);
        this.elementTypedescValue = typedescValue;
        this.initArrayValues();
        if (size != -1L) {
            this.size = this.maxSize = (int)size;
        }
        int index = 0;
        for (BListInitialValueEntry listEntry : initialValues) {
            if (listEntry instanceof ListInitialValueEntry.ExpressionEntry) {
                this.addRefValue(index++, ((ListInitialValueEntry.ExpressionEntry)listEntry).value);
                continue;
            }
            BArray values = ((ListInitialValueEntry.SpreadEntry)listEntry).values;
            BIterator<?> iterator2 = values.getIterator();
            while (iterator2.hasNext()) {
                this.addRefValue(index++, iterator2.next());
            }
        }
    }

    @Override
    public Object get(long index) {
        this.rangeCheckForGet(index, this.size);
        return switch (this.elementReferredType.getTag()) {
            case 1, 7, 8, 9, 10, 11, 12 -> this.intValues[(int)index];
            case 6 -> this.booleanValues[(int)index];
            case 2 -> Byte.toUnsignedInt(this.byteValues[(int)index]);
            case 3 -> this.floatValues[(int)index];
            case 5, 13 -> this.bStringValues[(int)index];
            default -> this.refValues[(int)index];
        };
    }

    public Object getRefValue(int index) {
        return this.refValues[index];
    }

    @Override
    public Object getRefValue(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.refValues != null) {
            return this.refValues[(int)index];
        }
        return this.get(index);
    }

    @Override
    public Object fillAndGetRefValue(long index) {
        if (this.refValues != null) {
            if (index >= (long)this.size) {
                this.handleImmutableArrayValue();
                this.fillRead(index, this.refValues.length);
            }
            return this.refValues[(int)index];
        }
        return this.get(index);
    }

    @Override
    public long getInt(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.intValues != null) {
            return this.intValues[(int)index];
        }
        if (this.refValues != null) {
            return (Long)this.refValues[(int)index];
        }
        return Byte.toUnsignedInt(this.byteValues[(int)index]);
    }

    @Override
    public boolean getBoolean(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.booleanValues != null) {
            return this.booleanValues[(int)index];
        }
        return (Boolean)this.refValues[(int)index];
    }

    @Override
    public byte getByte(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.byteValues != null) {
            return this.byteValues[(int)index];
        }
        if (this.intValues != null) {
            return Long.valueOf(this.intValues[(int)index]).byteValue();
        }
        return ((Long)this.refValues[(int)index]).byteValue();
    }

    @Override
    public double getFloat(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.floatValues != null) {
            return this.floatValues[(int)index];
        }
        return (Double)this.refValues[(int)index];
    }

    @Override
    @Deprecated
    public String getString(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.bStringValues != null) {
            return this.bStringValues[(int)index].getValue();
        }
        return (String)this.refValues[(int)index];
    }

    @Override
    public BString getBString(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.bStringValues != null) {
            return this.bStringValues[(int)index];
        }
        return (BString)this.refValues[(int)index];
    }

    @Override
    public void add(long index, Object value2) {
        this.handleImmutableArrayValue();
        this.addRefValue(index, value2);
    }

    @Override
    public void add(long index, long value2) {
        this.handleImmutableArrayValue();
        this.addInt(index, value2);
    }

    @Override
    public void add(long index, boolean value2) {
        this.handleImmutableArrayValue();
        this.addBoolean(index, value2);
    }

    @Override
    public void add(long index, byte value2) {
        this.handleImmutableArrayValue();
        this.addByte(index, value2);
    }

    @Override
    public void add(long index, double value2) {
        this.handleImmutableArrayValue();
        this.addFloat(index, value2);
    }

    @Override
    @Deprecated
    public void add(long index, String value2) {
        this.handleImmutableArrayValue();
        this.addString(index, value2);
    }

    @Override
    public void add(long index, BString value2) {
        this.handleImmutableArrayValue();
        this.addBString(index, value2);
    }

    public void addRefValueForcefully(int index, Object value2) {
        switch (this.elementReferredType.getTag()) {
            case 6: {
                this.prepareForAddForcefully(index, this.booleanValues.length);
                this.booleanValues[index] = (Boolean)value2;
                return;
            }
            case 3: {
                this.prepareForAddForcefully(index, this.floatValues.length);
                this.floatValues[index] = (Double)value2;
                return;
            }
            case 2: {
                this.prepareForAddForcefully(index, this.byteValues.length);
                this.byteValues[index] = ((Number)value2).byteValue();
                return;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.prepareForAddForcefully(index, this.intValues.length);
                this.intValues[index] = (Long)value2;
                return;
            }
            case 5: 
            case 13: {
                this.prepareForAddForcefully(index, this.bStringValues.length);
                this.bStringValues[index] = (BString)value2;
                return;
            }
        }
        this.prepareForAddForcefully(index, this.refValues.length);
        this.refValues[index] = value2;
    }

    public void convertStringAndAddRefValue(long index, Object value2) {
        switch (this.elementReferredType.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_TYPE, this.elementType, PredefinedTypes.TYPE_STRING));
            }
            case 5: 
            case 13: {
                if (!TypeChecker.checkIsType(value2, this.elementType)) {
                    throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_TYPE, this.elementType, PredefinedTypes.TYPE_STRING));
                }
                this.prepareForAddWithoutTypeCheck(index, this.bStringValues.length);
                this.bStringValues[(int)index] = (BString)value2;
                return;
            }
        }
        Object val2 = ValueConverter.getConvertedStringValue((BString)value2, this.elementType);
        this.prepareForAddWithoutTypeCheck(index, this.refValues.length);
        this.refValues[(int)index] = val2;
    }

    public void addRefValue(long index, Object value2) {
        Type type = TypeChecker.getType(value2);
        switch (this.elementReferredType.getTag()) {
            case 6: {
                this.prepareForAdd(index, value2, this.booleanValues.length);
                this.booleanValues[(int)index] = (Boolean)value2;
                return;
            }
            case 3: {
                this.prepareForAdd(index, value2, this.floatValues.length);
                this.floatValues[(int)index] = (Double)value2;
                return;
            }
            case 2: {
                this.prepareForAdd(index, value2, this.byteValues.length);
                this.byteValues[(int)index] = ((Number)value2).byteValue();
                return;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.prepareForAdd(index, value2, this.intValues.length);
                this.intValues[(int)index] = (Long)value2;
                return;
            }
            case 5: 
            case 13: {
                this.prepareForAdd(index, value2, this.bStringValues.length);
                this.bStringValues[(int)index] = (BString)value2;
                return;
            }
        }
        this.prepareForAdd(index, value2, this.refValues.length);
        this.refValues[(int)index] = value2;
    }

    public void setRefValueForcefully(int index, Object refValue) {
        this.refValues[index] = refValue;
    }

    public void setArrayRefTypeForcefully(ArrayType type, int size) {
        this.arrayType = type;
        this.type = this.arrayType;
        this.size = size;
        this.elementType = type.getElementType();
        this.elementReferredType = TypeUtils.getImpliedType(this.elementType);
    }

    public void addInt(long index, long value2) {
        Type sourceType = TypeChecker.getType(value2);
        if (this.intValues != null) {
            if (sourceType == this.elementType) {
                this.prepareForAddWithoutTypeCheck(index, this.intValues.length);
            } else {
                this.prepareForAdd(index, value2, this.intValues.length);
            }
            this.intValues[(int)index] = value2;
            return;
        }
        if (sourceType == this.elementType) {
            this.prepareForAddWithoutTypeCheck(index, this.byteValues.length);
        } else {
            this.prepareForAdd(index, value2, this.byteValues.length);
        }
        this.byteValues[(int)index] = (byte)Long.valueOf(value2).intValue();
    }

    private void addBoolean(long index, boolean value2) {
        this.prepareForAddWithoutTypeCheck(index, this.booleanValues.length);
        this.booleanValues[(int)index] = value2;
    }

    private void addByte(long index, byte value2) {
        this.prepareForAddWithoutTypeCheck(index, this.byteValues.length);
        this.byteValues[(int)index] = value2;
    }

    private void addFloat(long index, double value2) {
        this.prepareForAddWithoutTypeCheck(index, this.floatValues.length);
        this.floatValues[(int)index] = value2;
    }

    @Deprecated
    private void addString(long index, String value2) {
        this.addBString(index, io.ballerina.runtime.api.utils.StringUtils.fromString(value2));
    }

    private void addBString(long index, BString value2) {
        Type sourceType = TypeChecker.getType(value2);
        if (sourceType == this.elementType) {
            this.prepareForAddWithoutTypeCheck(index, this.bStringValues.length);
        } else {
            this.prepareForAdd(index, value2, this.bStringValues.length);
        }
        this.bStringValues[(int)index] = value2;
    }

    @Override
    public void append(Object value2) {
        this.add((long)this.size, value2);
    }

    @Override
    public Object pop(long index) {
        return this.shift(index);
    }

    @Override
    public Object remove(long index) {
        return this.shift(index);
    }

    @Override
    public Object shift(long index) {
        this.handleImmutableArrayValue();
        Object val2 = this.get(index);
        this.shiftArray((int)index, this.getArrayFromType(this.elementReferredType.getTag()));
        return val2;
    }

    @Override
    public Object shift() {
        return this.shift(0L);
    }

    @Override
    public void unshift(Object[] values) {
        this.unshift(0L, values);
    }

    @Override
    public String stringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        switch (this.elementReferredType.getTag()) {
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(this.intValues[i]));
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Boolean.toString(this.booleanValues[i]));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(Byte.toUnsignedLong(this.byteValues[i])));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Double.toString(this.floatValues[i]));
                }
                break;
            }
            case 5: 
            case 13: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(((BValue)((Object)this.bStringValues[i])).informalStringValue(parent));
                }
                break;
            }
            default: {
                this.getRefValuesString(parent, sj);
            }
        }
        return "[" + String.valueOf(sj) + "]";
    }

    private void getRefValuesString(BLink parent, StringJoiner sj) {
        block3: for (int i = 0; i < this.size; ++i) {
            if (this.refValues[i] == null) {
                sj.add("null");
                continue;
            }
            Type type = TypeChecker.getType(this.refValues[i]);
            switch (type.getTag()) {
                case 5: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 38: 
                case 40: {
                    sj.add(((BValue)this.refValues[i]).informalStringValue(new CycleUtils.Node(this, parent)));
                    continue block3;
                }
                default: {
                    sj.add(StringUtils.getStringVal(this.refValues[i], new CycleUtils.Node(this, parent)));
                }
            }
        }
    }

    @Override
    public String expressionStringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        switch (this.elementReferredType.getTag()) {
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringVal(this.intValues[i], new CycleUtils.Node(this, parent)));
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringVal(this.booleanValues[i], new CycleUtils.Node(this, parent)));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(Byte.toUnsignedLong(this.byteValues[i])));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringVal(this.floatValues[i], new CycleUtils.Node(this, parent)));
                }
                break;
            }
            case 5: 
            case 13: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringVal(this.bStringValues[i], new CycleUtils.Node(this, parent)));
                }
                break;
            }
            default: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringVal(this.refValues[i], new CycleUtils.Node(this, parent)));
                }
            }
        }
        return "[" + String.valueOf(sj) + "]";
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        ArrayValueImpl valueArray;
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        switch (this.elementReferredType.getTag()) {
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.intValues, this.size), this.arrayType.isReadOnly());
                break;
            }
            case 6: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.booleanValues, this.size), this.arrayType.isReadOnly());
                break;
            }
            case 2: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.byteValues, this.size), this.arrayType.isReadOnly());
                break;
            }
            case 3: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.floatValues, this.size), this.arrayType.isReadOnly());
                break;
            }
            case 5: 
            case 13: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.bStringValues, this.size), this.arrayType.isReadOnly());
                break;
            }
            default: {
                Object[] values = new Object[this.size];
                valueArray = new ArrayValueImpl(values, this.arrayType);
                IntStream.range(0, this.size).forEach(i -> {
                    Object value2 = this.refValues[i];
                    if (value2 instanceof BRefValue) {
                        BRefValue refValue = (BRefValue)value2;
                        values[i] = refValue.copy(refs);
                    } else {
                        values[i] = value2;
                    }
                });
            }
        }
        refs.put(this, valueArray);
        return valueArray;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        ArrayValue copy = (ArrayValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public ArrayValueImpl slice(long startIndex, long endIndex) {
        ArrayValueImpl slicedArray;
        int slicedSize = (int)(endIndex - startIndex);
        switch (this.elementReferredType.getTag()) {
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                slicedArray = new ArrayValueImpl(new long[slicedSize], false);
                System.arraycopy(this.intValues, (int)startIndex, slicedArray.intValues, 0, slicedSize);
                break;
            }
            case 6: {
                slicedArray = new ArrayValueImpl(new boolean[slicedSize], false);
                System.arraycopy(this.booleanValues, (int)startIndex, slicedArray.booleanValues, 0, slicedSize);
                break;
            }
            case 2: {
                slicedArray = new ArrayValueImpl(new byte[slicedSize], false);
                System.arraycopy(this.byteValues, (int)startIndex, slicedArray.byteValues, 0, slicedSize);
                break;
            }
            case 3: {
                slicedArray = new ArrayValueImpl(new double[slicedSize], false);
                System.arraycopy(this.floatValues, (int)startIndex, slicedArray.floatValues, 0, slicedSize);
                break;
            }
            case 5: 
            case 13: {
                slicedArray = new ArrayValueImpl(new BString[slicedSize], false);
                System.arraycopy(this.bStringValues, (int)startIndex, slicedArray.bStringValues, 0, slicedSize);
                break;
            }
            default: {
                slicedArray = new ArrayValueImpl(new Object[slicedSize], new BArrayType(this.elementType));
                System.arraycopy(this.refValues, (int)startIndex, slicedArray.refValues, 0, slicedSize);
            }
        }
        return slicedArray;
    }

    @Override
    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public Object[] getValues() {
        return this.refValues;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.byteValues, 0, bytes, 0, this.size);
        return bytes;
    }

    @Override
    public String[] getStringArray() {
        String[] arr = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            arr[i] = this.bStringValues[i].getValue();
        }
        return arr;
    }

    @Override
    public long[] getIntArray() {
        return Arrays.copyOf(this.intValues, this.size);
    }

    @Override
    public boolean[] getBooleanArray() {
        return Arrays.copyOf(this.booleanValues, this.size);
    }

    @Override
    public byte[] getByteArray() {
        return Arrays.copyOf(this.byteValues, this.size);
    }

    @Override
    public double[] getFloatArray() {
        return Arrays.copyOf(this.floatValues, this.size);
    }

    @Override
    public void serialize(OutputStream outputStream) {
        if (this.elementReferredType.getTag() == 2) {
            try {
                for (int i = 0; i < this.size; ++i) {
                    outputStream.write(this.byteValues[i]);
                }
            }
            catch (IOException e) {
                throw ErrorCreator.createError(io.ballerina.runtime.api.utils.StringUtils.fromString("error occurred while writing the binary content to the output stream"), e);
            }
        }
        try {
            outputStream.write(this.toString().getBytes(Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw ErrorCreator.createError(io.ballerina.runtime.api.utils.StringUtils.fromString("error occurred while serializing data"), e);
        }
    }

    @Override
    public void freezeDirect() {
        if (this.arrayType.isReadOnly()) {
            return;
        }
        this.type = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.type);
        this.arrayType = (ArrayType)TypeUtils.getImpliedType(this.type);
        if (this.elementType == null || this.elementReferredType.getTag() > 6) {
            for (int i = 0; i < this.size; ++i) {
                Object value2 = this.getRefValue(i);
                if (!(value2 instanceof BRefValue)) continue;
                BRefValue refValue = (BRefValue)value2;
                refValue.freezeDirect();
            }
        }
        this.typedesc = null;
    }

    @Override
    public IteratorValue<Object> getIterator() {
        return new AbstractArrayValue.ArrayIterator(this);
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    protected void resizeInternalArray(int newLength) {
        switch (this.elementReferredType.getTag()) {
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.intValues = Arrays.copyOf(this.intValues, newLength);
                break;
            }
            case 6: {
                this.booleanValues = Arrays.copyOf(this.booleanValues, newLength);
                break;
            }
            case 2: {
                this.byteValues = Arrays.copyOf(this.byteValues, newLength);
                break;
            }
            case 3: {
                this.floatValues = Arrays.copyOf(this.floatValues, newLength);
                break;
            }
            case 5: 
            case 13: {
                this.bStringValues = Arrays.copyOf(this.bStringValues, newLength);
                break;
            }
            default: {
                this.refValues = Arrays.copyOf(this.refValues, newLength);
            }
        }
    }

    @Override
    protected void fillValues(int index) {
        if (index <= this.size) {
            return;
        }
        switch (this.elementReferredType.getTag()) {
            case 5: {
                Arrays.fill(this.bStringValues, this.size, index, RuntimeConstants.STRING_EMPTY_VALUE);
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
        }
        if (this.arrayType.hasFillerValue()) {
            this.extractComplexFillerValues(index);
        }
    }

    private void extractComplexFillerValues(int index) {
        for (int i = this.size; i < index; ++i) {
            this.refValues[i] = this.getElementZeroValue();
        }
    }

    private Object getElementZeroValue() {
        return this.elementTypedescValue == null ? this.elementType.getZeroValue() : this.elementTypedescValue.getDescribingType().getZeroValue();
    }

    @Override
    protected void rangeCheckForGet(long index, int size) {
        this.rangeCheck(index, size);
        if (index >= (long)size) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), ErrorCodes.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    @Override
    protected void rangeCheck(long index, int size) {
        if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), ErrorCodes.INDEX_NUMBER_TOO_LARGE, index);
        }
        if ((int)index < 0 || index >= (long)this.maxSize) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), ErrorCodes.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    @Override
    protected void fillerValueCheck(int index, int size, int expectedLength) {
        if (this.arrayType.hasFillerValue()) {
            return;
        }
        if (index > size) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, ErrorCodes.ILLEGAL_ARRAY_INSERTION, size, expectedLength);
        }
    }

    @Override
    protected void ensureCapacity(int requestedCapacity, int currentArraySize) {
        if (requestedCapacity <= currentArraySize) {
            return;
        }
        if (this.arrayType.getState() != ArrayType.ArrayState.OPEN) {
            return;
        }
        int newArraySize = currentArraySize + (currentArraySize >> 1);
        newArraySize = Math.max(newArraySize, requestedCapacity);
        newArraySize = Math.min(newArraySize, this.maxSize);
        this.resizeInternalArray(newArraySize);
    }

    @Override
    protected void checkFixedLength(long length) {
        if (this.arrayType.getState() == ArrayType.ArrayState.CLOSED) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), ErrorCodes.ILLEGAL_ARRAY_SIZE, this.size, length);
        }
    }

    @Override
    protected void unshift(long index, Object[] vals) {
        this.handleImmutableArrayValue();
        this.unshiftArray(index, vals.length, this.getCurrentArrayLength());
        int startIndex = (int)index;
        int endIndex = startIndex + vals.length;
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.add((long)i, vals[j]);
            ++i;
            ++j;
        }
    }

    private void prepareForAdd(long index, Object value2, int currentArraySize) {
        if (!TypeChecker.checkIsType(value2, this.elementType)) {
            throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_TYPE, this.elementType, TypeChecker.getType(value2)));
        }
        this.prepareForAddWithoutTypeCheck(index, currentArraySize);
    }

    private void prepareForAddWithoutTypeCheck(long index, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.fillerValueCheck(intIndex, this.size, intIndex + 1);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.fillValues(intIndex);
        this.resetSize(intIndex);
    }

    private void fillRead(long index, int currentArraySize) {
        if (!this.arrayType.hasFillerValue()) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, ErrorCodes.ILLEGAL_ARRAY_INSERTION, this.size, index + 1L);
        }
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        switch (this.elementReferredType.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 5: {
                Arrays.fill(this.bStringValues, this.size, intIndex, RuntimeConstants.STRING_EMPTY_VALUE);
                break;
            }
            default: {
                int i = this.size;
                while ((long)i <= index) {
                    this.refValues[i] = this.elementType.getZeroValue();
                    ++i;
                }
                break block0;
            }
        }
        this.resetSize(intIndex);
    }

    private void setArrayType(Type elementType, boolean readonly) {
        this.arrayType = new BArrayType(elementType, -1, readonly, 6);
        this.type = this.arrayType;
        this.elementType = elementType;
        this.elementReferredType = TypeUtils.getImpliedType(this.elementType);
    }

    private void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    private void shiftArray(int index, Object arr) {
        int nElemsToBeMoved = this.size - 1 - index;
        if (nElemsToBeMoved >= 0) {
            System.arraycopy(arr, index + 1, arr, index, nElemsToBeMoved);
        }
        --this.size;
    }

    private void unshiftArray(long index, int unshiftByN, int arrLength) {
        int lastIndex = this.size() + unshiftByN - 1;
        this.prepareForConsecutiveMultiAdd(lastIndex, arrLength);
        if (index > (long)lastIndex) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), ErrorCodes.INDEX_NUMBER_TOO_LARGE, index);
        }
        int i = (int)index;
        this.ensureCapacity(this.size + unshiftByN, this.size);
        Object arr = this.getArrayFromType(this.elementType.getTag());
        System.arraycopy(arr, i, arr, i + unshiftByN, this.size - i);
    }

    private Object getArrayFromType(int typeTag) {
        return switch (typeTag) {
            case 1, 7, 8, 9, 10, 11, 12 -> this.intValues;
            case 6 -> (Object[])this.booleanValues;
            case 2 -> this.byteValues;
            case 3 -> (Object[])this.floatValues;
            case 5, 13 -> (Object[])this.bStringValues;
            default -> (Object[])this.refValues;
        };
    }

    private int getCurrentArrayLength() {
        return switch (this.elementType.getTag()) {
            case 1, 7, 8, 9, 10, 11, 12 -> this.intValues.length;
            case 6 -> this.booleanValues.length;
            case 2 -> this.byteValues.length;
            case 3 -> this.floatValues.length;
            case 5, 13 -> this.bStringValues.length;
            default -> this.refValues.length;
        };
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.elementType);
        result = 31 * result + this.calculateHashCode(new ArrayList<Object>());
        result = 31 * result + Arrays.hashCode(this.intValues);
        result = 31 * result + Arrays.hashCode(this.booleanValues);
        result = 31 * result + Arrays.hashCode(this.byteValues);
        result = 31 * result + Arrays.hashCode(this.floatValues);
        result = 31 * result + Arrays.hashCode(this.bStringValues);
        return result;
    }

    private int calculateHashCode(List<Object> visited) {
        if (this.refValues == null) {
            return 0;
        }
        int result = 1;
        if (visited.contains(this.refValues)) {
            return 31 * result + System.identityHashCode(this.refValues);
        }
        visited.add(this.refValues);
        for (Object ref : this.refValues) {
            result = ref instanceof ArrayValueImpl ? 31 * result + this.calculateHashCode(visited) : 31 * result + (ref == null ? 0 : ref.hashCode());
        }
        return result;
    }

    @Override
    public void cacheShape(SemType semType) {
        this.shape = semType;
    }

    @Override
    public SemType shapeOf() {
        return this.shape;
    }
}

