/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.values.StringValue;
import java.util.Arrays;

public class NonBmpStringValue
extends StringValue {
    private final int[] surrogates;

    public NonBmpStringValue(String value2, int[] surrogatePairLocations) {
        super(value2, true);
        this.surrogates = surrogatePairLocations;
    }

    @Override
    public int getCodePoint(int index) {
        if (index < 0 || index >= this.value.length() - this.surrogates.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        int offset = index;
        for (int surrogate : this.surrogates) {
            if (surrogate < index) {
                ++offset;
                continue;
            }
            if (surrogate > index) break;
            return Character.toCodePoint(this.value.charAt(offset), this.value.charAt(offset + 1));
        }
        return this.value.charAt(offset);
    }

    @Override
    public int length() {
        return this.value.length() - this.surrogates.length;
    }

    @Override
    public BString concat(BString str) {
        StringValue stringValue = (StringValue)str;
        if (stringValue.isNonBmp) {
            NonBmpStringValue other = (NonBmpStringValue)str;
            int[] both = Arrays.copyOf(this.surrogates, this.surrogates.length + other.surrogates.length);
            int length = this.length();
            for (int i = 0; i < other.surrogates.length; ++i) {
                both[i + this.surrogates.length] = other.surrogates[i] + length;
            }
            return new NonBmpStringValue(this.value + other.value, both);
        }
        return new NonBmpStringValue(this.value + str.getValue(), this.surrogates);
    }

    public int[] getSurrogates() {
        return (int[])this.surrogates.clone();
    }

    @Override
    public Long indexOf(BString str, int fromIndex) {
        int offset = this.getOffset(fromIndex);
        long index = this.value.indexOf(str.getValue(), offset);
        if (index < 0L) {
            return null;
        }
        int i = 0;
        while ((long)i < index) {
            char c = this.value.charAt(i);
            if (Character.isHighSurrogate(c)) {
                --index;
            }
            ++i;
        }
        return index;
    }

    @Override
    public Long lastIndexOf(BString str, int fromIndex) {
        int offset = this.getOffset(fromIndex);
        long index = this.value.lastIndexOf(str.getValue(), offset);
        if (index < 0L) {
            return null;
        }
        int i = 0;
        while ((long)i < index) {
            char c = this.value.charAt(i);
            if (Character.isHighSurrogate(c)) {
                --index;
            }
            ++i;
        }
        return index;
    }

    @Override
    public BString substring(int beginIndex, int endIndex) {
        int beginOffset = this.getOffset(beginIndex);
        int endOffset = this.getOffset(endIndex);
        return StringUtils.fromString(this.value.substring(beginOffset, endOffset));
    }

    private int getOffset(int fromIndex) {
        int offset = fromIndex;
        for (int surrogate : this.surrogates) {
            if (surrogate >= fromIndex) break;
            ++offset;
        }
        return offset;
    }
}

