/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.ValuePair;
import io.ballerina.runtime.internal.values.XmlNonElementItem;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.axiom.om.OMNode;

public class XmlPi
extends XmlNonElementItem {
    private final String data;
    private final String target;

    public XmlPi(String data, String target) {
        this.data = data;
        this.target = target;
        this.type = PredefinedTypes.TYPE_PROCESSING_INSTRUCTION;
    }

    public XmlPi(String data, String target, boolean readonly) {
        this.data = data;
        this.target = target;
        this.type = readonly ? PredefinedTypes.TYPE_READONLY_PROCESSING_INSTRUCTION : PredefinedTypes.TYPE_PROCESSING_INSTRUCTION;
    }

    @Override
    public IteratorValue<XmlPi> getIterator() {
        final XmlPi that = this;
        return new IteratorValue<XmlPi>(this){
            boolean read = false;

            @Override
            public boolean hasNext() {
                return !this.read;
            }

            @Override
            public XmlPi next() {
                if (!this.read) {
                    this.read = true;
                    return that;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getItemType() {
        return this.getNodeType().value();
    }

    @Override
    public String getTextValue() {
        return "";
    }

    public String getData() {
        return this.data;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.PI;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        return new XmlPi(this.data, this.target);
    }

    @Override
    public OMNode value() {
        return this.factory.createOMProcessingInstruction(null, this.target, this.data);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public boolean equals(Object o, Set<ValuePair> visitedValues) {
        if (!(o instanceof XmlPi)) {
            return false;
        }
        XmlPi rhsXMLPi = (XmlPi)o;
        return this.getData().equals(rhsXMLPi.getData()) && this.getTarget().equals(rhsXMLPi.getTarget());
    }

    public int hashCode() {
        return Objects.hash(this.data, this.target);
    }

    @Override
    public String stringValue(BLink parent) {
        return "<?" + this.target + " " + this.data + "?>";
    }
}

