/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.rt;

import java.util.HashMap;

public final class InvokerMemory {
    private static final String QUOTE = "'";
    private static final HashMap<String, HashMap<String, Object>> memory = new HashMap();

    private InvokerMemory() {
    }

    public static Object recall(String contextId, String name) {
        if (memory.containsKey(contextId)) {
            return memory.get(contextId).getOrDefault(InvokerMemory.quoted(name.trim()), null);
        }
        return null;
    }

    public static void memorize(String contextId, String name, Object value2) {
        HashMap<String, Object> contextMem = memory.getOrDefault(contextId, new HashMap());
        contextMem.put(InvokerMemory.quoted(name.trim()), value2);
        memory.put(contextId, contextMem);
    }

    public static void forgetAll(String contextId) {
        if (memory.containsKey(contextId)) {
            memory.get(contextId).clear();
        }
    }

    private static String quoted(String identifier) {
        if (String.valueOf(identifier).startsWith(QUOTE)) {
            return identifier;
        }
        return QUOTE + identifier;
    }
}

