/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlTransformer;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.validator.TomlValidator;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Toml {
    private final TomlTableNode rootNode;

    public Toml(TomlTableNode tomlTableNode) {
        this.rootNode = tomlTableNode;
    }

    public static Toml read(Path path) throws IOException {
        Path fileNamePath = path.getFileName();
        if (fileNamePath == null) {
            return null;
        }
        return Toml.read(Files.readString(path), fileNamePath.toString());
    }

    public static Toml read(Path path, Schema schema) throws IOException {
        Path fileNamePath = path.getFileName();
        if (fileNamePath == null) {
            return null;
        }
        return Toml.read(Files.readString(path), fileNamePath.toString(), schema);
    }

    public static Toml read(InputStream inputStream) throws IOException {
        return Toml.read(new String(inputStream.readAllBytes(), StandardCharsets.UTF_8), null);
    }

    public static Toml read(InputStream inputStream, Schema schema) throws IOException {
        return Toml.read(new String(inputStream.readAllBytes(), StandardCharsets.UTF_8), null, schema);
    }

    public static Toml read(String content, String fileName) {
        TextDocument textDocument = TextDocuments.from(content);
        SyntaxTree syntaxTree = SyntaxTree.from(textDocument, fileName);
        TomlTransformer nodeTransformer = new TomlTransformer();
        TomlTableNode transformedTable = (TomlTableNode)nodeTransformer.transform((DocumentNode)syntaxTree.rootNode());
        return new Toml(transformedTable);
    }

    public static Toml read(String content, String fileName, Schema schema) {
        TextDocument textDocument = TextDocuments.from(content);
        SyntaxTree syntaxTree = SyntaxTree.from(textDocument, fileName);
        TomlTransformer nodeTransformer = new TomlTransformer();
        TomlTableNode transformedTable = (TomlTableNode)nodeTransformer.transform((DocumentNode)syntaxTree.rootNode());
        Toml toml = new Toml(transformedTable);
        TomlValidator tomlValidator = new TomlValidator(schema);
        tomlValidator.validate(toml);
        return toml;
    }

    public <T extends TomlValueNode> Optional<T> get(String dottedKey) {
        String[] parentDottedKeys = this.splitDottedkeys(dottedKey);
        String lastKey = parentDottedKeys[parentDottedKeys.length - 1];
        Optional<TomlTableNode> parentNode = this.getParentNode(parentDottedKeys = Arrays.copyOf(parentDottedKeys, parentDottedKeys.length - 1));
        if (parentNode.isEmpty()) {
            return Optional.empty();
        }
        TomlTableNode parentTableNode = parentNode.get();
        TopLevelNode valueEntry = parentTableNode.entries().get(lastKey);
        if (valueEntry == null || valueEntry.kind() != TomlType.KEY_VALUE) {
            return Optional.empty();
        }
        TomlKeyValueNode keyValueNode = (TomlKeyValueNode)valueEntry;
        if (keyValueNode.value() == null) {
            return Optional.empty();
        }
        TomlValueNode value2 = keyValueNode.value();
        return Optional.ofNullable(value2);
    }

    private String[] splitDottedkeys(String dottedKey) {
        return dottedKey.split("\\.(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
    }

    private Optional<TomlTableNode> getParentNode(String[] parentDottedKeys) {
        TomlTableNode parentTableNode = this.rootNode;
        for (String key : parentDottedKeys) {
            TopLevelNode topLevelNode = parentTableNode.entries().get(key);
            if (topLevelNode == null || topLevelNode.kind() != TomlType.TABLE) {
                return Optional.empty();
            }
            parentTableNode = (TomlTableNode)topLevelNode;
        }
        if (parentTableNode == null || parentTableNode.kind() != TomlType.TABLE) {
            return Optional.empty();
        }
        return Optional.of(parentTableNode);
    }

    public Optional<Toml> getTable(String dottedKey) {
        String[] parentDottedKeys = this.splitDottedkeys(dottedKey);
        Optional<TomlTableNode> parentNode = this.getParentNode(parentDottedKeys);
        if (parentNode.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Toml(parentNode.get()));
    }

    public List<Toml> getTables(String dottedKey) {
        String[] parentDottedKeys = this.splitDottedkeys(dottedKey);
        String lastKey = parentDottedKeys[parentDottedKeys.length - 1];
        Optional<TomlTableNode> parentNode = this.getParentNode(parentDottedKeys = Arrays.copyOf(parentDottedKeys, parentDottedKeys.length - 1));
        if (parentNode.isEmpty()) {
            return Collections.emptyList();
        }
        TomlTableNode parentTableNode = parentNode.get();
        TopLevelNode valueEntry = parentTableNode.entries().get(lastKey);
        if (valueEntry == null || valueEntry.kind() != TomlType.TABLE_ARRAY) {
            return Collections.emptyList();
        }
        TomlTableArrayNode tomlTableArrayNode = (TomlTableArrayNode)valueEntry;
        List<TomlTableNode> childs = tomlTableArrayNode.children();
        ArrayList<Toml> tomlList = new ArrayList<Toml>();
        for (TomlTableNode child : childs) {
            tomlList.add(new Toml(child));
        }
        return tomlList;
    }

    public List<Diagnostic> diagnostics() {
        return new ArrayList<Diagnostic>(this.rootNode.diagnostics());
    }

    public TomlTableNode rootNode() {
        return this.rootNode;
    }

    public Map<String, Object> toMap() {
        return this.rootNode.toNativeObject();
    }

    public <T> T to(Class<T> targetClass) {
        Gson gson = new Gson();
        JsonElement json = gson.toJsonTree(this.toMap());
        if (targetClass == JsonElement.class) {
            return targetClass.cast(json);
        }
        return gson.fromJson(json, targetClass);
    }
}

