/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.diagnostics;

import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.List;
import java.util.Objects;

public class TomlDiagnostic
extends Diagnostic {
    private final TomlNodeLocation location;
    private final DiagnosticInfo diagnosticInfo;
    private final String message;

    public TomlDiagnostic(TomlNodeLocation location, DiagnosticInfo diagnosticInfo, String message) {
        this.location = location;
        this.diagnosticInfo = diagnosticInfo;
        this.message = message;
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public DiagnosticInfo diagnosticInfo() {
        return this.diagnosticInfo;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public List<DiagnosticProperty<?>> properties() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TomlDiagnostic that = (TomlDiagnostic)o;
        return Objects.equals(this.location, that.location) && Objects.equals(this.diagnosticInfo, that.diagnosticInfo) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.diagnosticInfo, this.message);
    }

    @Override
    public String toString() {
        String filePath = this.location().lineRange().fileName();
        LineRange lineRange = this.location().lineRange();
        LineRange oneBasedLineRange = LineRange.from(filePath, LinePosition.from(lineRange.startLine().line() + 1, lineRange.startLine().offset() + 1), LinePosition.from(lineRange.endLine().line() + 1, lineRange.endLine().offset() + 1));
        return this.diagnosticInfo().severity().toString() + " [" + filePath + ":" + String.valueOf(oneBasedLineRange) + "] " + this.message();
    }
}

