/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeList;
import io.ballerina.toml.internal.syntax.NodeListUtils;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class NodeList<T extends Node>
implements Iterable<T> {
    protected final STNodeList internalListNode;
    protected final NonTerminalNode nonTerminalNode;
    protected final int size;

    NodeList(NonTerminalNode nonTerminalNode) {
        this(nonTerminalNode, nonTerminalNode.bucketCount());
    }

    protected NodeList(NonTerminalNode nonTerminalNode, int size) {
        if (!NodeListUtils.isSTNodeList(nonTerminalNode.internalNode())) {
            throw new IllegalArgumentException("An STNodeList instance is expected");
        }
        this.internalListNode = (STNodeList)nonTerminalNode.internalNode();
        this.nonTerminalNode = nonTerminalNode;
        this.size = size;
    }

    public T get(int index) {
        NodeListUtils.rangeCheck(index, this.size);
        return this.nonTerminalNode.childInBucket(index);
    }

    public NodeList<T> add(T node) {
        Objects.requireNonNull(node, "node should not be null");
        return new NodeList<T>((NonTerminalNode)this.internalListNode.add(((Node)node).internalNode()).createUnlinkedFacade());
    }

    public NodeList<T> add(int index, T node) {
        Objects.requireNonNull(node, "node should not be null");
        NodeListUtils.rangeCheckForAdd(index, this.size);
        return new NodeList<T>((NonTerminalNode)this.internalListNode.add(index, ((Node)node).internalNode()).createUnlinkedFacade());
    }

    public NodeList<T> addAll(Collection<T> c) {
        if (c.isEmpty()) {
            return this;
        }
        List<STNode> stNodesToBeAdded = c.stream().map(node -> Objects.requireNonNull(node, "node should not be null")).map(Node::internalNode).toList();
        return new NodeList<T>((NonTerminalNode)this.internalListNode.addAll(stNodesToBeAdded).createUnlinkedFacade());
    }

    public NodeList<T> set(int index, T node) {
        Objects.requireNonNull(node, "node should not be null");
        NodeListUtils.rangeCheck(index, this.size);
        if (this.nonTerminalNode.checkForReferenceEquality(index, (Node)node)) {
            return this;
        }
        return new NodeList<T>((NonTerminalNode)this.internalListNode.set(index, ((Node)node).internalNode()).createUnlinkedFacade());
    }

    public NodeList<T> remove(int index) {
        NodeListUtils.rangeCheck(index, this.size);
        return new NodeList<T>((NonTerminalNode)this.internalListNode.remove(index).createUnlinkedFacade());
    }

    public NodeList<T> remove(T node) {
        Objects.requireNonNull(node, "node should not be null");
        for (int bucket = 0; bucket < this.nonTerminalNode.bucketCount(); ++bucket) {
            if (!this.nonTerminalNode.checkForReferenceEquality(bucket, (Node)node)) continue;
            return this.remove((T)bucket);
        }
        return this;
    }

    public NodeList<T> removeAll(Collection<T> c) {
        if (c.isEmpty()) {
            return this;
        }
        c.forEach(node -> Objects.requireNonNull(node, "node should not be null"));
        ArrayList<STNode> toBeDeletedList = new ArrayList<STNode>();
        for (int bucket = 0; bucket < this.nonTerminalNode.bucketCount(); ++bucket) {
            Node childNode = this.nonTerminalNode.childBuckets[bucket];
            if (!c.contains(childNode)) continue;
            toBeDeletedList.add(childNode.internalNode());
        }
        return new NodeList<T>((NonTerminalNode)this.internalListNode.removeAll(toBeDeletedList).createUnlinkedFacade());
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new NodeListIterator();
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    NonTerminalNode underlyingListNode() {
        return this.nonTerminalNode;
    }

    protected class NodeListIterator
    implements Iterator<T> {
        private int currentIndex = 0;

        protected NodeListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < NodeList.this.size;
        }

        @Override
        public T next() {
            return NodeList.this.get(this.currentIndex++);
        }
    }
}

