/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator;

import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.validator.SampleNodeGenerator;
import io.ballerina.toml.validator.schema.AbstractSchema;
import io.ballerina.toml.validator.schema.ArraySchema;
import io.ballerina.toml.validator.schema.BooleanSchema;
import io.ballerina.toml.validator.schema.NumericSchema;
import io.ballerina.toml.validator.schema.PrimitiveValueSchema;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.toml.validator.schema.SchemaVisitor;
import io.ballerina.toml.validator.schema.StringSchema;
import io.ballerina.toml.validator.schema.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class BoilerplateGenerator
extends SchemaVisitor {
    private String parentTableKey;
    private final Map<String, DocumentMemberDeclarationNode> nodes = new LinkedHashMap<String, DocumentMemberDeclarationNode>();
    private String key;

    public BoilerplateGenerator(Schema rootSchema) {
        Map<String, AbstractSchema> children = rootSchema.properties();
        for (Map.Entry<String, AbstractSchema> entry : children.entrySet()) {
            String key = entry.getKey();
            AbstractSchema value2 = entry.getValue();
            if (value2.type() == Type.OBJECT || value2.type() == Type.ARRAY) {
                this.parentTableKey = key;
            } else {
                this.key = key;
            }
            value2.accept(this);
        }
    }

    @Override
    public void visit(Schema objectSchema) {
        Map<String, AbstractSchema> children = objectSchema.properties();
        if (!BoilerplateGenerator.isDefaultValuesExist(children)) {
            return;
        }
        if (!BoilerplateGenerator.isTableHeaderSkippable(children)) {
            this.nodes.put(this.parentTableKey, SampleNodeGenerator.createTable(this.parentTableKey, objectSchema.description().orElse(null)));
        }
        String parentKey = this.parentTableKey;
        for (Map.Entry<String, AbstractSchema> entry : children.entrySet()) {
            String key = entry.getKey();
            AbstractSchema value2 = entry.getValue();
            if (value2.type() == Type.OBJECT || value2.type() == Type.ARRAY) {
                this.parentTableKey = this.parentTableKey + "." + key;
            } else {
                this.key = key;
            }
            value2.accept(this);
            this.parentTableKey = parentKey;
        }
    }

    @Override
    public void visit(ArraySchema arraySchema) {
        AbstractSchema items = arraySchema.items();
        if (items.type() == Type.OBJECT) {
            this.nodes.put(this.parentTableKey, SampleNodeGenerator.createTableArray(this.parentTableKey, arraySchema.description().orElse(null)));
            Map<String, AbstractSchema> children = ((Schema)items).properties();
            for (Map.Entry<String, AbstractSchema> entry : children.entrySet()) {
                String key = entry.getKey();
                AbstractSchema value2 = entry.getValue();
                if (value2.type() == Type.OBJECT) {
                    this.parentTableKey = this.parentTableKey + "." + key;
                    continue;
                }
                this.key = key;
                value2.accept(this);
            }
        } else {
            items.accept(this);
        }
    }

    @Override
    public void visit(BooleanSchema booleanSchema) {
        Optional defaultValue = booleanSchema.defaultValue();
        if (defaultValue.isEmpty()) {
            return;
        }
        Boolean val2 = (Boolean)defaultValue.get();
        String key = this.parentTableKey + "." + this.key;
        this.nodes.put(key, SampleNodeGenerator.createBooleanKV(this.key, val2, booleanSchema.description().orElse(null)));
    }

    @Override
    public void visit(NumericSchema numericSchema) {
        Optional defaultValue = numericSchema.defaultValue();
        if (defaultValue.isEmpty()) {
            return;
        }
        Double val2 = (Double)defaultValue.get();
        String key = this.parentTableKey + "." + this.key;
        this.nodes.put(key, SampleNodeGenerator.createNumericKV(this.key, BoilerplateGenerator.numericPrettyPrint(val2), numericSchema.description().orElse(null)));
    }

    @Override
    public void visit(StringSchema stringSchema) {
        Optional defaultValue = stringSchema.defaultValue();
        if (defaultValue.isEmpty()) {
            return;
        }
        String val2 = (String)defaultValue.get();
        String key = this.parentTableKey + "." + this.key;
        this.nodes.put(key, SampleNodeGenerator.createStringKV(this.key, val2, stringSchema.description().orElse(null)));
    }

    public Map<String, DocumentMemberDeclarationNode> getNodes() {
        return this.nodes;
    }

    private static String numericPrettyPrint(double d) {
        if (d == (double)((long)d)) {
            return String.format("%d", (long)d);
        }
        return String.format("%s", d);
    }

    private static boolean isTableHeaderSkippable(Map<String, AbstractSchema> children) {
        for (AbstractSchema value2 : children.values()) {
            if (value2.type() == Type.OBJECT || value2.type() == Type.ARRAY) continue;
            return false;
        }
        return true;
    }

    private static boolean isDefaultValuesExist(Map<String, AbstractSchema> children) {
        for (AbstractSchema value2 : children.values()) {
            Schema table2;
            ArraySchema arraySchema;
            AbstractSchema items;
            Schema table3;
            if (value2.type() != Type.OBJECT && value2.type() != Type.ARRAY && ((PrimitiveValueSchema)value2).defaultValue().isPresent()) {
                return true;
            }
            if (value2.type() == Type.OBJECT && BoilerplateGenerator.isDefaultValuesExist((table3 = (Schema)value2).properties())) {
                return true;
            }
            if (value2.type() != Type.ARRAY || (items = (arraySchema = (ArraySchema)value2).items()).type() != Type.OBJECT || !BoilerplateGenerator.isDefaultValuesExist((table2 = (Schema)items).properties())) continue;
            return true;
        }
        return false;
    }
}

