/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator.schema;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlDoubleValueNodeNode;
import io.ballerina.toml.semantic.ast.TomlLongValueNode;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.validator.ValidationUtil;
import io.ballerina.toml.validator.schema.CompositionSchema;
import io.ballerina.toml.validator.schema.PrimitiveValueSchema;
import io.ballerina.toml.validator.schema.SchemaVisitor;
import io.ballerina.toml.validator.schema.Type;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class NumericSchema
extends PrimitiveValueSchema<Double> {
    private final Double minimum;
    private final Double maximum;

    public NumericSchema(Type type, Map<String, String> message, Double minimum, Double maximum, Double defaultValue, CompositionSchema compositionSchemas, String description) {
        super(type, message, defaultValue, compositionSchemas, description);
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public Optional<Double> minimum() {
        return Optional.ofNullable(this.minimum);
    }

    public Optional<Double> maximum() {
        return Optional.ofNullable(this.maximum);
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T extends TomlNode> List<Diagnostic> validate(T givenValueNode, String key) {
        TomlDiagnostic diagnostic;
        Double value2;
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (givenValueNode.kind() == TomlType.INTEGER) {
            TomlLongValueNode tomlLongValueNode = (TomlLongValueNode)givenValueNode;
            value2 = (double)((Long)tomlLongValueNode.getValue());
        } else if (givenValueNode.kind() == TomlType.DOUBLE) {
            TomlDoubleValueNodeNode tomlDoubleValueNodeNode = (TomlDoubleValueNodeNode)givenValueNode;
            value2 = (Double)tomlDoubleValueNodeNode.getValue();
        } else {
            if (!givenValueNode.isMissingNode()) {
                TomlDiagnostic diagnostic2 = ValidationUtil.getTomlDiagnostic(givenValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, ValidationUtil.getTypeErrorMessage(this, givenValueNode.kind(), key));
                diagnostics.add(diagnostic2);
            }
            return diagnostics;
        }
        if (this.maximum().isPresent()) {
            Double max = this.maximum().get();
            if (value2 > max) {
                diagnostic = ValidationUtil.getTomlDiagnostic(givenValueNode.location(), "TVE0005", "error.maximum.value.exceed", DiagnosticSeverity.ERROR, this.getMaxValueExceedErrorMessage(max, key));
                diagnostics.add(diagnostic);
            }
        }
        if (this.minimum().isPresent()) {
            Double min = this.minimum().get();
            if (value2 < min) {
                diagnostic = ValidationUtil.getTomlDiagnostic(givenValueNode.location(), "TVE0004", "error.minimum.value.deceed", DiagnosticSeverity.ERROR, this.getMinValueDeceedErrorMessage(min, key));
                diagnostics.add(diagnostic);
            }
        }
        diagnostics.addAll(super.validate(givenValueNode, key));
        return diagnostics;
    }

    private String getMaxValueExceedErrorMessage(Double max, String key) {
        Map<String, String> message = this.message();
        String maxCustomMessage = message.get("maximum");
        if (maxCustomMessage == null) {
            return String.format("value for key '%s' can't be higher than %f", key, max);
        }
        return maxCustomMessage;
    }

    private String getMinValueDeceedErrorMessage(Double min, String key) {
        Map<String, String> message = this.message();
        String minCustomMessage = message.get("minimum");
        if (minCustomMessage == null) {
            return String.format("value for key '%s' can't be lower than %f", key, min);
        }
        return minCustomMessage;
    }
}

