/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.Atom;
import io.ballerina.types.Bdd;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.typeops.BddCommonOps;
import java.util.ArrayList;
import java.util.List;

public class BddPath {
    Bdd bdd;
    List<Atom> pos;
    List<Atom> neg;

    private BddPath(BddPath bddPath) {
        this.bdd = bddPath.bdd;
        this.pos = new ArrayList<Atom>(bddPath.pos);
        this.neg = new ArrayList<Atom>(bddPath.neg);
    }

    public BddPath() {
        this.bdd = BddAllOrNothing.bddAll();
        this.pos = new ArrayList<Atom>();
        this.neg = new ArrayList<Atom>();
    }

    public static void bddPaths(Bdd b, List<BddPath> paths, BddPath accum) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            if (allOrNothing.isAll()) {
                paths.add(accum);
            }
        } else {
            BddPath left = BddPath.bddPathClone(accum);
            BddPath right = BddPath.bddPathClone(accum);
            BddNode bn = (BddNode)b;
            left.pos.add(bn.atom());
            left.bdd = BddCommonOps.bddIntersect(left.bdd, BddCommonOps.bddAtom(bn.atom()));
            BddPath.bddPaths(bn.left(), paths, left);
            BddPath.bddPaths(bn.middle(), paths, accum);
            right.neg.add(bn.atom());
            right.bdd = BddCommonOps.bddDiff(right.bdd, BddCommonOps.bddAtom(bn.atom()));
            BddPath.bddPaths(bn.right(), paths, right);
        }
    }

    private static BddPath bddPathClone(BddPath path) {
        return new BddPath(path);
    }

    public static BddPath from() {
        return new BddPath();
    }
}

