/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.Common;
import io.ballerina.types.EnumerableCharString;
import io.ballerina.types.EnumerableDecimal;
import io.ballerina.types.EnumerableFloat;
import io.ballerina.types.EnumerableString;
import io.ballerina.types.EnumerableType;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

public abstract class EnumerableSubtype {
    public static final int LT = -1;
    public static final int EQ = 0;
    public static final int GT = 1;

    public abstract boolean allowed();

    public abstract EnumerableType[] values();

    public static boolean enumerableSubtypeUnion(EnumerableSubtype t1, EnumerableSubtype t2, List<? extends EnumerableType> result) {
        boolean allowed;
        boolean b1 = t1.allowed();
        boolean b2 = t2.allowed();
        if (b1 && b2) {
            EnumerableSubtype.enumerableListUnion(t1.values(), t2.values(), result);
            allowed = true;
        } else if (!b1 && !b2) {
            EnumerableSubtype.enumerableListIntersect(t1.values(), t2.values(), result);
            allowed = false;
        } else if (b1 && !b2) {
            EnumerableSubtype.enumerableListDiff(t2.values(), t1.values(), result);
            allowed = false;
        } else {
            EnumerableSubtype.enumerableListDiff(t1.values(), t2.values(), result);
            allowed = false;
        }
        return allowed;
    }

    public static boolean enumerableSubtypeIntersect(EnumerableSubtype t1, EnumerableSubtype t2, List<? extends EnumerableType> result) {
        boolean allowed;
        boolean b1 = t1.allowed();
        boolean b2 = t2.allowed();
        if (b1 && b2) {
            EnumerableSubtype.enumerableListIntersect(t1.values(), t2.values(), result);
            allowed = true;
        } else if (!b1 && !b2) {
            EnumerableSubtype.enumerableListUnion(t1.values(), t2.values(), result);
            allowed = false;
        } else if (b1 && !b2) {
            EnumerableSubtype.enumerableListDiff(t1.values(), t2.values(), result);
            allowed = true;
        } else {
            EnumerableSubtype.enumerableListDiff(t2.values(), t1.values(), result);
            allowed = true;
        }
        return allowed;
    }

    public static void enumerableListUnion(EnumerableType[] v1, EnumerableType[] v2, List<? extends EnumerableType> resulte) {
        List<? extends EnumerableType> result = resulte;
        int i1 = 0;
        int i2 = 0;
        int len1 = v1.length;
        int len2 = v2.length;
        while (true) {
            if (i1 >= len1) {
                if (i2 >= len2) break;
                result.add(v2[i2]);
                ++i2;
                continue;
            }
            if (i2 >= len2) {
                result.add(v1[i1]);
                ++i1;
                continue;
            }
            EnumerableType s1 = v1[i1];
            EnumerableType s2 = v2[i2];
            switch (EnumerableSubtype.compareEnumerable(s1, s2)) {
                case 0: {
                    result.add(s1);
                    ++i1;
                    ++i2;
                    break;
                }
                case -1: {
                    result.add(s1);
                    ++i1;
                    break;
                }
                case 1: {
                    result.add(s2);
                    ++i2;
                }
            }
        }
    }

    public static void enumerableListIntersect(EnumerableType[] v1, EnumerableType[] v2, List<? extends EnumerableType> resulte) {
        List<? extends EnumerableType> result = resulte;
        int i1 = 0;
        int i2 = 0;
        int len1 = v1.length;
        int len2 = v2.length;
        while (i1 < len1 && i2 < len2) {
            EnumerableType s1 = v1[i1];
            EnumerableType s2 = v2[i2];
            switch (EnumerableSubtype.compareEnumerable(s1, s2)) {
                case 0: {
                    result.add(s1);
                    ++i1;
                    ++i2;
                    break;
                }
                case -1: {
                    ++i1;
                    break;
                }
                case 1: {
                    ++i2;
                }
            }
        }
    }

    public static void enumerableListDiff(EnumerableType[] v1, EnumerableType[] v2, List<? extends EnumerableType> resulte) {
        List<? extends EnumerableType> result = resulte;
        int i1 = 0;
        int i2 = 0;
        int len1 = v1.length;
        int len2 = v2.length;
        while (i1 < len1) {
            if (i2 >= len2) {
                result.add(v1[i1]);
                ++i1;
                continue;
            }
            EnumerableType s1 = v1[i1];
            EnumerableType s2 = v2[i2];
            switch (EnumerableSubtype.compareEnumerable(s1, s2)) {
                case 0: {
                    ++i1;
                    ++i2;
                    break;
                }
                case -1: {
                    result.add(s1);
                    ++i1;
                    break;
                }
                case 1: {
                    ++i2;
                }
            }
        }
    }

    public static int compareEnumerable(EnumerableType v1, EnumerableType v2) {
        if (v1 instanceof EnumerableString) {
            String s1 = ((EnumerableString)v1).value;
            String s2 = ((EnumerableString)v2).value;
            return Objects.equals(s1, s2) ? 0 : (Common.codePointCompare(s1, s2) ? -1 : 1);
        }
        if (v1 instanceof EnumerableCharString) {
            String s2 = ((EnumerableCharString)v2).value;
            String s1 = ((EnumerableCharString)v1).value;
            return Objects.equals(s1, s2) ? 0 : (Common.codePointCompare(s1, s2) ? -1 : 1);
        }
        if (v1 instanceof EnumerableDecimal) {
            BigDecimal d2 = ((EnumerableDecimal)v2).value;
            BigDecimal d1 = ((EnumerableDecimal)v1).value;
            return d1.compareTo(d2);
        }
        double f1 = ((EnumerableFloat)v1).value;
        double f2 = ((EnumerableFloat)v2).value;
        if (EnumerableSubtype.bFloatEq(f1, f2)) {
            return 0;
        }
        if (Double.isNaN(f1)) {
            return -1;
        }
        if (Double.isNaN(f2)) {
            return 1;
        }
        if (f1 < f2) {
            return -1;
        }
        return 1;
    }

    private static boolean bFloatEq(double f1, double f2) {
        if (Double.isNaN(f1)) {
            return Double.isNaN(f2);
        }
        return f1 == f2;
    }
}

