/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.Atom;
import io.ballerina.types.AtomicType;
import io.ballerina.types.CellSemType;
import java.util.Arrays;
import java.util.Objects;

public record MappingAtomicType(String[] names, CellSemType[] types, CellSemType rest) implements AtomicType
{
    private final String[] names;
    private final CellSemType[] types;

    public MappingAtomicType(String[] names, CellSemType[] types2, CellSemType rest) {
        this.names = Arrays.copyOf(names, names.length);
        this.types = Arrays.copyOf(types2, names.length);
        this.rest = rest;
    }

    public String[] names() {
        return Arrays.copyOf(this.names, this.names.length);
    }

    public CellSemType[] types() {
        return Arrays.copyOf(this.types, this.types.length);
    }

    public static MappingAtomicType from(String[] names, CellSemType[] types2, CellSemType rest) {
        return new MappingAtomicType(names, types2, rest);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MappingAtomicType)) {
            return false;
        }
        MappingAtomicType other = (MappingAtomicType)o;
        return Arrays.equals(this.names, other.names) && Arrays.equals(this.types, other.types) && Objects.equals(this.rest, other.rest);
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.names), Arrays.hashCode(this.types), this.rest);
    }

    @Override
    public Atom.Kind atomKind() {
        return Atom.Kind.MAPPING_ATOM;
    }

    @Override
    public String toString() {
        return "MappingAtomicType{names=" + Arrays.toString(this.names) + ", types=" + Arrays.toString(this.types) + ", rest=" + String.valueOf(this.rest) + "}";
    }
}

