/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.AtomicType;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.CellSemType;
import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.FixedLengthArray;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemTypes;
import io.ballerina.types.TypeAtom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public final class PredefinedTypeEnv {
    public static final PredefinedTypeEnv INSTANCE = new PredefinedTypeEnv();
    private final List<InitializedTypeAtom<CellAtomicType>> initializedCellAtoms = new ArrayList<InitializedTypeAtom<CellAtomicType>>();
    private final List<InitializedTypeAtom<ListAtomicType>> initializedListAtoms = new ArrayList<InitializedTypeAtom<ListAtomicType>>();
    private final List<InitializedTypeAtom<MappingAtomicType>> initializedMappingAtoms = new ArrayList<InitializedTypeAtom<MappingAtomicType>>();
    private final List<ListAtomicType> initializedRecListAtoms = new ArrayList<ListAtomicType>();
    private final List<MappingAtomicType> initializedRecMappingAtoms = new ArrayList<MappingAtomicType>();
    private final AtomicInteger nextAtomIndex = new AtomicInteger(0);
    private CellAtomicType cellAtomicVal;
    private CellAtomicType cellAtomicNever;
    private CellAtomicType callAtomicInner;
    private CellAtomicType cellAtomicInnerMapping;
    private ListAtomicType listAtomicMapping;
    private CellAtomicType cellAtomicInnerMappingRO;
    private ListAtomicType listAtomicMappingRO;
    private CellAtomicType cellAtomicInnerRO;
    private ListAtomicType listAtomicThreeElementRO;
    private CellAtomicType cellAtomicMappingArrayRO;
    private CellAtomicType cellAtomicUndef;
    private ListAtomicType listAtomicTwoElement;
    private CellAtomicType cellAtomicMappingArray;
    private ListAtomicType listAtomicThreeElement;
    private CellAtomicType cellAtomicObjectMember;
    private CellAtomicType cellAtomicObjectMemberKind;
    private CellAtomicType cellAtomicObjectMemberRO;
    private CellAtomicType cellAtomicObjectMemberVisibility;
    private CellAtomicType cellAtomicValRO;
    private ListAtomicType listAtomicRO;
    private MappingAtomicType mappingAtomicObject;
    private MappingAtomicType mappingAtomicObjectMember;
    private MappingAtomicType mappingAtomicObjectMemberRO;
    private MappingAtomicType mappingAtomicObjectRO;
    private MappingAtomicType mappingAtomicRO;
    private TypeAtom atomCellInner;
    private TypeAtom atomCellInnerMapping;
    private TypeAtom atomCellInnerMappingRO;
    private TypeAtom atomCellInnerRO;
    private TypeAtom atomCellNever;
    private TypeAtom atomCellObjectMember;
    private TypeAtom atomCellObjectMemberKind;
    private TypeAtom atomCellObjectMemberRO;
    private TypeAtom atomCellObjectMemberVisibility;
    private TypeAtom atomCellUndef;
    private TypeAtom atomCellVal;
    private TypeAtom atomCellValRO;
    private TypeAtom atomListMapping;
    private TypeAtom atomListMappingRO;
    private TypeAtom atomListTwoElement;
    private TypeAtom atomMappingObject;
    private TypeAtom atomMappingObjectMember;
    private TypeAtom atomMappingObjectMemberRO;
    private TypeAtom atomCellMappingArray;
    private TypeAtom atomCellMappingArrayRO;
    private TypeAtom atomListThreeElement;
    private TypeAtom atomListThreeElementRO;

    private PredefinedTypeEnv() {
    }

    public static PredefinedTypeEnv getInstance() {
        return INSTANCE;
    }

    private void addInitializedCellAtom(CellAtomicType atom) {
        this.addInitializedAtom(this.initializedCellAtoms, atom);
    }

    private void addInitializedListAtom(ListAtomicType atom) {
        this.addInitializedAtom(this.initializedListAtoms, atom);
    }

    private void addInitializedMapAtom(MappingAtomicType atom) {
        this.addInitializedAtom(this.initializedMappingAtoms, atom);
    }

    private <E extends AtomicType> void addInitializedAtom(Collection<? super InitializedTypeAtom<E>> atoms, E atom) {
        atoms.add(new InitializedTypeAtom<E>(atom, this.nextAtomIndex.getAndIncrement()));
    }

    private int cellAtomIndex(CellAtomicType atom) {
        return this.atomIndex(this.initializedCellAtoms, atom);
    }

    private int listAtomIndex(ListAtomicType atom) {
        return this.atomIndex(this.initializedListAtoms, atom);
    }

    private int mappingAtomIndex(MappingAtomicType atom) {
        return this.atomIndex(this.initializedMappingAtoms, atom);
    }

    private <E extends AtomicType> int atomIndex(List<InitializedTypeAtom<E>> initializedAtoms, E atom) {
        for (InitializedTypeAtom<E> initializedListAtom : initializedAtoms) {
            if (initializedListAtom.atomicType() != atom) continue;
            return initializedListAtom.index();
        }
        throw new IndexOutOfBoundsException();
    }

    synchronized CellAtomicType cellAtomicVal() {
        if (this.cellAtomicVal == null) {
            this.cellAtomicVal = CellAtomicType.from(PredefinedType.VAL, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
            this.addInitializedCellAtom(this.cellAtomicVal);
        }
        return this.cellAtomicVal;
    }

    synchronized TypeAtom atomCellVal() {
        if (this.atomCellVal == null) {
            CellAtomicType cellAtomicVal = this.cellAtomicVal();
            this.atomCellVal = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicVal), cellAtomicVal);
        }
        return this.atomCellVal;
    }

    synchronized CellAtomicType cellAtomicNever() {
        if (this.cellAtomicNever == null) {
            this.cellAtomicNever = CellAtomicType.from(PredefinedType.NEVER, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
            this.addInitializedCellAtom(this.cellAtomicNever);
        }
        return this.cellAtomicNever;
    }

    synchronized TypeAtom atomCellNever() {
        if (this.atomCellNever == null) {
            CellAtomicType cellAtomicNever = this.cellAtomicNever();
            this.atomCellNever = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicNever), cellAtomicNever);
        }
        return this.atomCellNever;
    }

    synchronized CellAtomicType cellAtomicInner() {
        if (this.callAtomicInner == null) {
            this.callAtomicInner = CellAtomicType.from(PredefinedType.INNER, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
            this.addInitializedCellAtom(this.callAtomicInner);
        }
        return this.callAtomicInner;
    }

    synchronized TypeAtom atomCellInner() {
        if (this.atomCellInner == null) {
            CellAtomicType cellAtomicInner = this.cellAtomicInner();
            this.atomCellInner = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicInner), cellAtomicInner);
        }
        return this.atomCellInner;
    }

    synchronized CellAtomicType cellAtomicInnerMapping() {
        if (this.cellAtomicInnerMapping == null) {
            this.cellAtomicInnerMapping = CellAtomicType.from(Core.union(PredefinedType.MAPPING, PredefinedType.UNDEF), CellAtomicType.CellMutability.CELL_MUT_LIMITED);
            this.addInitializedCellAtom(this.cellAtomicInnerMapping);
        }
        return this.cellAtomicInnerMapping;
    }

    synchronized TypeAtom atomCellInnerMapping() {
        if (this.atomCellInnerMapping == null) {
            CellAtomicType cellAtomicInnerMapping = this.cellAtomicInnerMapping();
            this.atomCellInnerMapping = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicInnerMapping), cellAtomicInnerMapping);
        }
        return this.atomCellInnerMapping;
    }

    synchronized CellAtomicType cellAtomicInnerMappingRO() {
        if (this.cellAtomicInnerMappingRO == null) {
            this.cellAtomicInnerMappingRO = CellAtomicType.from(Core.union(PredefinedType.MAPPING_RO, PredefinedType.UNDEF), CellAtomicType.CellMutability.CELL_MUT_LIMITED);
            this.addInitializedCellAtom(this.cellAtomicInnerMappingRO);
        }
        return this.cellAtomicInnerMappingRO;
    }

    synchronized TypeAtom atomCellInnerMappingRO() {
        if (this.atomCellInnerMappingRO == null) {
            CellAtomicType cellAtomicInnerMappingRO = this.cellAtomicInnerMappingRO();
            this.atomCellInnerMappingRO = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicInnerMappingRO), cellAtomicInnerMappingRO);
        }
        return this.atomCellInnerMappingRO;
    }

    synchronized ListAtomicType listAtomicMapping() {
        if (this.listAtomicMapping == null) {
            this.listAtomicMapping = ListAtomicType.from(FixedLengthArray.empty(), PredefinedType.CELL_SEMTYPE_INNER_MAPPING);
            this.addInitializedListAtom(this.listAtomicMapping);
        }
        return this.listAtomicMapping;
    }

    synchronized TypeAtom atomListMapping() {
        if (this.atomListMapping == null) {
            ListAtomicType listAtomicMapping = this.listAtomicMapping();
            this.atomListMapping = TypeAtom.createTypeAtom(this.listAtomIndex(listAtomicMapping), listAtomicMapping);
        }
        return this.atomListMapping;
    }

    synchronized ListAtomicType listAtomicMappingRO() {
        if (this.listAtomicMappingRO == null) {
            this.listAtomicMappingRO = ListAtomicType.from(FixedLengthArray.empty(), PredefinedType.CELL_SEMTYPE_INNER_MAPPING_RO);
            this.addInitializedListAtom(this.listAtomicMappingRO);
        }
        return this.listAtomicMappingRO;
    }

    synchronized TypeAtom atomListMappingRO() {
        if (this.atomListMappingRO == null) {
            ListAtomicType listAtomicMappingRO = this.listAtomicMappingRO();
            this.atomListMappingRO = TypeAtom.createTypeAtom(this.listAtomIndex(listAtomicMappingRO), listAtomicMappingRO);
        }
        return this.atomListMappingRO;
    }

    synchronized CellAtomicType cellAtomicInnerRO() {
        if (this.cellAtomicInnerRO == null) {
            this.cellAtomicInnerRO = CellAtomicType.from(PredefinedType.INNER_READONLY, CellAtomicType.CellMutability.CELL_MUT_NONE);
            this.addInitializedCellAtom(this.cellAtomicInnerRO);
        }
        return this.cellAtomicInnerRO;
    }

    synchronized TypeAtom atomCellInnerRO() {
        if (this.atomCellInnerRO == null) {
            CellAtomicType cellAtomicInnerRO = this.cellAtomicInnerRO();
            this.atomCellInnerRO = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicInnerRO), cellAtomicInnerRO);
        }
        return this.atomCellInnerRO;
    }

    synchronized CellAtomicType cellAtomicUndef() {
        if (this.cellAtomicUndef == null) {
            this.cellAtomicUndef = CellAtomicType.from(PredefinedType.UNDEF, CellAtomicType.CellMutability.CELL_MUT_NONE);
            this.addInitializedCellAtom(this.cellAtomicUndef);
        }
        return this.cellAtomicUndef;
    }

    synchronized TypeAtom atomCellUndef() {
        if (this.atomCellUndef == null) {
            CellAtomicType cellAtomicUndef = this.cellAtomicUndef();
            this.atomCellUndef = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicUndef), cellAtomicUndef);
        }
        return this.atomCellUndef;
    }

    synchronized ListAtomicType listAtomicTwoElement() {
        if (this.listAtomicTwoElement == null) {
            this.listAtomicTwoElement = ListAtomicType.from(FixedLengthArray.from(List.of(PredefinedType.CELL_SEMTYPE_VAL), 2), PredefinedType.CELL_SEMTYPE_UNDEF);
            this.addInitializedListAtom(this.listAtomicTwoElement);
        }
        return this.listAtomicTwoElement;
    }

    synchronized TypeAtom atomListTwoElement() {
        if (this.atomListTwoElement == null) {
            ListAtomicType listAtomicTwoElement = this.listAtomicTwoElement();
            this.atomListTwoElement = TypeAtom.createTypeAtom(this.listAtomIndex(listAtomicTwoElement), listAtomicTwoElement);
        }
        return this.atomListTwoElement;
    }

    synchronized CellAtomicType cellAtomicValRO() {
        if (this.cellAtomicValRO == null) {
            this.cellAtomicValRO = CellAtomicType.from(PredefinedType.VAL_READONLY, CellAtomicType.CellMutability.CELL_MUT_NONE);
            this.addInitializedCellAtom(this.cellAtomicValRO);
        }
        return this.cellAtomicValRO;
    }

    synchronized TypeAtom atomCellValRO() {
        if (this.atomCellValRO == null) {
            CellAtomicType cellAtomicValRO = this.cellAtomicValRO();
            this.atomCellValRO = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicValRO), cellAtomicValRO);
        }
        return this.atomCellValRO;
    }

    synchronized MappingAtomicType mappingAtomicObjectMemberRO() {
        if (this.mappingAtomicObjectMemberRO == null) {
            this.mappingAtomicObjectMemberRO = MappingAtomicType.from(new String[]{"kind", "value", "visibility"}, new CellSemType[]{PredefinedType.CELL_SEMTYPE_OBJECT_MEMBER_KIND, PredefinedType.CELL_SEMTYPE_VAL_RO, PredefinedType.CELL_SEMTYPE_OBJECT_MEMBER_VISIBILITY}, PredefinedType.CELL_SEMTYPE_UNDEF);
            this.addInitializedMapAtom(this.mappingAtomicObjectMemberRO);
        }
        return this.mappingAtomicObjectMemberRO;
    }

    synchronized TypeAtom atomMappingObjectMemberRO() {
        if (this.atomMappingObjectMemberRO == null) {
            MappingAtomicType mappingAtomicObjectMemberRO = this.mappingAtomicObjectMemberRO();
            this.atomMappingObjectMemberRO = TypeAtom.createTypeAtom(this.mappingAtomIndex(mappingAtomicObjectMemberRO), mappingAtomicObjectMemberRO);
        }
        return this.atomMappingObjectMemberRO;
    }

    synchronized CellAtomicType cellAtomicObjectMemberRO() {
        if (this.cellAtomicObjectMemberRO == null) {
            this.cellAtomicObjectMemberRO = CellAtomicType.from(PredefinedType.MAPPING_SEMTYPE_OBJECT_MEMBER_RO, CellAtomicType.CellMutability.CELL_MUT_NONE);
            this.addInitializedCellAtom(this.cellAtomicObjectMemberRO);
        }
        return this.cellAtomicObjectMemberRO;
    }

    synchronized TypeAtom atomCellObjectMemberRO() {
        if (this.atomCellObjectMemberRO == null) {
            CellAtomicType cellAtomicObjectMemberRO = this.cellAtomicObjectMemberRO();
            this.atomCellObjectMemberRO = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicObjectMemberRO), cellAtomicObjectMemberRO);
        }
        return this.atomCellObjectMemberRO;
    }

    synchronized CellAtomicType cellAtomicObjectMemberKind() {
        if (this.cellAtomicObjectMemberKind == null) {
            this.cellAtomicObjectMemberKind = CellAtomicType.from(Core.union(SemTypes.stringConst("field"), SemTypes.stringConst("method")), CellAtomicType.CellMutability.CELL_MUT_NONE);
            this.addInitializedCellAtom(this.cellAtomicObjectMemberKind);
        }
        return this.cellAtomicObjectMemberKind;
    }

    synchronized TypeAtom atomCellObjectMemberKind() {
        if (this.atomCellObjectMemberKind == null) {
            CellAtomicType cellAtomicObjectMemberKind = this.cellAtomicObjectMemberKind();
            this.atomCellObjectMemberKind = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicObjectMemberKind), cellAtomicObjectMemberKind);
        }
        return this.atomCellObjectMemberKind;
    }

    synchronized CellAtomicType cellAtomicObjectMemberVisibility() {
        if (this.cellAtomicObjectMemberVisibility == null) {
            this.cellAtomicObjectMemberVisibility = CellAtomicType.from(Core.union(SemTypes.stringConst("public"), SemTypes.stringConst("private")), CellAtomicType.CellMutability.CELL_MUT_NONE);
            this.addInitializedCellAtom(this.cellAtomicObjectMemberVisibility);
        }
        return this.cellAtomicObjectMemberVisibility;
    }

    synchronized TypeAtom atomCellObjectMemberVisibility() {
        if (this.atomCellObjectMemberVisibility == null) {
            CellAtomicType cellAtomicObjectMemberVisibility = this.cellAtomicObjectMemberVisibility();
            this.atomCellObjectMemberVisibility = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicObjectMemberVisibility), cellAtomicObjectMemberVisibility);
        }
        return this.atomCellObjectMemberVisibility;
    }

    synchronized MappingAtomicType mappingAtomicObjectMember() {
        if (this.mappingAtomicObjectMember == null) {
            this.mappingAtomicObjectMember = MappingAtomicType.from(new String[]{"kind", "value", "visibility"}, new CellSemType[]{PredefinedType.CELL_SEMTYPE_OBJECT_MEMBER_KIND, PredefinedType.CELL_SEMTYPE_VAL, PredefinedType.CELL_SEMTYPE_OBJECT_MEMBER_VISIBILITY}, PredefinedType.CELL_SEMTYPE_UNDEF);
            this.addInitializedMapAtom(this.mappingAtomicObjectMember);
        }
        return this.mappingAtomicObjectMember;
    }

    synchronized TypeAtom atomMappingObjectMember() {
        if (this.atomMappingObjectMember == null) {
            MappingAtomicType mappingAtomicObjectMember = this.mappingAtomicObjectMember();
            this.atomMappingObjectMember = TypeAtom.createTypeAtom(this.mappingAtomIndex(mappingAtomicObjectMember), mappingAtomicObjectMember);
        }
        return this.atomMappingObjectMember;
    }

    synchronized CellAtomicType cellAtomicObjectMember() {
        if (this.cellAtomicObjectMember == null) {
            this.cellAtomicObjectMember = CellAtomicType.from(PredefinedType.MAPPING_SEMTYPE_OBJECT_MEMBER, CellAtomicType.CellMutability.CELL_MUT_UNLIMITED);
            this.addInitializedCellAtom(this.cellAtomicObjectMember);
        }
        return this.cellAtomicObjectMember;
    }

    synchronized TypeAtom atomCellObjectMember() {
        if (this.atomCellObjectMember == null) {
            CellAtomicType cellAtomicObjectMember = this.cellAtomicObjectMember();
            this.atomCellObjectMember = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicObjectMember), cellAtomicObjectMember);
        }
        return this.atomCellObjectMember;
    }

    synchronized MappingAtomicType mappingAtomicObject() {
        if (this.mappingAtomicObject == null) {
            this.mappingAtomicObject = MappingAtomicType.from(new String[]{"$qualifiers"}, new CellSemType[]{PredefinedType.CELL_SEMTYPE_OBJECT_QUALIFIER}, PredefinedType.CELL_SEMTYPE_OBJECT_MEMBER);
            this.addInitializedMapAtom(this.mappingAtomicObject);
        }
        return this.mappingAtomicObject;
    }

    synchronized TypeAtom atomMappingObject() {
        if (this.atomMappingObject == null) {
            MappingAtomicType mappingAtomicObject = this.mappingAtomicObject();
            this.atomMappingObject = TypeAtom.createTypeAtom(this.mappingAtomIndex(mappingAtomicObject), mappingAtomicObject);
        }
        return this.atomMappingObject;
    }

    synchronized ListAtomicType listAtomicRO() {
        if (this.listAtomicRO == null) {
            this.listAtomicRO = ListAtomicType.from(FixedLengthArray.empty(), PredefinedType.CELL_SEMTYPE_INNER_RO);
            this.initializedRecListAtoms.add(this.listAtomicRO);
        }
        return this.listAtomicRO;
    }

    synchronized MappingAtomicType mappingAtomicRO() {
        if (this.mappingAtomicRO == null) {
            this.mappingAtomicRO = MappingAtomicType.from(new String[0], new CellSemType[0], PredefinedType.CELL_SEMTYPE_INNER_RO);
            this.initializedRecMappingAtoms.add(this.mappingAtomicRO);
        }
        return this.mappingAtomicRO;
    }

    synchronized MappingAtomicType getMappingAtomicObjectRO() {
        if (this.mappingAtomicObjectRO == null) {
            this.mappingAtomicObjectRO = MappingAtomicType.from(new String[]{"$qualifiers"}, new CellSemType[]{PredefinedType.CELL_SEMTYPE_OBJECT_QUALIFIER}, PredefinedType.CELL_SEMTYPE_OBJECT_MEMBER_RO);
            this.initializedRecMappingAtoms.add(this.mappingAtomicObjectRO);
        }
        return this.mappingAtomicObjectRO;
    }

    synchronized CellAtomicType cellAtomicMappingArray() {
        if (this.cellAtomicMappingArray == null) {
            this.cellAtomicMappingArray = CellAtomicType.from(PredefinedType.MAPPING_ARRAY, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
            this.addInitializedCellAtom(this.cellAtomicMappingArray);
        }
        return this.cellAtomicMappingArray;
    }

    synchronized TypeAtom atomCellMappingArray() {
        if (this.atomCellMappingArray == null) {
            CellAtomicType cellAtomicMappingArray = this.cellAtomicMappingArray();
            this.atomCellMappingArray = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicMappingArray), cellAtomicMappingArray);
        }
        return this.atomCellMappingArray;
    }

    synchronized CellAtomicType cellAtomicMappingArrayRO() {
        if (this.cellAtomicMappingArrayRO == null) {
            this.cellAtomicMappingArrayRO = CellAtomicType.from(PredefinedType.MAPPING_ARRAY_RO, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
            this.addInitializedCellAtom(this.cellAtomicMappingArrayRO);
        }
        return this.cellAtomicMappingArrayRO;
    }

    synchronized TypeAtom atomCellMappingArrayRO() {
        if (this.atomCellMappingArrayRO == null) {
            CellAtomicType cellAtomicMappingArrayRO = this.cellAtomicMappingArrayRO();
            this.atomCellMappingArrayRO = TypeAtom.createTypeAtom(this.cellAtomIndex(cellAtomicMappingArrayRO), cellAtomicMappingArrayRO);
        }
        return this.atomCellMappingArrayRO;
    }

    synchronized ListAtomicType listAtomicThreeElement() {
        if (this.listAtomicThreeElement == null) {
            this.listAtomicThreeElement = ListAtomicType.from(FixedLengthArray.from(List.of(PredefinedType.CELL_SEMTYPE_LIST_SUBTYPE_MAPPING, PredefinedType.CELL_SEMTYPE_VAL), 3), PredefinedType.CELL_SEMTYPE_UNDEF);
            this.addInitializedListAtom(this.listAtomicThreeElement);
        }
        return this.listAtomicThreeElement;
    }

    synchronized TypeAtom atomListThreeElement() {
        if (this.atomListThreeElement == null) {
            ListAtomicType listAtomicThreeElement = this.listAtomicThreeElement();
            this.atomListThreeElement = TypeAtom.createTypeAtom(this.listAtomIndex(listAtomicThreeElement), listAtomicThreeElement);
        }
        return this.atomListThreeElement;
    }

    synchronized ListAtomicType listAtomicThreeElementRO() {
        if (this.listAtomicThreeElementRO == null) {
            this.listAtomicThreeElementRO = ListAtomicType.from(FixedLengthArray.from(List.of(PredefinedType.CELL_SEMTYPE_LIST_SUBTYPE_MAPPING_RO, PredefinedType.CELL_SEMTYPE_VAL), 3), PredefinedType.CELL_SEMTYPE_UNDEF);
            this.addInitializedListAtom(this.listAtomicThreeElementRO);
        }
        return this.listAtomicThreeElementRO;
    }

    synchronized TypeAtom atomListThreeElementRO() {
        if (this.atomListThreeElementRO == null) {
            ListAtomicType listAtomicThreeElementRO = this.listAtomicThreeElementRO();
            this.atomListThreeElementRO = TypeAtom.createTypeAtom(this.listAtomIndex(listAtomicThreeElementRO), listAtomicThreeElementRO);
        }
        return this.atomListThreeElementRO;
    }

    final void initializeEnv(Env env) {
        this.fillRecAtoms(env.recListAtoms, this.initializedRecListAtoms);
        this.fillRecAtoms(env.recMappingAtoms, this.initializedRecMappingAtoms);
        this.initializedCellAtoms.forEach(each -> env.cellAtom((CellAtomicType)each.atomicType()));
        this.initializedListAtoms.forEach(each -> env.listAtom((ListAtomicType)each.atomicType()));
    }

    private <E extends AtomicType> void fillRecAtoms(List<E> envRecAtomList, List<E> initializedRecAtoms) {
        int count = this.reservedRecAtomCount();
        for (int i = 0; i < count; ++i) {
            if (i < initializedRecAtoms.size()) {
                envRecAtomList.add((AtomicType)initializedRecAtoms.get(i));
                continue;
            }
            envRecAtomList.add(null);
        }
    }

    public int reservedRecAtomCount() {
        return Integer.max(this.initializedRecListAtoms.size(), this.initializedRecMappingAtoms.size());
    }

    public Optional<RecAtom> getPredefinedRecAtom(int index) {
        if (this.isPredefinedRecAtom(index)) {
            return Optional.of(RecAtom.createRecAtom(index));
        }
        return Optional.empty();
    }

    public boolean isPredefinedRecAtom(int index) {
        return index >= 0 && index < this.reservedRecAtomCount();
    }

    private record InitializedTypeAtom<E extends AtomicType>(E atomicType, int index) {
    }
}

