/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.Atom;

public class RecAtom
implements Atom {
    public final int index;
    private Atom.Kind targetKind = null;
    public static final RecAtom ZERO = new RecAtom(0);

    private RecAtom(int index) {
        this.index = index;
    }

    private RecAtom(int index, Atom.Kind targetKind) {
        this.index = index;
        this.targetKind = targetKind;
    }

    public static RecAtom createRecAtom(int index) {
        if (index == 0) {
            return ZERO;
        }
        return new RecAtom(index);
    }

    public static RecAtom createXMLRecAtom(int index) {
        return new RecAtom(index, Atom.Kind.XML_ATOM);
    }

    public static RecAtom createDistinctRecAtom(int index) {
        return new RecAtom(index, Atom.Kind.DISTINCT_ATOM);
    }

    public void setKind(Atom.Kind targetKind) {
        this.targetKind = targetKind;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public Atom.Kind kind() {
        if (this.targetKind == null) {
            throw new IllegalStateException("Target kind is not set for the recursive type atom");
        }
        return this.targetKind;
    }

    public int hashCode() {
        if (this.targetKind == null) {
            return this.index;
        }
        return this.getIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)obj;
            return recAtom.index == this.index;
        }
        return false;
    }

    public String toString() {
        return "RecAtom{ index=" + this.index + ", targetKind=" + String.valueOf((Object)this.targetKind) + "}";
    }
}

