/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.subtypedata;

import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import java.util.Optional;

public class BooleanSubtype
implements ProperSubtypeData {
    public final boolean value;

    private BooleanSubtype(boolean value2) {
        this.value = value2;
    }

    public static BooleanSubtype from(boolean value2) {
        return new BooleanSubtype(value2);
    }

    public static boolean booleanSubtypeContains(SubtypeData d, boolean b) {
        if (d instanceof AllOrNothingSubtype) {
            AllOrNothingSubtype allOrNothingSubtype = (AllOrNothingSubtype)d;
            return allOrNothingSubtype.isAllSubtype();
        }
        BooleanSubtype r = (BooleanSubtype)d;
        return r.value == b;
    }

    public static SemType booleanConst(boolean value2) {
        BooleanSubtype t = BooleanSubtype.from(value2);
        return PredefinedType.basicSubtype(BasicTypeCode.BT_BOOLEAN, t);
    }

    public static Optional<Boolean> booleanSubtypeSingleValue(SubtypeData d) {
        if (d instanceof AllOrNothingSubtype) {
            return Optional.empty();
        }
        BooleanSubtype b = (BooleanSubtype)d;
        return Optional.of(b.value);
    }
}

