/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.BasicTypeOps;
import io.ballerina.types.Bdd;
import io.ballerina.types.Common;
import io.ballerina.types.Conjunction;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.FunctionAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.typeops.CommonOps;
import java.io.PrintStream;

public class FunctionOps
extends CommonOps
implements BasicTypeOps {
    private static final PrintStream console = System.out;

    @Override
    public boolean isEmpty(Context cx, SubtypeData t) {
        return Common.memoSubtypeIsEmpty(cx, cx.functionMemo, (context, bdd) -> Common.bddEvery(context, bdd, null, null, FunctionOps::functionFormulaIsEmpty), (Bdd)t);
    }

    private static boolean functionFormulaIsEmpty(Context cx, Conjunction pos, Conjunction neg) {
        return FunctionOps.functionPathIsEmpty(cx, FunctionOps.functionIntersectRet(cx, pos), FunctionOps.functionUnionParams(cx, pos), FunctionOps.functionUnionQualifiers(cx, pos), pos, neg);
    }

    private static boolean functionPathIsEmpty(Context cx, SemType rets, SemType params, SemType qualifiers, Conjunction pos, Conjunction neg) {
        if (neg == null) {
            return false;
        }
        FunctionAtomicType t = cx.functionAtomType(neg.atom);
        SemType t0 = t.paramType();
        SemType t1 = t.retType();
        SemType t2 = t.qualifiers();
        if (t.isGeneric()) {
            return Core.isSubtype(cx, qualifiers, t2) && Core.isSubtype(cx, params, t0) && Core.isSubtype(cx, rets, t1) || FunctionOps.functionPathIsEmpty(cx, rets, params, qualifiers, pos, neg.next);
        }
        return Core.isSubtype(cx, qualifiers, t2) && Core.isSubtype(cx, t0, params) && FunctionOps.functionPhi(cx, t0, Core.complement(t1), pos) || FunctionOps.functionPathIsEmpty(cx, rets, params, qualifiers, pos, neg.next);
    }

    private static boolean functionPhi(Context cx, SemType t0, SemType t1, Conjunction pos) {
        if (pos == null) {
            return !Core.isNever(t0) && (Core.isEmpty(cx, t0) || Core.isEmpty(cx, t1));
        }
        return FunctionOps.functionPhiInner(cx, t0, t1, pos);
    }

    private static boolean functionPhiInner(Context cx, SemType t0, SemType t1, Conjunction pos) {
        if (pos == null) {
            return Core.isEmpty(cx, t0) || Core.isEmpty(cx, t1);
        }
        FunctionAtomicType s = cx.functionAtomType(pos.atom);
        SemType s0 = s.paramType();
        SemType s1 = s.retType();
        return (Core.isSubtype(cx, t0, s0) || Core.isSubtype(cx, FunctionOps.functionIntersectRet(cx, pos.next), Core.complement(t1))) && FunctionOps.functionPhiInner(cx, t0, Core.intersect(t1, s1), pos.next) && FunctionOps.functionPhiInner(cx, Core.diff(t0, s0), t1, pos.next);
    }

    private static SemType functionUnionParams(Context cx, Conjunction pos) {
        if (pos == null) {
            return PredefinedType.NEVER;
        }
        return Core.union(cx.functionAtomType(pos.atom).paramType(), FunctionOps.functionUnionParams(cx, pos.next));
    }

    private static SemType functionUnionQualifiers(Context cx, Conjunction pos) {
        if (pos == null) {
            return PredefinedType.NEVER;
        }
        return Core.union(cx.functionAtomType(pos.atom).qualifiers(), FunctionOps.functionUnionQualifiers(cx, pos.next));
    }

    private static SemType functionIntersectRet(Context cx, Conjunction pos) {
        if (pos == null) {
            return PredefinedType.VAL;
        }
        return Core.intersect(cx.functionAtomType(pos.atom).retType(), FunctionOps.functionIntersectRet(cx, pos.next));
    }

    private boolean functionTheta(Context cx, SemType t0, SemType t1, Conjunction pos) {
        if (pos == null) {
            return Core.isEmpty(cx, t0) || Core.isEmpty(cx, t1);
        }
        FunctionAtomicType s = cx.functionAtomType(pos.atom);
        SemType s0 = s.paramType();
        SemType s1 = s.retType();
        return !(!Core.isSubtype(cx, t0, s0) && !this.functionTheta(cx, Core.diff(s0, t0), s1, pos.next) || !Core.isSubtype(cx, t1, Core.complement(s1)) && !this.functionTheta(cx, s0, Core.intersect(s1, t1), pos.next));
    }
}

