/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.Atom;
import io.ballerina.types.BasicTypeOps;
import io.ballerina.types.Bdd;
import io.ballerina.types.CellSemType;
import io.ballerina.types.Common;
import io.ballerina.types.Conjunction;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.FixedLengthArray;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.Range;
import io.ballerina.types.typeops.CommonOps;
import io.ballerina.types.typeops.IntOps;
import io.ballerina.types.typeops.TwoTuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;

public class ListOps
extends CommonOps
implements BasicTypeOps {
    static boolean listSubtypeIsEmpty(Context cx, SubtypeData t) {
        return Common.memoSubtypeIsEmpty(cx, cx.listMemo, (context, bdd) -> Common.bddEvery(context, bdd, null, null, ListOps::listFormulaIsEmpty), (Bdd)t);
    }

    private static boolean listFormulaIsEmpty(Context cx, Conjunction pos, Conjunction neg) {
        CellSemType rest;
        FixedLengthArray members;
        if (pos == null) {
            ListAtomicType atom = PredefinedType.LIST_ATOMIC_INNER;
            members = atom.members();
            rest = atom.rest();
        } else {
            ListAtomicType lt = cx.listAtomType(pos.atom);
            members = lt.members();
            rest = lt.rest();
            Conjunction p = pos.next;
            if (p != null || neg != null) {
                members = ListOps.fixedArrayShallowCopy(members);
            }
            while (p != null) {
                Atom d = p.atom;
                p = p.next;
                lt = cx.listAtomType(d);
                TwoTuple<FixedLengthArray, CellSemType> intersected = ListOps.listIntersectWith(cx.env, members, rest, lt.members(), lt.rest());
                if (intersected == null) {
                    return true;
                }
                members = (FixedLengthArray)intersected.item1;
                rest = (CellSemType)intersected.item2;
            }
            if (ListOps.fixedArrayAnyEmpty(cx, members)) {
                return true;
            }
        }
        List<Integer> indices = ListOps.listSamples(cx, members, rest, neg);
        TwoTuple<List<CellSemType>, Integer> sampleTypes = ListOps.listSampleTypes(cx, members, rest, indices);
        return !ListOps.listInhabited(cx, indices.toArray(new Integer[0]), (SemType[])((List)sampleTypes.item1).toArray(SemType[]::new), (Integer)sampleTypes.item2, neg);
    }

    public static TwoTuple<List<CellSemType>, Integer> listSampleTypes(Context cx, FixedLengthArray members, CellSemType rest, List<Integer> indices) {
        int index;
        CellSemType t;
        ArrayList<CellSemType> memberTypes = new ArrayList<CellSemType>();
        int nRequired = 0;
        for (int i = 0; i < indices.size() && !Core.isEmpty(cx, t = Core.cellContainingInnerVal(cx.env, ListOps.listMemberAt(members, rest, index = indices.get(i).intValue()))); ++i) {
            memberTypes.add(t);
            if (index >= members.fixedLength()) continue;
            nRequired = i + 1;
        }
        return TwoTuple.from(memberTypes, nRequired);
    }

    static List<Integer> listSamples(Context cx, FixedLengthArray members, SemType rest, Conjunction neg) {
        int maxInitialLength = members.initial().size();
        ArrayList<Integer> fixedLengths = new ArrayList<Integer>();
        fixedLengths.add(members.fixedLength());
        Conjunction tem = neg;
        int nNeg = 0;
        while (tem != null) {
            ListAtomicType lt = cx.listAtomType(tem.atom);
            FixedLengthArray m = lt.members();
            maxInitialLength = Integer.max(maxInitialLength, m.initial().size());
            if (m.fixedLength() > maxInitialLength) {
                fixedLengths.add(m.fixedLength());
            }
            ++nNeg;
            tem = tem.next;
        }
        Collections.sort(fixedLengths);
        ArrayList<Integer> boundaries = new ArrayList<Integer>();
        for (int i = 1; i <= maxInitialLength; ++i) {
            boundaries.add(i);
        }
        Iterator i = fixedLengths.iterator();
        while (i.hasNext()) {
            int n = (Integer)i.next();
            if (boundaries.size() != 0 && n <= (Integer)boundaries.get(boundaries.size() - 1)) continue;
            boundaries.add(n);
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int lastBoundary = 0;
        if (nNeg == 0) {
            nNeg = 1;
        }
        Iterator iterator2 = boundaries.iterator();
        while (iterator2.hasNext()) {
            int b = (Integer)iterator2.next();
            int segmentLength = b - lastBoundary;
            int nSamples = Integer.min(segmentLength, nNeg);
            for (int i2 = b - nSamples; i2 < b; ++i2) {
                indices.add(i2);
            }
            lastBoundary = b;
        }
        for (int i3 = 0; i3 < nNeg && lastBoundary <= Integer.MAX_VALUE - i3; ++i3) {
            indices.add(lastBoundary + i3);
        }
        return indices;
    }

    static TwoTuple<FixedLengthArray, CellSemType> listIntersectWith(Env env, FixedLengthArray members1, CellSemType rest1, FixedLengthArray members2, CellSemType rest2) {
        if (ListOps.listLengthsDisjoint(members1, rest1, members2, rest2)) {
            return null;
        }
        int max = Integer.max(members1.fixedLength(), members2.fixedLength());
        List<CellSemType> initial = IntStream.range(0, max).mapToObj(i -> Core.intersectMemberSemTypes(env, ListOps.listMemberAt(members1, rest1, i), ListOps.listMemberAt(members2, rest2, i))).toList();
        return TwoTuple.from(FixedLengthArray.from(initial, Integer.max(members1.fixedLength(), members2.fixedLength())), Core.intersectMemberSemTypes(env, rest1, rest2));
    }

    static FixedLengthArray fixedArrayShallowCopy(FixedLengthArray array2) {
        return FixedLengthArray.from(array2.initial(), array2.fixedLength());
    }

    static boolean listInhabited(Context cx, Integer[] indices, SemType[] memberTypes, int nRequired, Conjunction neg) {
        SemType[] t;
        int i;
        if (neg == null) {
            return true;
        }
        ListAtomicType nt = cx.listAtomType(neg.atom);
        if (nRequired > 0 && Core.isNever(ListOps.listMemberAtInnerVal(nt.members(), nt.rest(), indices[nRequired - 1]))) {
            return ListOps.listInhabited(cx, indices, memberTypes, nRequired, neg.next);
        }
        int negLen = nt.members().fixedLength();
        if (negLen > 0) {
            int index;
            for (i = 0; i < memberTypes.length && (index = indices[i].intValue()) < negLen; ++i) {
                CellSemType negMemberType = ListOps.listMemberAt(nt.members(), nt.rest(), index);
                SemType common = Core.intersect(memberTypes[i], negMemberType);
                if (!Core.isEmpty(cx, common)) continue;
                return ListOps.listInhabited(cx, indices, memberTypes, nRequired, neg.next);
            }
            int len = memberTypes.length;
            if (len < indices.length && indices[len] < negLen) {
                return ListOps.listInhabited(cx, indices, memberTypes, nRequired, neg.next);
            }
            for (int i2 = nRequired; i2 < memberTypes.length && indices[i2] < negLen; ++i2) {
                t = Arrays.copyOfRange(memberTypes, 0, i2);
                if (!ListOps.listInhabited(cx, indices, t, nRequired, neg.next)) continue;
                return true;
            }
        }
        for (i = 0; i < memberTypes.length; ++i) {
            SemType d = Core.diff(memberTypes[i], ListOps.listMemberAt(nt.members(), nt.rest(), indices[i]));
            if (Core.isEmpty(cx, d)) continue;
            t = (SemType[])memberTypes.clone();
            t[i] = d;
            if (!ListOps.listInhabited(cx, indices, t, Integer.max(nRequired, i + 1), neg.next)) continue;
            return true;
        }
        return false;
    }

    static SemType listMemberAtInnerVal(FixedLengthArray fixedArray, CellSemType rest, int index) {
        return Core.cellInnerVal(ListOps.listMemberAt(fixedArray, rest, index));
    }

    private static boolean listLengthsDisjoint(FixedLengthArray members1, CellSemType rest1, FixedLengthArray members2, CellSemType rest2) {
        int len2;
        int len1 = members1.fixedLength();
        if (len1 < (len2 = members2.fixedLength())) {
            return Core.isNever(Core.cellInnerVal(rest1));
        }
        if (len2 < len1) {
            return Core.isNever(Core.cellInnerVal(rest2));
        }
        return false;
    }

    static CellSemType listMemberAt(FixedLengthArray fixedArray, CellSemType rest, int index) {
        if (index < fixedArray.fixedLength()) {
            return ListOps.fixedArrayGet(fixedArray, index);
        }
        return rest;
    }

    static boolean fixedArrayAnyEmpty(Context cx, FixedLengthArray array2) {
        for (CellSemType t : array2.initial()) {
            if (!Core.isEmpty(cx, t)) continue;
            return true;
        }
        return false;
    }

    private static CellSemType fixedArrayGet(FixedLengthArray members, int index) {
        int memberLen = members.initial().size();
        int i = Integer.min(index, memberLen - 1);
        return members.initial().get(i);
    }

    static SemType listAtomicMemberTypeInnerVal(ListAtomicType atomic, SubtypeData key) {
        return Core.diff(ListOps.listAtomicMemberTypeInner(atomic, key), PredefinedType.UNDEF);
    }

    private static SemType listAtomicMemberTypeInner(ListAtomicType atomic, SubtypeData key) {
        return ListOps.listAtomicMemberTypeAtInner(atomic.members(), atomic.rest(), key);
    }

    static SemType listAtomicMemberTypeAtInner(FixedLengthArray fixedArray, CellSemType rest, SubtypeData key) {
        if (key instanceof IntSubtype) {
            IntSubtype intSubtype = (IntSubtype)key;
            SemType m = PredefinedType.NEVER;
            int initLen = fixedArray.initial().size();
            int fixedLen = fixedArray.fixedLength();
            if (fixedLen != 0) {
                for (int i = 0; i < initLen; ++i) {
                    if (!IntSubtype.intSubtypeContains(key, i)) continue;
                    m = Core.union(m, Core.cellInner(ListOps.fixedArrayGet(fixedArray, i)));
                }
                if (IntOps.intSubtypeOverlapRange(intSubtype, Range.from(initLen, fixedLen - 1))) {
                    m = Core.union(m, Core.cellInner(ListOps.fixedArrayGet(fixedArray, fixedLen - 1)));
                }
            }
            if (fixedLen == 0 || IntOps.intSubtypeMax((IntSubtype)key) > (long)(fixedLen - 1)) {
                m = Core.union(m, Core.cellInner(rest));
            }
            return m;
        }
        SemType m = Core.cellInner(rest);
        if (fixedArray.fixedLength() > 0) {
            for (CellSemType ty : fixedArray.initial()) {
                m = Core.union(m, Core.cellInner(ty));
            }
        }
        return m;
    }

    public static SemType bddListMemberTypeInnerVal(Context cx, Bdd b, SubtypeData key, SemType accum) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return allOrNothing.isAll() ? accum : PredefinedType.NEVER;
        }
        BddNode bddNode = (BddNode)b;
        return Core.union(ListOps.bddListMemberTypeInnerVal(cx, bddNode.left(), key, Core.intersect(ListOps.listAtomicMemberTypeInnerVal(cx.listAtomType(bddNode.atom()), key), accum)), Core.union(ListOps.bddListMemberTypeInnerVal(cx, bddNode.middle(), key, accum), ListOps.bddListMemberTypeInnerVal(cx, bddNode.right(), key, accum)));
    }

    @Override
    public SubtypeData union(SubtypeData d1, SubtypeData d2) {
        return Common.bddSubtypeUnion(d1, d2);
    }

    @Override
    public SubtypeData intersect(SubtypeData d1, SubtypeData d2) {
        return Common.bddSubtypeIntersect(d1, d2);
    }

    @Override
    public SubtypeData diff(SubtypeData d1, SubtypeData d2) {
        return Common.bddSubtypeDiff(d1, d2);
    }

    @Override
    public SubtypeData complement(SubtypeData d) {
        return Common.bddSubtypeComplement(d);
    }

    @Override
    public boolean isEmpty(Context cx, SubtypeData d) {
        return ListOps.listSubtypeIsEmpty(cx, d);
    }
}

