/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.impl.mixin;

import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class CoreNodeMixin
implements CoreNode {
    int flags;

    @Override
    public Class<? extends CoreNode> coreGetNodeClass() {
        return this.coreGetNodeType().getInterface();
    }

    @Override
    public final CoreDocument coreGetOwnerDocument(boolean create) {
        CoreNode root = this.getRootOrOwnerDocument();
        if (root instanceof CoreDocument) {
            return (CoreDocument)root;
        }
        if (create) {
            CoreDocument ownerDocument = root.coreGetNodeFactory().getFactory2().createDocument();
            root.coreSetOwnerDocument(ownerDocument);
            return ownerDocument;
        }
        return null;
    }

    @Override
    public final boolean coreHasSameOwnerDocument(CoreNode other) {
        return other.getRootOrOwnerDocument() == this.getRootOrOwnerDocument();
    }

    @Override
    public final boolean internalGetFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    public final void internalSetFlag(int flag, boolean value2) {
        this.flags = value2 ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    @Override
    public final int internalGetFlags(int mask) {
        return this.flags & mask;
    }

    @Override
    public final void internalSetFlags(int mask, int value2) {
        this.flags = this.flags & ~mask | value2;
    }

    public final <T> CoreNode shallowClone(ClonePolicy<T> policy, T options) throws CoreModelException {
        CoreNode clone = this.coreGetNodeFactory().createNode(policy.getTargetNodeClass(options, this));
        clone.init(policy, options, this);
        clone.initAncillaryData(policy, options, this);
        return clone;
    }

    @Override
    public final <T> CoreNode internalClone(ClonePolicy<T> policy, T options, CoreParentNode targetParent) throws CoreModelException {
        CoreNode clone = this.shallowClone(policy, options);
        if (targetParent != null) {
            targetParent.coreAppendChild((CoreChildNode)clone);
        }
        policy.postProcess(options, clone);
        this.cloneChildrenIfNecessary(policy, options, clone);
        return clone;
    }

    @Override
    public final <T> CoreNode coreClone(ClonePolicy<T> policy, T options) throws CoreModelException {
        return this.internalClone(policy, options, null);
    }

    @Override
    public <T> void initAncillaryData(ClonePolicy<T> policy, T options, CoreNode other) {
    }
}

