/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.stax.pull.output;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlReader;
import org.apache.axiom.core.stream.stax.StAXExceptionUtil;
import org.apache.axiom.core.stream.stax.pull.output.DummyLocation;
import org.apache.axiom.core.stream.stax.pull.output.InternalXMLStreamReader;
import org.apache.axiom.core.stream.stax.pull.output.XMLStreamReaderExtensionFactory;
import org.apache.axiom.core.stream.util.CharacterDataAccumulator;
import org.apache.axiom.util.xml.QNameCache;
import org.apache.axiom.util.xml.stream.XMLEventUtils;

public final class StAXPivot
implements InternalXMLStreamReader,
XmlHandler {
    private static final int STATE_DEFAULT = 0;
    private static final int STATE_EVENT_COMPLETE = 1;
    private static final int STATE_COLLECT_TEXT = 2;
    private static final int STATE_COALESCE_CDATA_SECTION = 3;
    private static final int STATE_NEXT_TAG = 4;
    private static final int STATE_SKIP_CONTENT = 5;
    private static final int STATE_ERROR = 6;
    private final XMLStreamReaderExtensionFactory extensionFactory;
    private XmlReader reader;
    private Map<String, Object> extensions;
    private int state = 0;
    private int previousState = -1;
    private int eventType = -1;
    private int depth;
    private String[] elementStack = new String[24];
    private String[] namespaceStack = new String[16];
    private String[] attributeStack = new String[40];
    private int[] scopeStack = new int[8];
    private int attributeCount;
    private CharacterDataAccumulator accumulator;
    private NamespaceContextImpl namespaceContext;
    private String encoding;
    private String version;
    private String characterEncodingScheme;
    private Boolean standalone;
    private String rootName;
    private String publicId;
    private String systemId;
    private Object characterData;
    private String text;
    private String name;

    public StAXPivot(XMLStreamReaderExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    private static String emptyToNull(String value2) {
        return value2 == null || value2.isEmpty() ? null : value2;
    }

    private static String nullToEmpty(String value2) {
        return value2 == null ? "" : value2;
    }

    public void setReader(XmlReader reader) throws StreamException {
        this.reader = reader;
        while (this.state != 1) {
            reader.proceed();
        }
    }

    public void setPrefix(String prefix, String namespaceURI) {
        if (this.depth != 0) {
            throw new IllegalStateException();
        }
        int n = this.scopeStack[0];
        this.scopeStack[0] = n + 1;
        this.putNamespaceDeclaration(n, prefix, namespaceURI);
    }

    private void putNamespaceDeclaration(int index, String prefix, String namespaceURI) {
        if (index * 2 == this.namespaceStack.length) {
            String[] newNamespaceStack = new String[this.namespaceStack.length * 2];
            System.arraycopy(this.namespaceStack, 0, newNamespaceStack, 0, this.namespaceStack.length);
            this.namespaceStack = newNamespaceStack;
        }
        this.namespaceStack[2 * index] = prefix;
        this.namespaceStack[2 * index + 1] = namespaceURI;
    }

    private void checkState() {
        if (this.state == 1) {
            throw new IllegalStateException();
        }
    }

    private void startCollectingText() {
        this.state = 2;
        if (this.accumulator == null) {
            this.accumulator = new CharacterDataAccumulator();
        }
    }

    private String stopCollectingText() {
        String data = this.accumulator.toString();
        this.accumulator.clear();
        this.state = 1;
        return data;
    }

    @Override
    public void startDocument(String inputEncoding, String xmlVersion, String xmlEncoding, Boolean standalone) throws StreamException {
        this.checkState();
        this.eventType = 7;
        this.encoding = inputEncoding;
        this.version = xmlVersion;
        this.characterEncodingScheme = xmlEncoding;
        this.standalone = standalone;
        this.state = 1;
    }

    @Override
    public void startFragment() throws StreamException {
        this.checkState();
        this.eventType = 7;
        this.state = 1;
    }

    @Override
    public void processDocumentTypeDeclaration(String rootName, String publicId, String systemId, String internalSubset) throws StreamException {
        this.checkState();
        this.eventType = 11;
        this.rootName = rootName;
        this.publicId = publicId;
        this.systemId = systemId;
        this.text = internalSubset;
        this.state = 1;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        this.checkState();
        this.eventType = 1;
        if (this.state == 4) {
            this.state = 0;
        }
        if (this.depth * 3 == this.elementStack.length) {
            String[] newElementStack = new String[this.elementStack.length * 2];
            System.arraycopy(this.elementStack, 0, newElementStack, 0, this.elementStack.length);
            this.elementStack = newElementStack;
        }
        this.elementStack[this.depth * 3] = namespaceURI;
        this.elementStack[this.depth * 3 + 1] = localName;
        this.elementStack[this.depth * 3 + 2] = prefix;
        if (this.depth + 1 == this.scopeStack.length) {
            int[] newScopeStack = new int[this.scopeStack.length * 2];
            System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
            this.scopeStack = newScopeStack;
        }
        this.scopeStack[this.depth + 1] = this.scopeStack[this.depth];
        this.attributeCount = 0;
    }

    @Override
    public void endElement() throws StreamException {
        this.checkState();
        this.eventType = 2;
        --this.depth;
        this.state = 1;
    }

    @Override
    public void processAttribute(String namespaceURI, String localName, String prefix, String value2, String type, boolean specified) throws StreamException {
        if (this.attributeCount * 5 == this.attributeStack.length) {
            String[] newAttributeStack = new String[this.attributeStack.length * 2];
            System.arraycopy(this.attributeStack, 0, newAttributeStack, 0, this.attributeStack.length);
            this.attributeStack = newAttributeStack;
        }
        this.attributeStack[5 * this.attributeCount] = namespaceURI;
        this.attributeStack[5 * this.attributeCount + 1] = localName;
        this.attributeStack[5 * this.attributeCount + 2] = prefix;
        this.attributeStack[5 * this.attributeCount + 3] = value2;
        this.attributeStack[5 * this.attributeCount + 4] = type;
        ++this.attributeCount;
    }

    @Override
    public void processAttribute(String name, String value2, String type, boolean specified) throws StreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processNamespaceDeclaration(String prefix, String namespaceURI) throws StreamException {
        int n = this.depth + 1;
        int n2 = this.scopeStack[n];
        this.scopeStack[n] = n2 + 1;
        this.putNamespaceDeclaration(n2, prefix, namespaceURI);
    }

    @Override
    public void attributesCompleted() throws StreamException {
        this.state = 1;
    }

    @Override
    public void processCharacterData(Object data, boolean ignorable) throws StreamException {
        switch (this.state) {
            case 0: {
                this.eventType = ignorable ? 6 : 4;
                this.characterData = data;
                this.state = 1;
                return;
            }
            case 2: 
            case 3: {
                this.accumulator.append(data);
                return;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void startProcessingInstruction(String target) throws StreamException {
        switch (this.state) {
            case 0: {
                this.eventType = 3;
                this.name = target;
                this.startCollectingText();
                break;
            }
            case 2: 
            case 4: {
                this.previousState = this.state;
                this.state = 5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void endProcessingInstruction() throws StreamException {
        switch (this.state) {
            case 2: {
                this.text = this.stopCollectingText();
                break;
            }
            case 5: {
                this.state = this.previousState;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void startComment() throws StreamException {
        switch (this.state) {
            case 0: {
                this.eventType = 5;
                this.startCollectingText();
                break;
            }
            case 2: 
            case 4: {
                this.previousState = this.state;
                this.state = 5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void endComment() throws StreamException {
        switch (this.state) {
            case 2: {
                this.text = this.stopCollectingText();
                break;
            }
            case 5: {
                this.state = this.previousState;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void startCDATASection() throws StreamException {
        switch (this.state) {
            case 0: {
                this.eventType = 12;
                this.startCollectingText();
                break;
            }
            case 2: {
                this.state = 3;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void endCDATASection() throws StreamException {
        switch (this.state) {
            case 2: {
                this.text = this.stopCollectingText();
                break;
            }
            case 3: {
                this.state = 2;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void processEntityReference(String name, String replacementText) throws StreamException {
        switch (this.state) {
            case 0: {
                this.eventType = 9;
                this.name = name;
                this.text = replacementText;
                this.state = 1;
                break;
            }
            case 2: {
                this.accumulator.append(replacementText);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void completed() throws StreamException {
        this.checkState();
        this.eventType = 8;
        this.state = 1;
    }

    @Override
    public boolean drain() throws StreamException {
        return true;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        Object extension;
        if (this.extensions != null && (extension = this.extensions.get(name)) != null) {
            return extension;
        }
        if (this.extensionFactory != null && (extension = this.extensionFactory.createExtension(name, this)) != null) {
            if (this.extensions == null) {
                this.extensions = new HashMap<String, Object>();
            }
            this.extensions.put(name, extension);
            return extension;
        }
        return null;
    }

    @Override
    public int next() throws XMLStreamException {
        try {
            switch (this.state) {
                case 1: {
                    this.state = 0;
                    break;
                }
                case 6: {
                    throw new IllegalStateException();
                }
            }
            switch (this.eventType) {
                case 4: 
                case 6: {
                    this.characterData = null;
                }
                case 3: 
                case 5: 
                case 9: 
                case 11: 
                case 12: {
                    this.text = null;
                    break;
                }
                case 1: {
                    ++this.depth;
                    break;
                }
                case 8: {
                    throw new NoSuchElementException();
                }
            }
            while (this.state != 1) {
                this.reader.proceed();
            }
            return this.eventType;
        }
        catch (StreamException ex) {
            this.state = 6;
            throw StAXExceptionUtil.toXMLStreamException(ex);
        }
        catch (RuntimeException ex) {
            this.state = 6;
            throw ex;
        }
        catch (Error ex) {
            this.state = 6;
            throw ex;
        }
    }

    @Override
    public void require(int expectedType, String expectedNamespaceURI, String expectedLocalName) throws XMLStreamException {
        if (expectedType != this.eventType) {
            throw new XMLStreamException("Required type " + XMLEventUtils.getEventTypeString(expectedType) + ", actual type " + XMLEventUtils.getEventTypeString(this.eventType));
        }
        if (expectedLocalName != null) {
            if (this.eventType != 1 && this.eventType != 2 && this.eventType != 9) {
                throw new XMLStreamException("Required a non-null local name, but current token not a START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE (was " + XMLEventUtils.getEventTypeString(this.eventType) + ")");
            }
            String localName = this.getLocalName();
            if (!localName.equals(expectedLocalName)) {
                throw new XMLStreamException("Required local name '" + expectedLocalName + "'; current local name '" + localName + "'.");
            }
        }
        if (expectedNamespaceURI != null) {
            if (this.eventType != 1 && this.eventType != 2) {
                throw new XMLStreamException("Required non-null namespace URI, but current token not a START_ELEMENT or END_ELEMENT (was " + XMLEventUtils.getEventTypeString(this.eventType) + ")");
            }
            String namespaceURI = this.elementStack[3 * this.depth];
            if (!expectedNamespaceURI.equals(namespaceURI)) {
                throw new XMLStreamException("Required namespace '" + expectedNamespaceURI + "'; have '" + namespaceURI + "'.");
            }
        }
    }

    @Override
    public String getEncoding() {
        if (this.eventType == 7) {
            return this.encoding;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getCharacterEncodingScheme() {
        if (this.eventType == 7) {
            return this.characterEncodingScheme;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isStandalone() {
        if (this.eventType == 7) {
            return this.standalone != null && this.standalone != false;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        this.startCollectingText();
        switch (this.next()) {
            case 2: {
                return this.stopCollectingText();
            }
            case 1: {
                throw new XMLStreamException("Element text content may not contain START_ELEMENT");
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        this.state = 4;
        return this.next();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.eventType != 8;
    }

    @Override
    public void close() throws XMLStreamException {
        this.reader.dispose();
    }

    int getNamespaceBindingsCount() {
        return this.scopeStack[this.eventType == 1 || this.eventType == 2 ? this.depth + 1 : this.depth];
    }

    String lookupNamespaceURI(String prefix) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (int i = (this.getNamespaceBindingsCount() - 1) * 2; i >= 0; i -= 2) {
            if (!prefix.equals(this.namespaceStack[i])) continue;
            return this.namespaceStack[i + 1];
        }
        return prefix.isEmpty() ? "" : null;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return StAXPivot.emptyToNull(this.lookupNamespaceURI(StAXPivot.nullToEmpty(prefix)));
    }

    @Override
    public boolean isStartElement() {
        return this.eventType == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.eventType == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.eventType == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        switch (this.getEventType()) {
            case 6: {
                return true;
            }
            case 4: {
                String text = this.internalGetText();
                for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int getAttributeCount() {
        if (this.eventType == 1) {
            return this.attributeCount;
        }
        throw new IllegalStateException();
    }

    @Override
    public QName getAttributeName(int index) {
        if (this.eventType == 1) {
            return QNameCache.getQName(this.attributeStack[5 * index], this.attributeStack[5 * index + 1], this.attributeStack[5 * index + 2]);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (this.eventType == 1) {
            return StAXPivot.emptyToNull(this.attributeStack[5 * index]);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeLocalName(int index) {
        if (this.eventType == 1) {
            return this.attributeStack[5 * index + 1];
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributePrefix(int index) {
        if (this.eventType == 1) {
            return StAXPivot.emptyToNull(this.attributeStack[5 * index + 2]);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeValue(int index) {
        if (this.eventType == 1) {
            return this.attributeStack[5 * index + 3];
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeType(int index) {
        if (this.eventType == 1) {
            return this.attributeStack[5 * index + 4];
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        if (this.eventType == 1) {
            return true;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        if (this.eventType == 1) {
            namespaceURI = StAXPivot.nullToEmpty(namespaceURI);
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!localName.equals(this.attributeStack[i * 5 + 1]) || !namespaceURI.equals(this.attributeStack[i * 5])) continue;
                return this.attributeStack[i * 5 + 3];
            }
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public int getNamespaceCount() {
        switch (this.eventType) {
            case 1: 
            case 2: {
                return this.scopeStack[this.depth + 1] - this.scopeStack[this.depth];
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getNamespacePrefix(int index) {
        switch (this.eventType) {
            case 1: 
            case 2: {
                return StAXPivot.emptyToNull(this.namespaceStack[2 * (this.scopeStack[this.depth] + index)]);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getNamespaceURI(int index) {
        switch (this.eventType) {
            case 1: 
            case 2: {
                return this.namespaceStack[2 * (this.scopeStack[this.depth] + index) + 1];
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (this.namespaceContext == null) {
            this.namespaceContext = new NamespaceContextImpl();
        }
        return this.namespaceContext;
    }

    @Override
    public int getEventType() {
        return this.eventType;
    }

    private String internalGetText() {
        if (this.text == null && this.characterData != null) {
            this.text = this.characterData.toString();
        }
        return this.text;
    }

    @Override
    public String getText() {
        switch (this.eventType) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                return this.internalGetText();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public char[] getTextCharacters() {
        switch (this.eventType) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return this.internalGetText().toCharArray();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        String text = this.internalGetText();
        int copied = Math.min(length, text.length() - sourceStart);
        text.getChars(sourceStart, sourceStart + copied, target, targetStart);
        return copied;
    }

    @Override
    public int getTextStart() {
        switch (this.eventType) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextLength() {
        switch (this.eventType) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return this.internalGetText().length();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean hasText() {
        return this.eventType == 4 || this.eventType == 11 || this.eventType == 12 || this.eventType == 9 || this.eventType == 5 || this.eventType == 6;
    }

    @Override
    public Location getLocation() {
        return DummyLocation.INSTANCE;
    }

    @Override
    public QName getName() {
        switch (this.eventType) {
            case 1: 
            case 2: {
                return QNameCache.getQName(this.elementStack[3 * this.depth], this.elementStack[3 * this.depth + 1], this.elementStack[3 * this.depth + 2]);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean hasName() {
        return this.eventType == 1 || this.eventType == 2;
    }

    @Override
    public String getNamespaceURI() {
        switch (this.eventType) {
            case 1: 
            case 2: {
                return StAXPivot.emptyToNull(this.elementStack[3 * this.depth]);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getLocalName() {
        switch (this.eventType) {
            case 1: 
            case 2: {
                return StAXPivot.emptyToNull(this.elementStack[3 * this.depth + 1]);
            }
            case 9: {
                return this.name;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getPrefix() {
        switch (this.eventType) {
            case 1: 
            case 2: {
                return this.elementStack[3 * this.depth + 2];
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean standaloneSet() {
        if (this.eventType == 7) {
            return this.standalone != null;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getPITarget() {
        if (this.eventType == 3) {
            return this.name;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getPIData() {
        if (this.eventType == 3) {
            return this.text;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public Object getCharacterData() {
        return this.characterData;
    }

    private class NamespaceContextImpl
    implements NamespaceContext {
        private NamespaceContextImpl() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException();
            }
            String namespaceURI = StAXPivot.this.lookupNamespaceURI(prefix);
            return namespaceURI == null ? "" : namespaceURI;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if (namespaceURI == null) {
                throw new IllegalArgumentException();
            }
            if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                return "xml";
            }
            if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                return "xmlns";
            }
            int bindings = StAXPivot.this.getNamespaceBindingsCount();
            block0: for (int i = (bindings - 1) * 2; i >= 0; i -= 2) {
                if (!namespaceURI.equals(StAXPivot.this.namespaceStack[i + 1])) continue;
                String prefix = StAXPivot.this.namespaceStack[i];
                for (int j = i + 2; j < bindings * 2; j += 2) {
                    if (prefix.equals(StAXPivot.this.namespaceStack[j])) continue block0;
                }
                return prefix;
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(final String namespaceURI) {
            if (namespaceURI == null) {
                throw new IllegalArgumentException("namespaceURI can't be null");
            }
            if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                return Collections.singleton("xml").iterator();
            }
            if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                return Collections.singleton("xmlns").iterator();
            }
            final int bindings = StAXPivot.this.getNamespaceBindingsCount();
            return new Iterator<String>(){
                private int binding;
                private String next;
                {
                    this.binding = bindings;
                }

                @Override
                public boolean hasNext() {
                    if (this.next == null) {
                        block0: while (--this.binding >= 0) {
                            if (!namespaceURI.equals(StAXPivot.this.namespaceStack[this.binding * 2 + 1])) continue;
                            String prefix = StAXPivot.this.namespaceStack[this.binding * 2];
                            for (int j = this.binding + 1; j < bindings; ++j) {
                                if (prefix.equals(StAXPivot.this.namespaceStack[j * 2])) continue block0;
                            }
                            this.next = prefix;
                            break;
                        }
                    }
                    return this.next != null;
                }

                @Override
                public String next() {
                    if (this.hasNext()) {
                        String result = this.next;
                        this.next = null;
                        return result;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

