/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.dom.DOMCharacterData;
import org.apache.axiom.dom.DOMConfigurationImpl;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMLeafNode;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.dom.DOMText;
import org.apache.axiom.dom.DOMTextNode;
import org.apache.axiom.dom.EmptyNodeList;
import org.apache.axiom.mime.PartDataHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.dom.CoreChildNodeImpl;
import org.apache.axiom.om.impl.intf.AxiomText;
import org.apache.axiom.om.impl.intf.TextContent;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class DOMTextNodeImpl
extends CoreChildNodeImpl
implements DOMTextNode,
Text,
AxiomText,
OMText,
OMNode,
OMSerializable,
OMInformationItem,
DOMCharacterData,
DOMLeafNode {
    public DOMTextNodeImpl() {
        this.init$DOMTextNodeMixin();
        this.init$AxiomTextMixin();
        this.init$DOMCharacterDataMixin();
        this.init$DOMLeafNodeMixin();
    }

    private void init$DOMTextNodeMixin() {
    }

    private void init$AxiomTextMixin() {
    }

    private void init$DOMCharacterDataMixin() {
    }

    private void init$DOMLeafNodeMixin() {
    }

    private DOMTextNode getWholeTextStartNode() {
        CoreChildNode sibling;
        DOMTextNode first = this;
        while ((sibling = first.coreGetPreviousSibling()) instanceof DOMTextNode) {
            first = (DOMTextNode)sibling;
        }
        return first;
    }

    private DOMTextNode getWholeTextEndNode() {
        try {
            CoreChildNode sibling;
            DOMTextNode last = this;
            while ((sibling = last.coreGetNextSibling()) instanceof DOMTextNode) {
                last = (DOMTextNode)sibling;
            }
            return last;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String getWholeText() {
        try {
            DOMTextNode first = this.getWholeTextStartNode();
            DOMTextNode last = this.getWholeTextEndNode();
            if (first == last) {
                return first.getData();
            }
            StringBuilder buffer = new StringBuilder();
            DOMTextNode current = first;
            while (true) {
                buffer.append(current.getData());
                if (current == last) break;
                current = (DOMTextNode)current.coreGetNextSibling();
            }
            return buffer.toString();
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Text replaceWholeText(String content) throws DOMException {
        try {
            DOMText newText;
            if (content.length() > 0) {
                newText = this.getDOMNodeFactory().createCharacterDataNode();
                newText.coreSetCharacterData(content);
            } else {
                newText = null;
            }
            if (this.coreHasParent()) {
                DOMTextNode next2;
                DOMTextNode first = this.getWholeTextStartNode();
                DOMTextNode last = this.getWholeTextEndNode();
                if (newText != null) {
                    first.coreInsertSiblingBefore(newText);
                }
                DOMTextNode current = first;
                do {
                    next2 = current == last ? null : (DOMTextNode)current.coreGetNextSibling();
                    current.coreDetach(DOMSemantics.INSTANCE);
                    current = next2;
                } while (next2 != null);
            }
            return newText;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Text splitText(int offset) throws DOMException {
        try {
            String value2 = this.getData();
            if (offset < 0 || offset > value2.length()) {
                throw DOMExceptionUtil.newDOMException((short)1);
            }
            String newValue = value2.substring(offset);
            this.deleteData(offset, value2.length());
            DOMText newText = this.getDOMNodeFactory().createCharacterDataNode();
            newText.coreSetCharacterData(newValue);
            if (this.coreHasParent()) {
                this.coreInsertSiblingAfter(newText);
            } else {
                newText.coreSetOwnerDocument(this.coreGetOwnerDocument(true));
            }
            return newText;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    public String toString() {
        String value2 = this.getData();
        return value2 != null ? value2 : "";
    }

    private TextContent getTextContent(boolean force) {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return (TextContent)content;
            }
            if (force) {
                TextContent textContent = new TextContent((String)content);
                this.coreSetCharacterData(textContent, AxiomSemantics.INSTANCE);
                return textContent;
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final boolean isBinary() {
        TextContent textContent = this.getTextContent(false);
        return textContent != null && textContent.isBinary();
    }

    @Override
    public final void setBinary(boolean binary) {
        TextContent textContent = this.getTextContent(binary);
        if (textContent != null) {
            textContent.setBinary(binary);
        }
    }

    @Override
    public final boolean isOptimized() {
        TextContent textContent = this.getTextContent(false);
        return textContent != null && textContent.isOptimize();
    }

    @Override
    public final void setOptimize(boolean optimize) {
        TextContent textContent = this.getTextContent(optimize);
        if (textContent != null) {
            textContent.setOptimize(optimize);
        }
    }

    @Override
    public final String getText() throws OMException {
        try {
            return this.coreGetCharacterData().toString();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final char[] getTextCharacters() {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return ((TextContent)content).toCharArray();
            }
            return ((String)content).toCharArray();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final boolean isCharacters() {
        return false;
    }

    @Override
    public final QName getTextAsQName() throws OMException {
        return ((OMElement)this.getParent()).resolveQName(this.getText());
    }

    @Override
    public final OMNamespace getNamespace() {
        QName qname = this.getTextAsQName();
        if (qname == null) {
            return null;
        }
        String namespaceURI = qname.getNamespaceURI();
        return namespaceURI.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, qname.getPrefix());
    }

    @Override
    public final DataHandler getDataHandler() {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return ((TextContent)content).getDataHandler();
            }
            throw new OMException("No DataHandler available");
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final String getContentID() {
        return this.getTextContent(true).getContentID();
    }

    @Override
    public final void buildWithAttachments() {
        DataHandler dataHandler;
        if (this.isOptimized() && (dataHandler = this.getDataHandler()) instanceof PartDataHandler) {
            ((PartDataHandler)dataHandler).getPart().fetch();
        }
    }

    @Override
    public final void setContentID(String cid) {
        this.getTextContent(true).setContentID(cid);
    }

    @Override
    public final String getData() {
        try {
            return this.coreGetCharacterData().toString();
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final void setData(String data) {
        try {
            this.coreSetCharacterData(data, DOMSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String getNodeValue() {
        return this.getData();
    }

    @Override
    public final void setNodeValue(String nodeValue) {
        this.setData(nodeValue);
    }

    @Override
    public final int getLength() {
        String data = this.getData();
        return data != null ? data.length() : 0;
    }

    @Override
    public final void appendData(String arg) {
        this.setData(this.getData() + arg);
    }

    @Override
    public final void deleteData(int offset, int count) {
        this.replaceData(offset, count, null);
    }

    @Override
    public final void replaceData(int offset, int count, String arg) {
        String data = this.getData();
        int length = data.length();
        if (offset < 0 || offset > length || count < 0) {
            throw DOMExceptionUtil.newDOMException((short)1);
        }
        int end = Math.min(count + offset, length);
        if (arg == null) {
            this.setData(new StringBuilder(data).delete(offset, end).toString());
        } else {
            this.setData(new StringBuilder(data).replace(offset, end, arg).toString());
        }
    }

    @Override
    public final void insertData(int offset, String arg) {
        String data = this.getData();
        if (offset < 0 || offset > data.length()) {
            throw DOMExceptionUtil.newDOMException((short)1);
        }
        this.setData(new StringBuilder(data).insert(offset, arg).toString());
    }

    @Override
    public final String substringData(int offset, int count) {
        String data = this.getData();
        int length = data.length();
        if (offset < 0 || offset > length || count < 0) {
            throw DOMExceptionUtil.newDOMException((short)1);
        }
        return data.substring(offset, Math.min(count + offset, length));
    }

    @Override
    public final Document getOwnerDocument() {
        return (Document)((Object)this.coreGetOwnerDocument(true));
    }

    @Override
    public final String getPrefix() {
        return null;
    }

    @Override
    public final void setPrefix(String prefix) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)14);
    }

    @Override
    public final String getNamespaceURI() {
        return null;
    }

    @Override
    public final String getLocalName() {
        return null;
    }

    @Override
    public final boolean hasChildNodes() {
        return false;
    }

    @Override
    public final Node getFirstChild() {
        return null;
    }

    @Override
    public final Node getLastChild() {
        return null;
    }

    @Override
    public final NodeList getChildNodes() {
        return EmptyNodeList.INSTANCE;
    }

    @Override
    public final Node appendChild(Node newChild) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)3);
    }

    @Override
    public final Node removeChild(Node oldChild) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)8);
    }

    @Override
    public final Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)3);
    }

    @Override
    public final Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)3);
    }

    @Override
    public final boolean hasAttributes() {
        return false;
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public final String getTextContent() {
        return this.getNodeValue();
    }

    @Override
    public final void setTextContent(String textContent) {
        this.setNodeValue(textContent);
    }

    @Override
    public final CoreElement getNamespaceContext() {
        return this.coreGetParentElement();
    }

    @Override
    public final void normalizeRecursively(DOMConfigurationImpl config) {
    }
}

